/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public class CacheHandler
implements Runnable {
    public static final int STRAT_LOCAL = 0;
    public static final int STRAT_DISK = 3;
    public static final int STRAT_NONE = -1;
    public static final int STRAT_REFRESH = 11;
    public static final int STRAT_REFRESH_RECURS = 12;
    public static final int STRAT_REFRESHING = 10;
    public static final int STRAT_DISK_OR_REFRESH = 5;
    public static final int STRAT_DISK_OR_REFRESH_RECURS = 6;
    private static CacheHandler instance = null;
    private ArrayList listeners = new ArrayList();
    private HashMap cacheMap = new HashMap();
    private HashMap persistentData = new HashMap();
    private ReferenceQueue cacheQueue;
    private Map cacheFilesHolder = Collections.synchronizedMap(new WeakHashMap());

    private CacheHandler() {
        this.cacheQueue = new ReferenceQueue();
        RequestProcessor requestProcessor = new RequestProcessor("VCS Cache Poll Request Processor");
        requestProcessor.post((Runnable)this);
    }

    public static synchronized CacheHandler getInstance() {
        if (instance == null) {
            instance = new CacheHandler();
        }
        return instance;
    }

    ReferenceQueue getCacheFileReferenceQueue() {
        return this.cacheQueue;
    }

    void addReferencedData(Reference reference, CacheFile.PersistentData persistentData) {
        this.persistentData.put(reference, persistentData);
    }

    CacheFile.PersistentData getReferencedData(Reference reference) {
        return (CacheFile.PersistentData)this.persistentData.get(reference);
    }

    public void run() {
        while (true) {
            Reference reference;
            try {
                reference = this.cacheQueue.remove();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            CacheFile.PersistentData persistentData = (CacheFile.PersistentData)this.persistentData.get(reference);
            if (persistentData == null) continue;
            try {
                persistentData.writeToDisk();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, "Data can not be written to the disk cache."));
            }
            this.persistentData.remove(reference);
        }
    }

    public Reference createReference(Object object, File file, String string) {
        CacheFile cacheFile = this.getCacheFile(file, -1, string);
        if (cacheFile != null) {
            this.addCacheLocker(object, cacheFile);
        }
        CacheReference cacheReference = new CacheReference(object, file, string);
        return cacheReference;
    }

    public final void addCacheLocker(Object object, CacheFile cacheFile) {
        if (object == null) {
            return;
        }
        HashSet<CacheFile> hashSet = (HashSet<CacheFile>)this.cacheFilesHolder.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<CacheFile>();
            this.cacheFilesHolder.put(object, hashSet);
        }
        hashSet.add(cacheFile);
    }

    public final void removeCacheLocker(Object object, CacheFile cacheFile) {
        Set set = (Set)this.cacheFilesHolder.get(object);
        if (set != null) {
            set.remove(cacheFile);
            if (set.isEmpty()) {
                this.cacheFilesHolder.remove(object);
            }
        }
    }

    public CacheFile getCacheFile(File file, int n, CachedFileSystem cachedFileSystem) {
        return this.getCacheFile(file, n, cachedFileSystem.getCacheId());
    }

    public CacheFile getCacheFile(File file, int n, String string) {
        return this.getCacheFile(file, n, string, null);
    }

    public CacheFile getCacheFile(File file, int n, String string, Object object) {
        FileSystemCache fileSystemCache = this.getCache(string);
        if (fileSystemCache == null) {
            return null;
        }
        return fileSystemCache.getCacheFile(file, n, object);
    }

    public void registerCacheType(String string, FileSystemCache fileSystemCache) {
        this.cacheMap.put(string, fileSystemCache);
    }

    public void unregistedType(String string) {
        this.cacheMap.remove(string);
    }

    public FileSystemCache getCache(CachedFileSystem cachedFileSystem) {
        FileSystemCache fileSystemCache = (FileSystemCache)this.cacheMap.get(cachedFileSystem.getCacheId());
        return fileSystemCache;
    }

    public FileSystemCache getCache(String string) {
        FileSystemCache fileSystemCache = (FileSystemCache)this.cacheMap.get(string);
        return fileSystemCache;
    }

    public void uninstall() {
        if (this.cacheMap != null) {
            Iterator iterator = this.cacheMap.values().iterator();
            while (iterator.hasNext()) {
                FileSystemCache fileSystemCache = (FileSystemCache)iterator.next();
                fileSystemCache.removeAllListeners();
            }
            this.cacheMap.clear();
            this.cacheMap = null;
        }
        instance = null;
    }
}

