/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import org.netbeans.modules.vcscore.cache.CacheFile;

public class CacheHandlerEvent
extends EventObject {
    private boolean recursive = false;
    private boolean ignoreList = false;
    private static final long serialVersionUID = 385684866008914174L;

    public CacheHandlerEvent(CacheFile cacheFile) {
        this(cacheFile, false);
    }

    public CacheHandlerEvent(CacheFile cacheFile, boolean bl) {
        this(cacheFile, bl, false);
    }

    public CacheHandlerEvent(CacheFile cacheFile, boolean bl, boolean bl2) {
        super(cacheFile);
        this.recursive = bl;
        this.ignoreList = bl2;
    }

    public CacheHandlerEvent(Set set) {
        this(set, false);
    }

    public CacheHandlerEvent(Set set, boolean bl) {
        this(set, bl, false);
    }

    public CacheHandlerEvent(Set set, boolean bl, boolean bl2) {
        super(Collections.unmodifiableSet(set));
        this.recursive = bl;
        this.ignoreList = bl2;
    }

    public CacheFile getCacheFile() {
        Object object = this.getSource();
        if (object instanceof CacheFile) {
            return (CacheFile)object;
        }
        Set set = (Set)object;
        if (set.size() > 0) {
            return (CacheFile)set.iterator().next();
        }
        return null;
    }

    public Set getCacheFiles() {
        Object object = this.getSource();
        if (object instanceof Set) {
            return (Set)object;
        }
        return Collections.singleton(object);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isIgnoreListChange() {
        return this.ignoreList;
    }
}

