/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;

public abstract class FileSystemCache {
    protected boolean isSaved = false;
    protected String identifier;
    private ArrayList listeners = new ArrayList();
    public static final int EVENT_ADD = 0;
    public static final int EVENT_REMOVE = 1;
    public static final int EVENT_CHANGED = 2;
    public static final int EVENT_CHANGED_RECURSIVELY = 3;
    public static final int EVENT_CHANGED_IGNORE_LIST = 4;
    private HashMap lockedFileObjects;
    private HashMap locks;

    public FileSystemCache(String string) {
        this.identifier = string;
        this.lockedFileObjects = new HashMap();
        this.locks = new HashMap();
    }

    public String getId() {
        return this.identifier;
    }

    public boolean isWrittenToDisk() {
        return this.isSaved;
    }

    public abstract void writeAllToDisk();

    public abstract CacheFile getCacheFile(File var1, int var2, Object var3);

    public abstract void registerDir(CacheDir var1);

    public abstract void unregisterDir(CacheDir var1);

    public abstract CacheDir getDir(String var1);

    protected boolean doesStrategyApply(CacheDir cacheDir, int n, int n2) {
        if (cacheDir.getAppliedLevel() >= n2) {
            return false;
        }
        if (n < n2) {
            return false;
        }
        if (n <= cacheDir.getAppliedLevel()) {
            return false;
        }
        return n < 10 || n2 <= 0 || n == n2;
    }

    protected void loadDir(CacheDir cacheDir, int n, Object object) {
        if (cacheDir == null) {
            return;
        }
        if (n == 11 || n == 12) {
            boolean bl;
            cacheDir.setAppliedLevel(-1);
            boolean bl2 = bl = n == 12;
            if (bl) {
                cacheDir.removeAll(bl);
            } else {
                cacheDir.removeFiles();
            }
        }
        if (this.doesStrategyApply(cacheDir, n, 0)) {
            cacheDir.populateWithLocal(object);
        }
        if (cacheDir.isLocal()) {
            return;
        }
        if (n == 6) {
            this.loadFromDiskOrRefreshRecursively(cacheDir, object);
            return;
        }
        if (this.doesStrategyApply(cacheDir, n, 3) && !cacheDir.readFromDisk(object) && n == 5) {
            cacheDir.checkServer(object);
        }
        if (this.doesStrategyApply(cacheDir, n, 11)) {
            cacheDir.checkServer(object);
        }
        if (this.doesStrategyApply(cacheDir, n, 10)) {
            cacheDir.setAppliedLevel(10);
        }
        if (this.doesStrategyApply(cacheDir, n, 12)) {
            cacheDir.checkServerRecursive(object);
        }
    }

    protected void loadFromDiskOrRefreshRecursively(CacheDir cacheDir, Object object) {
        if (!cacheDir.readFromDisk(object)) {
            cacheDir.checkServerRecursive(object);
        } else {
            CacheDir[] cacheDirArray = cacheDir.getSubDirs();
            int n = 0;
            while (n < cacheDirArray.length) {
                this.loadFromDiskOrRefreshRecursively(cacheDirArray[n], object);
                ++n;
            }
        }
    }

    public void addCacheHandlerListener(CacheHandlerListener cacheHandlerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(cacheHandlerListener);
    }

    public void removeCacheHandlerListener(CacheHandlerListener cacheHandlerListener) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(cacheHandlerListener);
        }
    }

    void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void fireCacheHandlerEvent(int n, CacheFile cacheFile) {
        CacheHandlerEvent cacheHandlerEvent = new CacheHandlerEvent(cacheFile, n == 3);
        this.fireCacheHandlerEvent(n, cacheHandlerEvent);
    }

    public void fireCacheHandlerEvent(int n, CacheHandlerEvent cacheHandlerEvent) {
        ArrayList arrayList;
        FileSystemCache fileSystemCache = this;
        synchronized (fileSystemCache) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (n == 2 || n == 3) {
                ((CacheHandlerListener)arrayList.get(n2)).statusChanged(cacheHandlerEvent);
            }
            if (n == 0) {
                ((CacheHandlerListener)arrayList.get(n2)).cacheAdded(cacheHandlerEvent);
            }
            if (n == 1) {
                ((CacheHandlerListener)arrayList.get(n2)).cacheRemoved(cacheHandlerEvent);
            }
            ++n2;
        }
    }
}

