/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;

public class RefreshCommandSupport {
    public static final int ELEMENT_INDEX_FILE_NAME = 0;
    public static final int ELEMENT_INDEX_STATUS = 1;
    public static final int ELEMENT_INDEX_LOCKER = 2;
    public static final int ELEMENT_INDEX_REVISION = 3;
    public static final int ELEMENT_INDEX_STICKY = 4;
    public static final int ELEMENT_INDEX_ATTR = 5;
    public static final int ELEMENT_INDEX_SIZE = 6;
    public static final int ELEMENT_INDEX_DATE = 7;
    public static final int ELEMENT_INDEX_TIME = 8;
    public static final int NUM_ELEMENTS = 9;
    public static final String ANNOTATION_PATTERN_FILE_NAME = "fileName";
    public static final String ANNOTATION_PATTERN_STATUS = "status";
    public static final String ANNOTATION_PATTERN_LOCKER = "locker";
    public static final String ANNOTATION_PATTERN_REVISION = "revision";
    public static final String ANNOTATION_PATTERN_STICKY = "sticky";
    public static final String ANNOTATION_PATTERN_ATTR = "attribute";
    public static final String ANNOTATION_PATTERN_SIZE = "size";
    public static final String ANNOTATION_PATTERN_DATE = "date";
    public static final String ANNOTATION_PATTERN_TIME = "time";
    public static final int MULTI_FILES_ANNOTATION_EMPTY = 0;
    public static final int MULTI_FILES_ANNOTATION_LIST = 1;
    public static final int MULTI_FILES_ANNOTATION_NOT_SYNCH_ATTR = 2;
    public static final String DEFAULT_ANNOTATION_PATTERN = "${fileName}$[? status] [ [${status}$[? revision] [; ${revision}] []]] [$[? revision] [ ${revision}] []]$[? locker][ (${locker})] []$[? sticky][ (${sticky})] []";
    public static final int[] DEFAULT_MULTI_FILES_ANNOTATION_TYPES = new int[]{2, 1, 0, 0, 0, 0, 0, 0, 0};
    public static final String DEFAULT_MULTI_FILES_ANNOTATION_DELIMETER = ", ";
    private static final String DIRECTORY_CACHE_ID = "D";
    private static String local = null;

    private RefreshCommandSupport() {
    }

    public static String getFileName(String[] stringArray) {
        if (stringArray.length < 9) {
            return null;
        }
        return stringArray[0];
    }

    public static CacheFile matchToFile(String[] stringArray, String string, File file) {
        if (stringArray.length < 9) {
            throw new IllegalArgumentException("The number of elements (" + stringArray.length + ") < " + 9);
        }
        CacheFile cacheFile = new VcsCacheFile(string);
        String string2 = stringArray[0];
        if (string2 == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        cacheFile.setName(string2);
        if (string2.endsWith("/") && (cacheFile = CacheHandler.getInstance().getCacheFile(new File(file, string2.substring(0, string2.length() - 1)), 10, string)) == null) {
            cacheFile = new VcsCacheDir(string, new File(file, string2.substring(0, string2.length() - 1)));
        }
        RefreshCommandSupport.matchToFile(stringArray, cacheFile);
        return cacheFile;
    }

    public static CacheFile matchToExistingFile(String[] stringArray, String string, File file) {
        CacheFile cacheFile;
        if (stringArray.length < 9) {
            throw new IllegalArgumentException("The number of elements (" + stringArray.length + ") < " + 9);
        }
        String string2 = stringArray[0];
        if (string2 == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        boolean bl = string2.endsWith("/");
        if (bl) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((cacheFile = CacheHandler.getInstance().getCacheFile(new File(file, string2), 10, string)) == null) {
            cacheFile = bl ? new VcsCacheDir(string, new File(file, string2)) : new VcsCacheFile(string);
            cacheFile.setName(string2);
        }
        RefreshCommandSupport.matchToFile(stringArray, cacheFile);
        if (cacheFile instanceof VcsCacheFile) {
            ((VcsCacheFile)cacheFile).setLocal(false);
        }
        if (cacheFile instanceof VcsCacheDir) {
            ((VcsCacheDir)cacheFile).setLocal(false);
        }
        return cacheFile;
    }

    public static CacheFile matchToFile(String[] stringArray, CacheFile cacheFile) {
        RefreshCommandSupport.matchToFile(stringArray, (VcsCacheFile.VcsPersistentData)cacheFile.getPersistentData());
        return cacheFile;
    }

    public static VcsCacheFile.VcsPersistentData matchToFile(String[] stringArray, VcsCacheFile.VcsPersistentData vcsPersistentData) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        if (stringArray.length < 9) {
            throw new IllegalArgumentException("The number of elements (" + stringArray.length + ") < " + 9);
        }
        String string8 = stringArray[1];
        if (string8 != null) {
            vcsPersistentData.setStatus(string8.trim());
        }
        if ((string7 = stringArray[2]) != null) {
            vcsPersistentData.setLocker(string7.trim());
        }
        if ((string6 = stringArray[3]) != null) {
            vcsPersistentData.setRevision(string6.trim());
        }
        if ((string5 = stringArray[4]) != null) {
            vcsPersistentData.setSticky(string5.trim());
        }
        if ((string4 = stringArray[5]) != null) {
            vcsPersistentData.setAttr(string4.trim());
        }
        if ((string3 = stringArray[7]) != null) {
            vcsPersistentData.setDate(string3.trim());
        }
        if ((string2 = stringArray[8]) != null) {
            vcsPersistentData.setTime(string2.trim());
        }
        if ((string = stringArray[6]) != null) {
            try {
                vcsPersistentData.setSize(Integer.parseInt(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                vcsPersistentData.setSize(0);
            }
        }
        return vcsPersistentData;
    }

    public static String[] makeElements(CacheFile cacheFile) {
        return RefreshCommandSupport.makeElements((VcsCacheFile.VcsPersistentData)cacheFile.getPersistentData());
    }

    public static String[] makeElements(VcsCacheFile.VcsPersistentData vcsPersistentData) {
        String[] stringArray = new String[9];
        stringArray[0] = vcsPersistentData.getName();
        stringArray[1] = vcsPersistentData.getStatus();
        stringArray[2] = vcsPersistentData.getLocker();
        stringArray[3] = vcsPersistentData.getRevision();
        stringArray[4] = vcsPersistentData.getSticky();
        stringArray[5] = vcsPersistentData.getAttr();
        stringArray[7] = vcsPersistentData.getDate();
        stringArray[8] = vcsPersistentData.getTime();
        stringArray[6] = Integer.toString(vcsPersistentData.getSize());
        return stringArray;
    }

    public static String[] getElementsFromLine(String string) {
        boolean bl = false;
        int n = 0;
        if (string.charAt(n) == '/') {
            ++n;
        }
        String[] stringArray = new String[9];
        int n2 = 0;
        while (n < string.length() && n2 < 9) {
            String string2;
            int n3 = string.indexOf(47, n);
            if (n3 < 0) break;
            if (n3 > 0 && string.substring(n3 - 1).startsWith(" // ")) {
                int n4;
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = n;
                int n6 = n3 - 1;
                while (true) {
                    if (n5 < n6) {
                        stringBuffer.append(string.substring(n5, n6));
                    }
                    stringBuffer.append('/');
                    n4 = string.indexOf(47, n6 + " // ".length());
                    int n7 = string.indexOf(" // ", n6 + " // ".length());
                    n5 = n6 + " // ".length();
                    if (n7 < 0 || n7 >= n4) break;
                    n6 = n7;
                }
                n6 = n4 > 0 ? n4 : string.length();
                stringBuffer.append(string.substring(n5, n6));
                string2 = stringBuffer.toString();
                n3 = n6 + " // ".length();
            } else {
                string2 = new String(string.substring(n, n3));
            }
            n = n3 + 1;
            if (n2 == 0 && DIRECTORY_CACHE_ID.equals(string2)) {
                bl = true;
                --n2;
            } else {
                stringArray[n2] = string2;
            }
            ++n2;
        }
        if (bl) {
            stringArray[0] = stringArray[0] + "/";
        }
        return stringArray;
    }

    public static String getLineFromElements(String[] stringArray) {
        if (stringArray.length < 9) {
            return null;
        }
        boolean bl = stringArray[0].endsWith("/");
        String string = bl ? stringArray[0].substring(0, stringArray[0].length() - 1) : stringArray[0];
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(DIRECTORY_CACHE_ID);
        }
        stringBuffer.append('/');
        stringBuffer.append(RefreshCommandSupport.adjustElement(string));
        stringBuffer.append('/');
        int n = 1;
        while (n < 9) {
            stringBuffer.append(RefreshCommandSupport.adjustElement(stringArray[n]));
            stringBuffer.append('/');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String adjustElement(String string) {
        int n = string.indexOf(47);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n >= 0 && n < string.length()) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(" // ");
            n2 = n + 1;
            n = string.indexOf(47, n2);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String getStatusAnnotation(String string, String string2, String string3, FileStatusProvider fileStatusProvider) {
        return RefreshCommandSupport.getStatusAnnotation(string, string2, string3, fileStatusProvider, null);
    }

    public static String getStatusAnnotation(String string, String string2, String string3, FileStatusProvider fileStatusProvider, Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (hashtable != null) {
            hashtable2.putAll(hashtable);
        }
        hashtable2.put(ANNOTATION_PATTERN_FILE_NAME, string);
        String string4 = fileStatusProvider.getFileStatus(string2);
        String string5 = null;
        HashMap hashMap = fileStatusProvider.getPossibleFileStatusesTable();
        if (hashMap != null && string4 != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                string5 = (String)hashMap.get(string4);
            }
        }
        if (string5 != null) {
            string4 = string5;
        }
        if (string4 != null) {
            hashtable2.put(ANNOTATION_PATTERN_STATUS, string4);
        }
        if ((string4 = fileStatusProvider.getFileLocker(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_LOCKER, string4);
        }
        if ((string4 = fileStatusProvider.getFileRevision(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_REVISION, string4);
        }
        if ((string4 = fileStatusProvider.getFileSticky(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_STICKY, string4);
        }
        if ((string4 = fileStatusProvider.getFileSize(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_SIZE, string4);
        }
        if ((string4 = fileStatusProvider.getFileAttribute(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_ATTR, string4);
        }
        if ((string4 = fileStatusProvider.getFileDate(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_DATE, string4);
        }
        if ((string4 = fileStatusProvider.getFileTime(string2)) != null) {
            hashtable2.put(ANNOTATION_PATTERN_TIME, string4);
        }
        return Variables.expand(hashtable2, string3, false);
    }

    public static String getStatusAnnotation(String string, ArrayList arrayList, String string2, FileStatusProvider fileStatusProvider, int[] nArray) {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = arrayList.size();
        if (n2 == 0) {
            return string;
        }
        hashtable.put(ANNOTATION_PATTERN_FILE_NAME, string);
        String string3 = null;
        HashMap hashMap = fileStatusProvider.getPossibleFileStatusesTable();
        if (hashMap != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                n = 0;
                while (n < n2) {
                    String string4 = fileStatusProvider.getFileStatus((String)arrayList.get(n));
                    string3 = (String)hashMap.get(string4);
                    if (string3 != null) {
                        string4 = string3;
                    }
                    arrayList2.add(string4);
                    ++n;
                }
            }
        } else {
            int n3 = 0;
            while (n3 < n2) {
                arrayList2.add(fileStatusProvider.getFileStatus((String)arrayList.get(n3)));
                ++n3;
            }
        }
        String string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[1], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_STATUS, string5);
        }
        arrayList2.clear();
        n = 0;
        while (n < n2) {
            arrayList2.add(fileStatusProvider.getFileLocker((String)arrayList.get(n)));
            ++n;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[2], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_LOCKER, string5);
        }
        arrayList2.clear();
        int n4 = 0;
        while (n4 < n2) {
            arrayList2.add(fileStatusProvider.getFileRevision((String)arrayList.get(n4)));
            ++n4;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[3], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_REVISION, string5);
        }
        arrayList2.clear();
        int n5 = 0;
        while (n5 < n2) {
            arrayList2.add(fileStatusProvider.getFileSticky((String)arrayList.get(n5)));
            ++n5;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[4], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_STICKY, string5);
        }
        arrayList2.clear();
        int n6 = 0;
        while (n6 < n2) {
            arrayList2.add(fileStatusProvider.getFileAttribute((String)arrayList.get(n6)));
            ++n6;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[5], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_ATTR, string5);
        }
        arrayList2.clear();
        int n7 = 0;
        while (n7 < n2) {
            arrayList2.add(fileStatusProvider.getFileSize((String)arrayList.get(n7)));
            ++n7;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[6], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_SIZE, string5);
        }
        arrayList2.clear();
        int n8 = 0;
        while (n8 < n2) {
            arrayList2.add(fileStatusProvider.getFileDate((String)arrayList.get(n8)));
            ++n8;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[7], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_DATE, string5);
        }
        arrayList2.clear();
        int n9 = 0;
        while (n9 < n2) {
            arrayList2.add(fileStatusProvider.getFileTime((String)arrayList.get(n9)));
            ++n9;
        }
        string5 = RefreshCommandSupport.getAttribute(arrayList2, nArray[8], fileStatusProvider.getNotInSynchStatus());
        if (string5 != null) {
            hashtable.put(ANNOTATION_PATTERN_TIME, string5);
        }
        return Variables.expand(hashtable, string2, false);
    }

    private static String getAttribute(ArrayList arrayList, int n, String string) {
        Object e = arrayList.get(0);
        if (e == null) {
            return null;
        }
        String string2 = (String)e;
        int n2 = arrayList.size();
        int n3 = 1;
        n3 = 1;
        while (n3 < n2) {
            if (!e.equals(arrayList.get(n3))) break;
            ++n3;
        }
        boolean bl = n3 < n2;
        switch (n) {
            case 0: {
                if (bl) {
                    return "";
                }
                return string2;
            }
            case 2: {
                if (bl) {
                    return string;
                }
                return string2;
            }
            case 1: {
                if (!bl) {
                    return string2;
                }
                StringBuffer stringBuffer = new StringBuffer(string2);
                int n4 = 1;
                while (n4 < n2) {
                    stringBuffer.append(DEFAULT_MULTI_FILES_ANNOTATION_DELIMETER + (String)arrayList.get(n4));
                    ++n4;
                }
                return stringBuffer.toString();
            }
        }
        return "";
    }
}

