/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.TopManager;

public class VcsCacheDir
extends CacheDir {
    private Debug E;
    private Debug D;
    private volatile boolean loaded;
    private volatile boolean beingLoaded;
    private final Object loadedLock;

    public VcsCacheDir(String string, File file) {
        super(string, file, (CacheFile.PersistentData)new VcsCacheFile.VcsPersistentData(true));
        this.D = this.E = new Debug("VcsCacheDir", true);
        this.loaded = false;
        this.beingLoaded = false;
        this.loadedLock = new Object();
        this.setLocal(true);
        this.setLoaded(false);
    }

    VcsCacheDir(String string, File file, CacheFile.PersistentData persistentData) {
        super(string, file, persistentData);
        this.D = this.E = new Debug("VcsCacheDir", true);
        this.loaded = false;
        this.beingLoaded = false;
        this.loadedLock = new Object();
        this.setLoaded(false);
    }

    public String getPath() {
        return this.dirFile.getAbsolutePath();
    }

    public File getFile() {
        return this.dirFile;
    }

    public String getFSPath() {
        return ((VcsCache)this.getCacheObject()).getPath(this.getFile());
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    protected final void setLoaded(boolean bl) {
        Object object = this.loadedLock;
        synchronized (object) {
            this.loaded = bl;
            this.loadedLock.notifyAll();
        }
    }

    public final boolean isBeingLoaded() {
        return this.beingLoaded;
    }

    protected final void setBeingLoaded(boolean bl) {
        this.beingLoaded = bl;
    }

    protected final void setLoadedRecursive(boolean bl) {
        this.loaded = bl;
        CacheDir[] cacheDirArray = this.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            ((VcsCacheDir)cacheDirArray[n]).setLoadedRecursive(bl);
            ++n;
        }
    }

    public final void waitToLoad() throws InterruptedException {
        Object object = this.loadedLock;
        synchronized (object) {
            while (!this.isLoaded()) {
                this.loadedLock.wait();
            }
        }
    }

    public void add(CacheFile cacheFile) {
        if (cacheFile instanceof VcsCacheDir || cacheFile instanceof CacheDir) {
            this.addChildDir((CacheDir)cacheFile, true);
        } else {
            this.addFile(cacheFile, true);
        }
    }

    private boolean checkSiblings(CacheFile cacheFile) {
        boolean bl;
        boolean bl2 = bl = !((VcsCacheFile.VcsPersistentData)cacheFile.getPersistentData()).dumpSiblings(false);
        if (bl) {
            ((VcsCacheFile.VcsPersistentData)cacheFile.getPersistentData()).dumpSiblings(true);
        }
        if (!bl) {
            Object object;
            String[] stringArray = this.getSubDirNames();
            int n = 0;
            while (n < stringArray.length) {
                VcsCacheDir vcsCacheDir = (VcsCacheDir)this.getSubDirIfExists(stringArray[n]);
                if (vcsCacheDir != null) {
                    object = (VcsCacheFile.VcsPersistentData)vcsCacheDir.getPersistentData();
                    boolean bl3 = bl = bl || !((VcsCacheFile.VcsPersistentData)object).dumpSiblings(false);
                    if (bl) {
                        ((VcsCacheFile.VcsPersistentData)object).dumpSiblings(true);
                    }
                }
                ++n;
            }
            stringArray = this.getFileNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                object = (VcsCacheFile)this.getFileIfExists(stringArray[n2]);
                if (object != null) {
                    VcsCacheFile.VcsPersistentData vcsPersistentData = (VcsCacheFile.VcsPersistentData)((CacheFile)object).getPersistentData();
                    boolean bl4 = bl = bl || !vcsPersistentData.dumpSiblings(false);
                    if (bl) {
                        vcsPersistentData.dumpSiblings(true);
                    }
                }
                ++n2;
            }
        }
        return !bl;
    }

    public CacheDir addChildDir(CacheDir cacheDir, boolean bl) {
        CacheDir cacheDir2 = super.addChildDir(cacheDir, bl);
        this.adjustSiblingDataToChildrenData(true, cacheDir.getPersistentData());
        if (Boolean.getBoolean("vcs.cache.debug") && !this.checkSiblings(cacheDir)) {
            System.out.println("BAD SIBLINGS after addChildDir(" + cacheDir + ") into " + this);
            Thread.currentThread();
            Thread.dumpStack();
        }
        return cacheDir2;
    }

    public void addFile(CacheFile cacheFile, boolean bl) {
        super.addFile(cacheFile, bl);
        this.adjustSiblingDataToChildrenData(true, cacheFile.getPersistentData());
        if (Boolean.getBoolean("vcs.cache.debug") && !this.checkSiblings(cacheFile)) {
            System.out.println("BAD SIBLINGS after addFile(" + cacheFile + ") into " + this);
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    public void removeFile(String string, boolean bl) {
        CacheFile cacheFile = this.getFile(string);
        if (cacheFile != null) {
            super.removeFile(string, bl);
            this.adjustSiblingDataToChildrenData(false, cacheFile.getPersistentData());
        }
    }

    protected void setParent(CacheDir cacheDir) {
        super.setParent(cacheDir);
        VcsCacheFile.VcsPersistentData vcsPersistentData = (VcsCacheFile.VcsPersistentData)this.getPersistentData();
        vcsPersistentData.setCacheFileName(cacheDir != null ? ((VcsCacheDir)cacheDir).getCacheFileName() : null);
        if (cacheDir != null) {
            ((VcsCacheDir)cacheDir).adjustChildrenData(true, vcsPersistentData);
        }
    }

    public void removeFiles() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            CacheFile[] cacheFileArray = this.getFiles();
            super.removeFiles();
            int n = 0;
            while (n < cacheFileArray.length) {
                this.adjustSiblingDataToChildrenData(false, cacheFileArray[n].getPersistentData());
                ++n;
            }
        }
    }

    void adjustSiblingDataToChildrenData(boolean bl, CacheFile.PersistentData persistentData) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Object object2;
            int n = this.getFileNames().length + this.getSubDirNames().length;
            String[] stringArray = this.getSubDirNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                VcsCacheDir vcsCacheDir = (VcsCacheDir)this.getSubDirIfExists(stringArray[n2]);
                if (vcsCacheDir != null) {
                    object2 = (VcsCacheFile.VcsPersistentData)vcsCacheDir.getPersistentData();
                    if (bl) {
                        ((VcsCacheFile.VcsPersistentData)object2).addSiblingData(persistentData);
                    } else {
                        ((VcsCacheFile.VcsPersistentData)object2).removeSiblingData(persistentData);
                    }
                    ((VcsCacheFile.VcsPersistentData)object2).setNumOfSiblings(n);
                }
                ++n2;
            }
            stringArray = this.getFileNames();
            int n3 = 0;
            while (n3 < stringArray.length) {
                object2 = (VcsCacheFile)this.getFileIfExists(stringArray[n3]);
                if (object2 != null) {
                    VcsCacheFile.VcsPersistentData vcsPersistentData = (VcsCacheFile.VcsPersistentData)((CacheFile)object2).getPersistentData();
                    if (bl) {
                        vcsPersistentData.addSiblingData(persistentData);
                    } else {
                        vcsPersistentData.removeSiblingData(persistentData);
                    }
                    vcsPersistentData.setNumOfSiblings(n);
                }
                ++n3;
            }
        }
    }

    void adjustChildrenData(boolean bl, VcsCacheFile.VcsPersistentData vcsPersistentData) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Object object2;
            String[] stringArray = this.getSubDirNames();
            int n = 0;
            while (n < stringArray.length) {
                object2 = (VcsCacheDir)this.getSubDirIfExists(stringArray[n]);
                if (object2 != null) {
                    VcsCacheFile.VcsPersistentData vcsPersistentData2 = (VcsCacheFile.VcsPersistentData)((CacheFile)object2).getPersistentData();
                    if (bl) {
                        vcsPersistentData.addSiblingData(vcsPersistentData2);
                    } else {
                        vcsPersistentData.removeSiblingData(vcsPersistentData2);
                    }
                }
                ++n;
            }
            object2 = this.getFileNames();
            int n2 = 0;
            while (n2 < ((String[])object2).length) {
                VcsCacheFile vcsCacheFile = (VcsCacheFile)this.getFileIfExists((String)object2[n2]);
                if (vcsCacheFile != null) {
                    VcsCacheFile.VcsPersistentData vcsPersistentData3 = (VcsCacheFile.VcsPersistentData)vcsCacheFile.getPersistentData();
                    if (bl) {
                        vcsPersistentData.addSiblingData(vcsPersistentData3);
                    } else {
                        vcsPersistentData.removeSiblingData(vcsPersistentData3);
                    }
                }
                ++n2;
            }
            vcsPersistentData.setNumOfSiblings(stringArray.length + ((Object)object2).length);
        }
    }

    public String[] getFilesAndSubdirs() {
        String[] stringArray = this.getFileNames();
        String[] stringArray2 = this.getSubDirNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    CacheFile getChildIfExists(String string) {
        CacheFile cacheFile = this.getFileIfExists(string);
        if (cacheFile == null) {
            cacheFile = this.getSubDirIfExists(string);
        }
        return cacheFile;
    }

    protected CacheFile createChildFromData(CacheFile.PersistentData persistentData) {
        CacheFile cacheFile = persistentData.isDirectory() ? new VcsCacheDir(this.getCacheName(), new File(this.getFile(), persistentData.getName()), persistentData) : new VcsCacheFile(this.getCacheName(), persistentData);
        return cacheFile;
    }

    protected String getCacheFileName() {
        return ((VcsCache)this.getCacheObject()).getCacheFileName(this.dirFile);
    }

    public void removeChildDir(String string, boolean bl) {
        CacheDir cacheDir = this.getSubDir(string);
        if (cacheDir != null) {
            ((VcsCacheDir)cacheDir).deleteDiskCache(true);
            super.removeChildDir(string, bl);
            this.adjustSiblingDataToChildrenData(true, cacheDir.getPersistentData());
        }
    }

    public void populateWithLocal(Object object) {
        File[] fileArray;
        FilenameFilter filenameFilter = ((VcsCache)this.getCacheObject()).getLocalFileFilter();
        File[] fileArray2 = fileArray = filenameFilter == null ? this.dirFile.listFiles() : this.dirFile.listFiles(filenameFilter);
        if (fileArray != null) {
            CacheHandler cacheHandler = CacheHandler.getInstance();
            int n = 0;
            while (n < fileArray.length) {
                File file = fileArray[n];
                if (file != null && file.isDirectory()) {
                    VcsCacheDir vcsCacheDir = (VcsCacheDir)this.getCacheObject().getDir(file.getAbsolutePath());
                    if (vcsCacheDir == null) {
                        vcsCacheDir = new VcsCacheDir(this.getCacheObject().getId(), file);
                    }
                    vcsCacheDir.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
                    vcsCacheDir.setLocker("");
                    vcsCacheDir.setRevision("");
                    vcsCacheDir.setSticky("");
                    vcsCacheDir.setAttr("");
                    vcsCacheDir.setDate("");
                    vcsCacheDir.setTime("");
                    vcsCacheDir.setSize(0);
                    vcsCacheDir.setLocal(true);
                    vcsCacheDir.getPersistentData().setModified(false);
                    this.addChildDir(vcsCacheDir, false);
                    cacheHandler.addCacheLocker(object, vcsCacheDir);
                }
                ++n;
            }
        }
        this.setAppliedLevel(0);
    }

    public void refreshLocal(boolean bl) {
        CacheFile cacheFile;
        Object object;
        int n;
        File[] fileArray;
        Object object2;
        String[] stringArray = this.getFilesAndSubdirs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object2 = arrayList.get(n2);
            fileArray = this.getFile((String)object2);
            if (fileArray instanceof VcsCacheFile) {
                if (!((VcsCacheFile)fileArray).isLocal()) {
                    arrayList.remove(n2--);
                }
            } else if (fileArray instanceof VcsCacheDir && !((VcsCacheDir)fileArray).isLocal()) {
                arrayList.remove(n2--);
            }
            ++n2;
        }
        object2 = ((VcsCache)this.getCacheObject()).getLocalFileFilter();
        File[] fileArray2 = fileArray = object2 == null ? this.dirFile.listFiles() : this.dirFile.listFiles((FilenameFilter)object2);
        if (fileArray != null) {
            n = 0;
            while (n < fileArray.length) {
                object = fileArray[n].getName();
                if (arrayList.contains(object)) {
                    ((AbstractCollection)arrayList).remove(object);
                } else if (fileArray[n].isDirectory() && this.getSubDir((String)object) != null) {
                    cacheFile = (VcsCacheDir)this.getCacheObject().getDir(fileArray[n].getAbsolutePath());
                    if (cacheFile == null) {
                        cacheFile = new VcsCacheDir(this.getCacheObject().getId(), fileArray[n]);
                    }
                    cacheFile.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
                    cacheFile.setLocker("");
                    cacheFile.setRevision("");
                    cacheFile.setSticky("");
                    cacheFile.setAttr("");
                    cacheFile.setDate("");
                    cacheFile.setTime("");
                    cacheFile.setSize(0);
                    ((CacheDir)cacheFile).setLocal(true);
                    cacheFile.getPersistentData().setModified(false);
                    this.addChildDir((CacheDir)cacheFile, false);
                }
                ++n;
            }
        }
        n = 0;
        while (n < arrayList.size()) {
            object = arrayList.get(n);
            cacheFile = this.getFile((String)object);
            if (cacheFile != null) {
                this.removeFile((String)object, true);
            } else {
                CacheDir cacheDir = this.getSubDir((String)object);
                if (cacheDir != null) {
                    this.removeChildDir((String)object, true);
                }
            }
            ++n;
        }
        if (bl) {
            object = this.getSubDirs();
            int n3 = 0;
            while (n3 < ((CacheDir[])object).length) {
                ((VcsCacheDir)object[n3]).refreshLocal(bl);
                ++n3;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean readFromDisk(Object object) {
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        String string = this.getCacheFileName();
        if (string == null) {
            return false;
        }
        ArrayList<CacheFile> arrayList = new ArrayList<CacheFile>();
        String string2 = string;
        synchronized (string2) {
            block19: {
                object4 = new File(string);
                if (((File)object4).exists() && ((File)object4).canRead()) {
                    object3 = null;
                    object3 = new BufferedReader(new FileReader((File)object4));
                    object2 = null;
                    while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                        try {
                            CacheFile cacheFile = VcsCacheFile.readFileCache((String)object2, this.getCacheName(), this.getFile());
                            cacheFile.getPersistentData().setModified(false);
                            arrayList.add(cacheFile);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            TopManager.getDefault().getErrorManager().notify(16, TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, "Line read: '" + (String)object2 + "'"));
                        }
                    }
                    ((BufferedReader)object3).close();
                    bl = true;
                    Object var11_12 = null;
                    if (object3 == null) break block19;
                    try {
                        ((BufferedReader)object3).close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    object3 = null;
                    {
                        break block19;
                        catch (IOException iOException) {
                            this.E.err(iOException, "readDirFromDiskCache() failed");
                            var11_12 = null;
                            if (object3 == null) break block19;
                            try {
                                ((BufferedReader)object3).close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            object3 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (object3 != null) {
                            try {
                                ((BufferedReader)object3).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            object3 = null;
                        }
                        throw throwable;
                    }
                }
            }
        }
        object4 = CacheHandler.getInstance();
        object3 = ((AbstractList)arrayList).iterator();
        while (object3.hasNext()) {
            object2 = (CacheFile)object3.next();
            this.add((CacheFile)object2);
            ((CacheHandler)object4).addCacheLocker(object, (CacheFile)object2);
            if (!(object2 instanceof CacheDir)) continue;
            this.getCacheObject().registerDir((CacheDir)object2);
        }
        if (bl) {
            this.setLoaded(true);
            this.setAppliedLevel(3);
            this.setModifiedContent(false);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    protected CacheFile readFileFromDisk(String var1_1) {
        var2_2 = this.getCacheFileName();
        var3_3 = null;
        if (var2_2 != null) {
            var4_4 = var2_2;
            synchronized (var4_4) {
                block20: {
                    var5_5 = new File(var2_2);
                    if (var5_5.exists() && var5_5.canRead()) {
                        var6_6 = null;
                        try {
                            var6_6 = new BufferedReader(new FileReader(var5_5));
                            var7_7 = null;
                            while ((var7_7 = var6_6.readLine()) != null) {
                                try {
                                    var8_9 = RefreshCommandSupport.getElementsFromLine(var7_7);
                                    var9_11 = var8_9[0];
                                    if (!var1_1.equals(var9_11)) continue;
                                    var3_3 = new VcsCacheFile(this.getCacheName(), var1_1);
                                    RefreshCommandSupport.matchToFile(var8_9, var3_3);
                                    var3_3.setLocal(false);
                                    var3_3.setParent(this);
                                    break;
                                }
                                catch (IllegalArgumentException var8_10) {
                                    TopManager.getDefault().getErrorManager().notify(16, TopManager.getDefault().getErrorManager().annotate((Throwable)var8_10, "Line read: '" + var7_7 + "'"));
                                }
                            }
                            var6_6.close();
                            var11_12 = null;
                            ** if (var6_6 == null) goto lbl-1000
                        }
                        catch (Throwable var10_18) {
                            var11_14 = null;
                            if (var6_6 != null) {
                                try {
                                    var6_6.close();
                                }
                                catch (IOException var12_17) {
                                    // empty catch block
                                }
                            }
                            throw var10_18;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var6_6.close();
                            }
                            catch (IOException var12_15) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block20;
                            catch (IOException var7_8) {
                                this.E.err(var7_8, "readFileFromDiskCache() failed");
                                var11_13 = null;
                                if (var6_6 != null) {
                                    try {
                                        var6_6.close();
                                    }
                                    catch (IOException var12_16) {}
                                }
                            }
                        }
                    }
                }
            }
        }
        if (var3_3 == null) {
            var3_3 = new VcsCacheFile(this.getCacheName(), var1_1);
            var3_3.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
            var3_3.setLocal(true);
        }
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    protected CacheDir readDirFromDisk(String var1_1) {
        var2_2 = this.getCacheFileName();
        var3_3 = null;
        if (var2_2 != null) {
            var4_4 = var2_2;
            synchronized (var4_4) {
                block20: {
                    var5_5 = new File(var2_2);
                    var6_6 = var1_1 + "/";
                    if (var5_5.exists() && var5_5.canRead()) {
                        var7_7 = null;
                        try {
                            var7_7 = new BufferedReader(new FileReader(var5_5));
                            var8_8 = null;
                            while ((var8_8 = var7_7.readLine()) != null) {
                                try {
                                    var9_10 = RefreshCommandSupport.getElementsFromLine(var8_8);
                                    var10_12 = var9_10[0];
                                    if (!var6_6.equals(var10_12)) continue;
                                    var3_3 = new VcsCacheDir(this.getCacheName(), new File(this.getFile(), var1_1));
                                    var3_3.setName(var1_1);
                                    RefreshCommandSupport.matchToFile(var9_10, var3_3);
                                    var3_3.setLocal(false);
                                    var3_3.setParent(this);
                                    break;
                                }
                                catch (IllegalArgumentException var9_11) {
                                    TopManager.getDefault().getErrorManager().notify(16, TopManager.getDefault().getErrorManager().annotate((Throwable)var9_11, "Line read: '" + var8_8 + "'"));
                                }
                            }
                            var7_7.close();
                            var12_13 = null;
                            ** if (var7_7 == null) goto lbl-1000
                        }
                        catch (Throwable var11_19) {
                            var12_15 = null;
                            if (var7_7 != null) {
                                try {
                                    var7_7.close();
                                }
                                catch (IOException var13_18) {
                                    // empty catch block
                                }
                            }
                            throw var11_19;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var13_16) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block20;
                            catch (IOException var8_9) {
                                this.E.err(var8_9, "readDirFromDiskCache() failed");
                                var12_14 = null;
                                if (var7_7 != null) {
                                    try {
                                        var7_7.close();
                                    }
                                    catch (IOException var13_17) {}
                                }
                            }
                        }
                    }
                }
            }
        }
        if (var3_3 == null) {
            var3_3 = new VcsCacheDir(this.getCacheName(), new File(this.getFile(), var1_1));
            var3_3.setStatus(((VcsCache)this.getCacheObject()).getLocalFileStatus());
            var3_3.setLocal(true);
            var3_3.setParent(this);
        }
        return var3_3;
    }

    /*
     * Loose catch block
     */
    public void writeToDisk() {
        String string = this.getCacheFileName();
        if (string == null) {
            return;
        }
        CacheFile[] cacheFileArray = this.getFiles();
        CacheDir[] cacheDirArray = this.getSubDirs();
        boolean bl = false;
        String string2 = string;
        synchronized (string2) {
            block23: {
                File file = new File(string);
                BufferedWriter bufferedWriter = null;
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, "Exception when trying to create a new file '" + file.getAbsolutePath() + "', file exists = " + file.exists() + ", parent exists = " + file2.exists() + "\nIf this happens to you, please attach this comment and exception stack to issue #16295."));
                }
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = 0;
                while (n < cacheFileArray.length) {
                    if (!((VcsCacheFile)cacheFileArray[n]).isLocal()) {
                        bufferedWriter.write(((VcsCacheFile.VcsPersistentData)cacheFileArray[n].getPersistentData()).writeLineToDisk());
                        bufferedWriter.newLine();
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < cacheDirArray.length) {
                    if (!((VcsCacheDir)cacheDirArray[n2]).isLocal()) {
                        bufferedWriter.write(((VcsCacheFile.VcsPersistentData)cacheDirArray[n2].getPersistentData()).writeLineToDisk());
                        bufferedWriter.newLine();
                    }
                    ++n2;
                }
                bufferedWriter.flush();
                bl = true;
                Object var12_13 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    break block23;
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                }
                break block23;
                {
                    catch (IOException iOException) {
                        TopManager.getDefault().notifyException((Throwable)iOException);
                        Object var12_14 = null;
                        try {
                            if (bufferedWriter != null) {
                                bufferedWriter.close();
                            }
                            break block23;
                        }
                        catch (IOException iOException2) {
                            TopManager.getDefault().notifyException((Throwable)iOException2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        TopManager.getDefault().notifyException((Throwable)iOException);
                    }
                    throw throwable;
                }
            }
        }
        if (bl) {
            this.setModifiedContent(false);
            this.getPersistentData().setModified(false);
        }
    }

    public String writeLineToDisk() {
        String[] stringArray = RefreshCommandSupport.makeElements(this);
        stringArray[0] = stringArray[0] + "/";
        return RefreshCommandSupport.getLineFromElements(stringArray);
    }

    private void deleteDiskCache(boolean bl) {
        String string = this.getCacheFileName();
        if (string == null) {
            return;
        }
        File file = new File(string);
        file.delete();
        if (bl) {
            CacheDir[] cacheDirArray = this.getSubDirs();
            int n = 0;
            while (n < cacheDirArray.length) {
                ((VcsCacheDir)cacheDirArray[n]).deleteDiskCache(bl);
                ++n;
            }
        }
    }

    public void checkServer(Object object) {
        boolean bl;
        VcsCacheDir vcsCacheDir = this;
        synchronized (vcsCacheDir) {
            if (this.isBeingLoaded()) {
                return;
            }
            if (!this.isLoaded() || !this.isLocal()) {
                this.setAppliedLevel(3);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            VcsCache vcsCache = (VcsCache)this.getCacheObject();
            vcsCache.runVcsDirReader(this, object);
        }
    }

    public void checkServerRecursive(Object object) {
        boolean bl;
        VcsCacheDir vcsCacheDir = this;
        synchronized (vcsCacheDir) {
            if (this.isBeingLoaded()) {
                return;
            }
            if (!this.isLoaded() || !this.isLocal()) {
                this.setAppliedLevel(3);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            VcsCache vcsCache = (VcsCache)this.getCacheObject();
            vcsCache.runVcsDirReaderRecursive(this, object);
        }
    }

    protected void createIgnoreList() {
        CacheDir cacheDir = this.getParent();
        if (cacheDir != null && !cacheDir.isIgnoreListSet()) {
            return;
        }
        VcsCache vcsCache = (VcsCache)this.getCacheObject();
        vcsCache.createIgnoreList(this, cacheDir == null ? null : cacheDir.getIgnoreList());
    }

    public String toString() {
        CacheFile[] cacheFileArray = this.getFiles();
        String[] stringArray = new String[cacheFileArray.length];
        int n = 0;
        while (n < cacheFileArray.length) {
            stringArray[n] = cacheFileArray[n].getName();
            ++n;
        }
        CacheDir[] cacheDirArray = this.getSubDirs();
        String[] stringArray2 = new String[cacheDirArray.length];
        int n2 = 0;
        while (n2 < cacheDirArray.length) {
            stringArray2[n2] = cacheDirArray[n2].getName();
            ++n2;
        }
        String string = "VcsDir[name='" + this.getName() + "',status=" + this.getStatus() + "\n files=" + VcsUtilities.arrayToString(stringArray) + ",\n subdir=" + VcsUtilities.arrayToString(stringArray2) + "\n isLocal = " + this.isLocal() + " isLoaded = " + this.isLoaded() + " isBeingLoaded = " + this.isBeingLoaded() + "]";
        return string;
    }
}

