/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.TopManager;
import org.openide.util.WeakSet;

public class VcsCacheFile
extends CacheFile {
    private Debug E;
    private Debug D;
    public static final String STATUS_IGNORED = "Ignored";
    public static final String STATUS_DEAD = "Dead";

    public VcsCacheFile(String string) {
        super(string, new VcsPersistentData(false));
        this.D = this.E = new Debug("VcsFile", false);
    }

    public VcsCacheFile(String string, String string2) {
        super(string, string2, new VcsPersistentData(false));
        this.D = this.E = new Debug("VcsFile", false);
    }

    public VcsCacheFile(String string, String string2, boolean bl) {
        this(string, string2);
        this.setLocal(bl);
    }

    VcsCacheFile(String string, CacheFile.PersistentData persistentData) {
        super(string, persistentData.getName(), persistentData);
        this.D = this.E = new Debug("VcsFile", false);
    }

    public void setLocal(boolean bl) {
        ((VcsPersistentData)this.getPersistentData()).setLocal(bl);
    }

    public boolean isLocal() {
        return ((VcsPersistentData)this.getPersistentData()).isLocal();
    }

    public String getStatus() {
        if (this.isLocal() && this.getParent().isIgnoreListSet() && this.getParent().isIgnored(this.getName())) {
            return STATUS_IGNORED;
        }
        return super.getStatus();
    }

    protected void setParent(CacheDir cacheDir) {
        super.setParent(cacheDir);
        VcsPersistentData vcsPersistentData = (VcsPersistentData)this.getPersistentData();
        vcsPersistentData.setCacheFileName(cacheDir != null ? ((VcsCacheDir)cacheDir).getCacheFileName() : null);
        if (cacheDir != null) {
            ((VcsCacheDir)cacheDir).adjustChildrenData(true, vcsPersistentData);
        }
    }

    public static CacheFile readFileCache(String string, String string2, File file) {
        VcsCacheDir vcsCacheDir;
        String[] stringArray = RefreshCommandSupport.getElementsFromLine(string);
        String string3 = stringArray[0];
        if (string3 == null) {
            throw new IllegalArgumentException("File name element is missing.");
        }
        boolean bl = string3.endsWith("/");
        String string4 = bl ? string3.substring(0, string3.length() - 1) : string3;
        VcsCache vcsCache = (VcsCache)CacheHandler.getInstance().getCache(string2);
        CacheFile cacheFile = null;
        if (vcsCache != null && (vcsCacheDir = (VcsCacheDir)vcsCache.getDir(file.getAbsolutePath())) != null) {
            cacheFile = vcsCacheDir.getChildIfExists(string4);
        }
        if (cacheFile == null) {
            cacheFile = bl ? new VcsCacheDir(string2, new File(file, string4)) : new VcsCacheFile(string2);
            cacheFile.setName(string4);
        }
        RefreshCommandSupport.matchToFile(stringArray, cacheFile);
        if (cacheFile instanceof VcsCacheFile) {
            cacheFile.setLocal(false);
        }
        if (cacheFile instanceof VcsCacheDir) {
            ((VcsCacheDir)cacheFile).setLocal(false);
        }
        return cacheFile;
    }

    public String toString() {
        return "VcsFile[name='" + this.getName() + "'" + ",status=" + this.getStatus() + ",locker=" + this.getLocker() + ",revision=" + this.getRevision() + ",sticky=" + this.getSticky() + ",attr=" + this.getAttr() + ",size=" + this.getSize() + ",date=" + this.getDate() + ",time=" + this.getTime() + ",local=" + this.isLocal() + "]";
    }

    protected static class VcsPersistentData
    extends CacheFile.PersistentData {
        private String cacheFileName = null;
        private WeakSet siblings = new WeakSet();
        private int numOfSiblings = 0;
        private boolean local = false;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData;

        public VcsPersistentData(boolean bl) {
            super(bl);
        }

        void setCacheFileName(String string) {
            this.cacheFileName = string;
        }

        void addSiblingData(CacheFile.PersistentData persistentData) {
            WeakSet weakSet = this.siblings;
            synchronized (weakSet) {
                this.siblings.add((Object)persistentData);
            }
        }

        void removeSiblingData(CacheFile.PersistentData persistentData) {
            WeakSet weakSet = this.siblings;
            synchronized (weakSet) {
                this.siblings.remove((Object)persistentData);
            }
        }

        void setNumOfSiblings(int n) {
            WeakSet weakSet = this.siblings;
            synchronized (weakSet) {
                this.numOfSiblings = n;
            }
        }

        public boolean dumpSiblings(boolean bl) {
            if (bl) {
                Class clazz = class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData == null ? (class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData = VcsPersistentData.class$("org.netbeans.modules.vcscore.caching.VcsCacheFile$VcsPersistentData")) : class$org$netbeans$modules$vcscore$caching$VcsCacheFile$VcsPersistentData;
                synchronized (clazz) {
                    System.out.println("PersistentData " + this + " have " + this.numOfSiblings + " siblings:");
                    HashSet hashSet = new HashSet(this.siblings);
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + iterator.next());
                    }
                    System.out.println("  Siblings contains me = " + this.siblings.contains((Object)this) + "\n");
                }
            }
            return this.siblings.contains((Object)this);
        }

        public final boolean isLocal() {
            return this.local;
        }

        public final void setLocal(boolean bl) {
            this.local = bl;
        }

        public String writeLineToDisk() {
            String[] stringArray = RefreshCommandSupport.makeElements(this);
            if (this.isDirectory()) {
                stringArray[0] = stringArray[0] + "/";
            }
            return RefreshCommandSupport.getLineFromElements(stringArray);
        }

        protected void doWriteToDisk() throws IOException {
            if (this.cacheFileName == null) {
                return;
            }
            String string = this.cacheFileName;
            synchronized (string) {
                if (!this.isModified()) {
                    return;
                }
                WeakSet weakSet = this.siblings;
                synchronized (weakSet) {
                    HashSet hashSet = new HashSet(this.siblings);
                    if (hashSet.size() >= this.numOfSiblings) {
                        this.doWriteToDisk(hashSet, true);
                    } else {
                        this.doWriteToDisk(hashSet, false);
                    }
                    this.setUnmodified(hashSet);
                }
            }
        }

        private void setUnmodified(Set set) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                VcsPersistentData vcsPersistentData = (VcsPersistentData)iterator.next();
                vcsPersistentData.setModified(false);
            }
        }

        /*
         * Loose catch block
         */
        private void doWriteToDisk(Set set, boolean bl) throws IOException {
            block17: {
                if (!bl) {
                    this.addSiblingsFromDisk(set);
                }
                File file = new File(this.cacheFileName);
                BufferedWriter bufferedWriter = null;
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, "Exception when trying to create a new file '" + file.getAbsolutePath() + "', file exists = " + file.exists() + ", parent exists = " + file2.exists() + "\nIf this happens to you, please attach this comment and exception stack to issue #16295."));
                }
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    VcsPersistentData vcsPersistentData = (VcsPersistentData)iterator.next();
                    if (!vcsPersistentData.isLocal()) {
                        bufferedWriter.write(vcsPersistentData.writeLineToDisk());
                        bufferedWriter.newLine();
                    }
                    vcsPersistentData.setModified(false);
                }
                bufferedWriter.flush();
                Object var9_10 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    break block17;
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                }
                break block17;
                {
                    catch (IOException iOException) {
                        TopManager.getDefault().notifyException((Throwable)iOException);
                        Object var9_11 = null;
                        try {
                            if (bufferedWriter != null) {
                                bufferedWriter.close();
                            }
                            break block17;
                        }
                        catch (IOException iOException2) {
                            TopManager.getDefault().notifyException((Throwable)iOException2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        TopManager.getDefault().notifyException((Throwable)iOException);
                    }
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addSiblingsFromDisk(Set set) throws IOException {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (CacheFile.PersistentData)iterator.next();
                hashSet.add(((CacheFile.PersistentData)object).getName());
            }
            object = new File(this.cacheFileName);
            if (!((File)object).exists() || !((File)object).canRead()) return;
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader((File)object));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    String[] stringArray = RefreshCommandSupport.getElementsFromLine(string);
                    String string2 = stringArray[0];
                    boolean bl = string2.endsWith("/");
                    if (bl) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (hashSet.contains(string2)) continue;
                    VcsPersistentData vcsPersistentData = new VcsPersistentData(bl);
                    vcsPersistentData.setName(string2);
                    RefreshCommandSupport.matchToFile(stringArray, vcsPersistentData);
                    set.add(vcsPersistentData);
                    hashSet.add(vcsPersistentData.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    TopManager.getDefault().getErrorManager().notify(16, TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, "Line read: '" + string + "'"));
                }
            }
            bufferedReader.close();
            Object var12_13 = null;
            if (bufferedReader == null) return;
            try {
                bufferedReader.close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    Object var12_14 = null;
                    if (bufferedReader == null) return;
                    try {
                        bufferedReader.close();
                        return;
                    }
                    catch (IOException iOException2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public String toString() {
            return super.toString() + (this.local ? " IS LOCAL." : "");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

