/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.awt.Image;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class VcsFSCache
implements FileStatusProvider,
FileCacheProvider {
    private Debug E;
    private Debug D;
    public final String localStatusStr;
    public final String ignoredStatusStr;
    private final String modifiedStatus;
    private final String deadStatus;
    private final String notInSynchStatus;
    private final String unknownStatus;
    private HashMap fileStatuses;
    private WeakReference fileSystem;
    private CacheHandler handler;
    private String cacheId;
    private String fsRoot;
    private String relativeMountPoint;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cache$CacheHandlerListener;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsFSCache;

    public VcsFSCache(VcsFileSystem vcsFileSystem) {
        this.D = this.E = new Debug("CvsFsCache", true);
        this.localStatusStr = this.g("CTL_StatusLocal");
        this.ignoredStatusStr = this.g("CTL_StatusIgnored");
        this.modifiedStatus = this.g("CTL_DefaultModifiedStatus");
        this.deadStatus = this.g("CTL_StatusDead");
        this.notInSynchStatus = this.g("CTL_StatusNotInSync");
        this.unknownStatus = this.g("CTL_StatusUnknown");
        this.fileStatuses = new HashMap();
        this.fileSystem = new WeakReference<VcsFileSystem>(vcsFileSystem);
        this.cacheId = vcsFileSystem.getCacheIdStr();
        this.fsRoot = vcsFileSystem.getFSRoot();
        this.relativeMountPoint = vcsFileSystem.getRelativeMountPoint();
        this.handler = CacheHandler.getInstance();
        this.initFileStatuses();
        VcsCache vcsCache = new VcsCache(this.fileSystem, this.getCacheId());
        this.handler.registerCacheType(this.getCacheId(), vcsCache);
        vcsCache.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = VcsFSCache.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)vcsFileSystem, (Object)vcsCache));
        VersioningFileSystem versioningFileSystem = vcsFileSystem.getVersioningFileSystem();
        if (versioningFileSystem instanceof CacheHandlerListener) {
            vcsCache.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = VcsFSCache.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)((CacheHandlerListener)((Object)versioningFileSystem)), (Object)vcsCache));
        }
    }

    private void initFileStatuses() {
        this.fileStatuses.put(this.localStatusStr, this.localStatusStr);
        this.fileStatuses.put(this.modifiedStatus, this.modifiedStatus);
        this.fileStatuses.put("Dead", this.deadStatus);
        this.fileStatuses.put(this.notInSynchStatus, this.notInSynchStatus);
        this.fileStatuses.put(this.unknownStatus, this.unknownStatus);
        this.fileStatuses.put("Ignored", this.ignoredStatusStr);
    }

    public HashMap getPossibleFileStatusesTable() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem != null) {
            HashMap hashMap = vcsFileSystem.getPossibleFileStatusesTable();
            if (hashMap == null) {
                return new HashMap(this.fileStatuses);
            }
            return hashMap;
        }
        return new HashMap();
    }

    public HashMap getStatusIconMap() {
        HashMap<String, Image> hashMap = new HashMap<String, Image>();
        hashMap.put(this.modifiedStatus, Utilities.loadImage((String)"org/netbeans/modules/vcscore/caching/badgeLocModified.gif"));
        return hashMap;
    }

    public String getNotInSynchStatus() {
        return (String)this.fileStatuses.get(this.notInSynchStatus);
    }

    public void setFileModified(String string) {
        this.setFileStatus(string, this.modifiedStatus);
    }

    public String getLocalFileStatus() {
        return this.localStatusStr;
    }

    public void setFileStatus(String string, String string2) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null && !string2.equals(cacheFile.getStatus())) {
            cacheFile.setStatus(string2);
            cacheFile.getParent().writeToDisk();
            FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
            fileSystemCache.fireCacheHandlerEvent(2, cacheFile);
        }
    }

    public Set setExistingFileStatus(String string, String[] stringArray, String string2, Collection collection, boolean bl) {
        CacheDir cacheDir = this.getDir(string);
        if (cacheDir != null) {
            Object object;
            HashSet<Object> hashSet = new HashSet<Object>();
            int n = 0;
            while (n < stringArray.length) {
                object = cacheDir.getFile(stringArray[n]);
                if (object == null) {
                    object = cacheDir.getSubDir(stringArray[n]);
                }
                if (object != null) {
                    String string3 = ((CacheFile)object).getStatus();
                    if (!(collection != null && collection.contains(string3) || string2.equals(string3))) {
                        ((CacheFile)object).setStatus(string2);
                        hashSet.add(object);
                    }
                }
                ++n;
            }
            if (hashSet.size() > 0) {
                cacheDir.writeToDisk();
                if (bl) {
                    object = this.handler.getCache(this.getCacheId());
                    ((FileSystemCache)object).fireCacheHandlerEvent(2, new CacheHandlerEvent(hashSet));
                }
            }
            return hashSet;
        }
        return Collections.EMPTY_SET;
    }

    public String getFileStatus(String string) {
        String string2;
        CacheDir cacheDir;
        CacheFile cacheFile = this.getFileOrDir(string, null);
        String string3 = cacheFile != null ? cacheFile.getStatus() : ((cacheDir = this.getDir(string2 = VcsUtilities.getDirNamePart(string))) != null && cacheDir.isIgnoreListSet() && cacheDir.isIgnored(VcsUtilities.getFileNamePart(string)) ? "Ignored" : this.localStatusStr);
        return string3;
    }

    public String getFileLocker(String string) {
        String string2 = null;
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            string2 = cacheFile.getLocker();
        }
        return string2;
    }

    public String getFileRevision(String string) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            return cacheFile.getRevision();
        }
        return null;
    }

    public String getFileSticky(String string) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            return cacheFile.getSticky();
        }
        return null;
    }

    public String getFileAttribute(String string) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            return cacheFile.getAttr();
        }
        return null;
    }

    public String getFileSize(String string) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            return "" + cacheFile.getSize();
        }
        return null;
    }

    public String getFileDate(String string) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            return cacheFile.getDate();
        }
        return null;
    }

    public String getFileTime(String string) {
        CacheFile cacheFile = this.getFileOrDir(string, null);
        if (cacheFile != null) {
            return cacheFile.getTime();
        }
        return null;
    }

    public void refreshDir(String string) {
        FileCacheProvider fileCacheProvider;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem != null && (fileCacheProvider = vcsFileSystem.getCacheProvider()) != null) {
            fileCacheProvider.refreshCacheDir(string);
        }
    }

    public void refreshDirRecursive(String string) {
        FileCacheProvider fileCacheProvider;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem != null && (fileCacheProvider = vcsFileSystem.getCacheProvider()) != null) {
            fileCacheProvider.refreshCacheDirRecursive(string);
        }
    }

    public Reference createReference(FileObject fileObject) {
        String string = fileObject.getPackageNameExt(File.separatorChar, '.');
        String string2 = this.getAbsolutePath(string);
        File file = new File(string2);
        return CacheHandler.getInstance().createReference(fileObject, file, this.getCacheId());
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setFSRoot(String string) {
        this.fsRoot = string;
    }

    public void setRelativeMountPoint(String string) {
        this.relativeMountPoint = string;
    }

    private String getAbsolutePath(String string) {
        string = this.fsRoot + File.separator + this.relativeMountPoint + File.separator + string.replace('/', File.separatorChar);
        while (string.endsWith(File.separator) && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private CacheFile getFileOrDir(String string, int n, Object object) {
        FileCacheProvider fileCacheProvider;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        CacheFile cacheFile = null;
        if (vcsFileSystem != null && (fileCacheProvider = vcsFileSystem.getCacheProvider()) != null) {
            string = this.getAbsolutePath(string);
            cacheFile = this.handler.getCacheFile(new File(string), this.adjustStrategy(n), fileCacheProvider.getCacheId(), object);
        }
        return cacheFile;
    }

    private CacheFile getFileOrDir(String string, Object object) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        int n = vcsFileSystem != null && vcsFileSystem.getAutoRefresh() == 0 ? 3 : 5;
        return this.getFileOrDir(string, n, object);
    }

    public CacheFile getFile(String string) {
        int n;
        String string2;
        FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
        CacheDir cacheDir = fileSystemCache.getDir(string2 = (n = (string = this.getAbsolutePath(string)).lastIndexOf(File.separatorChar)) < 0 ? "" : string.substring(0, n));
        if (cacheDir == null) {
            return null;
        }
        String string3 = n < 0 ? string : string.substring(n + 1);
        return cacheDir.getFile(string3);
    }

    public CacheDir getDir(String string) {
        FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
        CacheDir cacheDir = fileSystemCache.getDir(string = this.getAbsolutePath(string));
        if (cacheDir == null) {
            int n = string.lastIndexOf(File.separatorChar);
            String string2 = n < 0 ? "" : string.substring(0, n);
            CacheDir cacheDir2 = fileSystemCache.getDir(string2);
            if (cacheDir2 == null) {
                return null;
            }
            String string3 = n < 0 ? string : string.substring(n + 1);
            cacheDir = cacheDir2.getSubDir(string3);
        }
        return cacheDir;
    }

    public boolean isFile(String string) {
        return this.getFile(string) != null;
    }

    public boolean isDir(String string) {
        return this.getDir(string) != null;
    }

    public void readDir(String string) {
        this.readDir(string, null);
    }

    public void readDir(String string, Object object) {
        this.getFileOrDir(string + "/test", object);
    }

    public void readDirFromDiskCache(String string) {
        this.readDirFromDiskCache(string, null);
    }

    public void readDirFromDiskCache(String string, Object object) {
        this.getFileOrDir(string + "/test", 3, object);
    }

    private int adjustStrategy(int n) {
        VcsFileSystem vcsFileSystem;
        if (n > 3 && (vcsFileSystem = (VcsFileSystem)this.fileSystem.get()).isOffLine()) {
            return 3;
        }
        return n;
    }

    private boolean permitAction(int n) {
        VcsFileSystem vcsFileSystem;
        return n <= 3 || !(vcsFileSystem = (VcsFileSystem)this.fileSystem.get()).isOffLine();
    }

    public String[] getFilesAndSubdirs(String string) {
        VcsCacheDir vcsCacheDir = (VcsCacheDir)this.getDir(string);
        if (vcsCacheDir == null) {
            return null;
        }
        return vcsCacheDir.getFilesAndSubdirs();
    }

    public void refreshCacheDir(String string) {
        String string2;
        FileSystemCache fileSystemCache;
        CacheDir cacheDir;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem.isOffLine() && vcsFileSystem.getCommand("LIST_OFFLINE") == null) {
            if (NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.g("DLG_RefreshCommandDisabled"), 0)))) {
                vcsFileSystem.setOffLine(false);
            } else {
                return;
            }
        }
        if ((cacheDir = (fileSystemCache = this.handler.getCache(this.getCacheId())).getDir(string2 = this.getAbsolutePath(string))) == null && (cacheDir = fileSystemCache.getDir(string2 = VcsUtilities.getDirNamePart(string2))) == null) {
            this.getFileOrDir(VcsUtilities.getDirNamePart(string), null);
            return;
        }
        ((VcsCacheDir)cacheDir).setLoaded(false);
        ((VcsCache)fileSystemCache).doRefreshDir(cacheDir, false);
    }

    public void refreshCacheDirRecursive(String string) {
        String string2;
        FileSystemCache fileSystemCache;
        CacheDir cacheDir;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem.isOffLine() && vcsFileSystem.getCommand("LIST_OFFLINE") == null && vcsFileSystem.getCommand("LIST_SUB_OFFLINE") == null) {
            if (NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.g("DLG_RefreshCommandDisabled"), 0)))) {
                vcsFileSystem.setOffLine(false);
            } else {
                return;
            }
        }
        if ((cacheDir = (fileSystemCache = this.handler.getCache(this.getCacheId())).getDir(string2 = this.getAbsolutePath(string))) == null) {
            cacheDir = fileSystemCache.getDir(string2 = VcsUtilities.getDirNamePart(string2));
            if (cacheDir == null && "".equals(string)) {
                cacheDir = (CacheDir)fileSystemCache.getCacheFile(vcsFileSystem.getFile(string), 3, null);
            }
            if (cacheDir == null) {
                return;
            }
        }
        ((VcsCacheDir)cacheDir).setLoaded(false);
        ((VcsCache)fileSystemCache).doRefreshDir(cacheDir, true);
    }

    public void refreshDirFromDiskCache(File file) {
        this.refreshDirFromDiskCache(file, null);
    }

    public void refreshDirFromDiskCache(File file, Object object) {
        String string;
        FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
        CacheDir cacheDir = fileSystemCache.getDir(string = file.getAbsolutePath());
        if (cacheDir == null && (cacheDir = fileSystemCache.getDir(string = VcsUtilities.getDirNamePart(string))) == null) {
            return;
        }
        cacheDir.readFromDisk(object);
    }

    public void addFolder(String string) {
        FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
        File file = new File(this.getAbsolutePath(string));
        CacheDir cacheDir = fileSystemCache.getDir(file.getParent());
        VcsCacheDir vcsCacheDir = new VcsCacheDir(fileSystemCache.getId(), file);
        vcsCacheDir.setLocal(true);
        vcsCacheDir.setStatus(this.getLocalFileStatus());
        cacheDir.addChildDir(vcsCacheDir, true);
        fileSystemCache.registerDir(vcsCacheDir);
    }

    public void addFile(String string) {
        FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
        fileSystemCache.getCacheFile(new File(this.getAbsolutePath(string)), 0, null);
    }

    public void rename(String string, String string2) {
        FileSystemCache fileSystemCache = this.handler.getCache(this.getCacheId());
        CacheFile cacheFile = fileSystemCache.getCacheFile(new File(this.getAbsolutePath(string)), 0, null);
        if (cacheFile == null) {
            return;
        }
        String string3 = VcsUtilities.getDirNamePart(string2);
        CacheDir cacheDir = (CacheDir)fileSystemCache.getCacheFile(new File(this.getAbsolutePath(string3)), 0, null);
        String string4 = VcsUtilities.getFileNamePart(string2);
        if (cacheDir != null && cacheDir.equals(cacheFile.getParent())) {
            cacheDir.renameChild(cacheFile.getName(), string4, true);
        } else if (cacheFile instanceof VcsCacheFile) {
            if (((VcsCacheFile)cacheFile).isLocal()) {
                cacheFile.getParent().removeFile(cacheFile.getName(), true);
                if (cacheDir != null) {
                    cacheFile.setName(string4);
                    cacheDir.addFile(cacheFile, true);
                }
            }
        } else if (cacheFile instanceof VcsCacheDir && ((VcsCacheDir)cacheFile).isLocal()) {
            cacheFile.getParent().removeChildDir(cacheFile.getName(), true);
            if (cacheDir != null) {
                cacheFile.setName(string4);
                cacheDir.addChildDir((CacheDir)cacheFile, true);
            }
        }
    }

    public void remove(String string, boolean bl) {
        CacheDir cacheDir = null;
        if (bl) {
            CacheDir cacheDir2 = this.getDir(string);
            if (cacheDir2 != null && (cacheDir = cacheDir2.getParent()) != null) {
                cacheDir.removeChildDir(cacheDir2.getName(), true);
            }
        } else {
            CacheFile cacheFile = this.getFile(string);
            if (cacheFile != null) {
                cacheDir = cacheFile.getParent();
                cacheDir.removeFile(cacheFile.getName(), true);
            }
        }
    }

    private String g(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = VcsFSCache.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

