/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.commands;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.commands.CommandOutputPanel;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class CommandOutputVisualizer
extends VcsCommandVisualizer {
    public static final String MODE_NAME = "Default VCS Command Output";
    private static final int MAX_BUFFER_SIZE = 240000;
    private static final int FAST_APPEND_SIZE = 8000;
    private static final int MAX_AREA_SIZE = 232000;
    private static RequestProcessor outputDisplayRequestProcessor;
    private static Hashtable outputDisplayStuff;
    private CommandOutputPanel outputPanel;
    private ArrayList closeListeners = new ArrayList();
    private VcsCommandExecutor vce;
    private CommandsPool pool = null;
    private ActionListener killListener = null;
    private static final long serialVersionUID = -8901790341334731237L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer;

    protected CommandOutputVisualizer() {
        this.outputPanel = new CommandOutputPanel();
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/vcscore/commands/commandOutputWindow.gif"));
        ((JComponent)((Object)this)).putClientProperty("PersistenceType", "Never");
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        this.initComponents();
        Class clazz = class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer;
        synchronized (clazz) {
            if (outputDisplayRequestProcessor == null) {
                outputDisplayRequestProcessor = new RequestProcessor("Output Display Request Processor");
                outputDisplayRequestProcessor.post((Runnable)new OutputDisplayer());
            }
        }
    }

    public CommandOutputVisualizer(VcsCommandExecutor vcsCommandExecutor) {
        this();
        this.vce = vcsCommandExecutor;
        this.killListener = new CommandKillListener();
        this.outputPanel.addKillActionListener(this.killListener);
        this.outputPanel.setExec(vcsCommandExecutor.getExec());
        String string = vcsCommandExecutor.getCommand().getDisplayName();
        if (string == null || string.length() == 0) {
            string = vcsCommandExecutor.getCommand().getName();
        }
        this.setName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.name"), string));
    }

    public CommandOutputVisualizer(ActionListener actionListener, String string, String string2) {
        this();
        this.killListener = actionListener;
        this.outputPanel.addKillActionListener(this.killListener);
        this.outputPanel.setExec(string);
        this.setName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.name"), string2));
    }

    private void initComponents() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((Container)((Object)this)).add(this.outputPanel, gridBagConstraints);
        this.outputPanel.setStatus(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandExitStatus.running"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer), (String)"ACSN_CommandOutputVisualizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer), (String)"ACSD_CommandOutputVisualizer"));
    }

    synchronized void setCommandsPool(CommandsPool commandsPool) {
        this.pool = commandsPool;
    }

    public boolean openAfterCommandFinish() {
        return false;
    }

    public void open(Workspace workspace) {
        Mode mode;
        if (workspace == null) {
            workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        }
        if ((mode = workspace.findMode((TopComponent)this)) == null) {
            String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandOutputVisualizer.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.modeName");
            mode = workspace.createMode(MODE_NAME, string, null);
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
        this.requestFocus();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.outputPanel.componentActivated();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.outputPanel.componentDeactivated();
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.close();
        return null;
    }

    private void appendLineToArea(JTextArea jTextArea, String string) {
        Hashtable hashtable = outputDisplayStuff;
        synchronized (hashtable) {
            StringBuffer stringBuffer = (StringBuffer)outputDisplayStuff.get(jTextArea);
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string + "\n");
                Hashtable hashtable2 = outputDisplayStuff;
                synchronized (hashtable2) {
                    outputDisplayStuff.put(jTextArea, stringBuffer);
                    if (outputDisplayStuff.size() == 1) {
                        outputDisplayStuff.notify();
                    }
                }
            } else {
                stringBuffer.append(string + "\n");
                if (stringBuffer.length() > 240000) {
                    stringBuffer.delete(0, stringBuffer.length() - 232000 - 1);
                }
            }
        }
    }

    public void stdOutputLine(String string) {
        this.appendLineToArea(this.outputPanel.getStdOutputArea(), string);
    }

    public void errOutputLine(String string) {
        this.appendLineToArea(this.outputPanel.getErrOutputArea(), string);
    }

    public void stdOutputData(String[] stringArray) {
        this.appendLineToArea(this.outputPanel.getStdDataOutputArea(), VcsUtilities.arrayToString(stringArray));
    }

    public void errOutputData(String[] stringArray) {
        this.appendLineToArea(this.outputPanel.getErrDataOutputArea(), VcsUtilities.arrayToString(stringArray));
    }

    public void setExitStatus(int n) {
        this.outputPanel.setStatus(CommandsPool.getExitStatusString(n));
        this.outputPanel.commandFinished(true);
    }

    public void addCloseListener(TopComponentCloseListener topComponentCloseListener) {
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            this.closeListeners.add(topComponentCloseListener);
        }
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        boolean bl2 = super.canClose(workspace, bl);
        if (bl && bl2) {
            this.closing();
        }
        return bl2;
    }

    private void closing() {
        this.outputPanel.removeKillActionListener(this.killListener);
        CommandOutputVisualizer commandOutputVisualizer = this;
        synchronized (commandOutputVisualizer) {
            this.pool = null;
        }
        ArrayList arrayList = this.closeListeners;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.closeListeners).iterator();
            while (iterator.hasNext()) {
                TopComponentCloseListener topComponentCloseListener = (TopComponentCloseListener)iterator.next();
                topComponentCloseListener.closing();
            }
            this.closeListeners.clear();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class OutputDisplayer
    implements Runnable {
        private Random random;

        public OutputDisplayer() {
            outputDisplayStuff = new Hashtable();
            this.random = new Random();
        }

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                int n;
                String string;
                String string2;
                JTextArea jTextArea;
                int n2 = this.random.nextInt(outputDisplayStuff.size());
                Enumeration enumeration = outputDisplayStuff.keys();
                do {
                    jTextArea = (JTextArea)enumeration.nextElement();
                } while (--n2 >= 0);
                int n3 = jTextArea.getDocument().getLength();
                Hashtable hashtable = outputDisplayStuff;
                synchronized (hashtable) {
                    StringBuffer stringBuffer = (StringBuffer)outputDisplayStuff.get(jTextArea);
                    if (stringBuffer.length() >= 232000) {
                        string2 = null;
                        string = stringBuffer.substring(stringBuffer.length() - 8000, stringBuffer.length()).toString();
                        stringBuffer.delete(0, string.length());
                        n = n3 - string.length();
                        if (n < 0) {
                            n = 0;
                        }
                    } else {
                        stringBuffer = (StringBuffer)outputDisplayStuff.remove(jTextArea);
                        string2 = stringBuffer.toString();
                        n = 0;
                        n3 = (n3 += string2.length()) < 232000 ? 0 : n3 - 232000 + 8000;
                        string = null;
                    }
                }
                if (string2 != null) {
                    jTextArea.append(string2);
                }
                if (n3 > 0) {
                    jTextArea.replaceRange(string, n, n3);
                }
            } else {
                block12: while (true) {
                    Hashtable hashtable = outputDisplayStuff;
                    synchronized (hashtable) {
                        if (outputDisplayStuff.size() == 0) {
                            try {
                                outputDisplayStuff.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                    }
                    do {
                        try {
                            SwingUtilities.invokeAndWait(this);
                            Thread.currentThread();
                            Thread.yield();
                            Thread.currentThread();
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            continue block12;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            TopManager.getDefault().notifyException((Throwable)invocationTargetException);
                            continue block12;
                        }
                    } while (outputDisplayStuff.size() > 0);
                }
            }
        }
    }

    class CommandKillListener
    implements ActionListener {
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer;

        CommandKillListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CommandOutputVisualizer.this.pool != null) {
                String string = CommandOutputVisualizer.this.vce.getCommand().getDisplayName();
                if (string == null || string.length() == 0) {
                    string = CommandOutputVisualizer.this.vce.getCommand().getName();
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer == null ? (class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer = CommandKillListener.class$("org.netbeans.modules.vcscore.commands.CommandOutputVisualizer")) : class$org$netbeans$modules$vcscore$commands$CommandOutputVisualizer)).getString("CommandOutputVisualizer.killCommand"), string), 2);
                if (NotifyDescriptor.OK_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)confirmation))) {
                    CommandKillListener commandKillListener = this;
                    synchronized (commandKillListener) {
                        if (CommandOutputVisualizer.this.pool != null) {
                            CommandOutputVisualizer.this.pool.kill(CommandOutputVisualizer.this.vce);
                        }
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

