/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.runtime;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.CommandListener;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandsProvider;
import org.netbeans.modules.vcscore.runtime.RuntimeFolderNode;
import org.netbeans.modules.vcscore.runtime.VcsRuntimeCommand;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class VcsRuntimeCommandsProvider
extends RuntimeCommandsProvider {
    private VcsFileSystem fs;
    private RuntimeCommandsListener rcl = new RuntimeCommandsListener();
    private int numOfCommandsToKeep = 20;
    private List finishedCommands = new ArrayList();
    private List commands = new ArrayList();
    private Map runtimeCommandsForExecutors = new HashMap();
    private Map finishedExecutorsForCommands = new HashMap();
    private CommandsPool cpool = CommandsPool.getInstance();

    public VcsRuntimeCommandsProvider(VcsFileSystem vcsFileSystem) {
        this.fs = vcsFileSystem;
        this.cpool.addCommandListener(this.rcl);
        this.cpool.removeFinishedCommandsUponRequest(true, vcsFileSystem);
        vcsFileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.rcl, (Object)vcsFileSystem));
        this.numOfCommandsToKeep = vcsFileSystem.getNumberOfFinishedCmdsToCollect();
    }

    protected Node createNodeDelegate() {
        String string;
        RuntimeFolderNode runtimeFolderNode = new RuntimeFolderNode((Children)new RuntimeCommandsProvider.RuntimeFolderChildren(this));
        runtimeFolderNode.setName(this.fs.getSystemName());
        runtimeFolderNode.setDisplayName(this.fs.getDisplayName());
        runtimeFolderNode.setNumOfFinishedCmdsToCollect(this.numOfCommandsToKeep);
        BeanDescriptor beanDescriptor = VcsRuntimeCommandsProvider.getFsBeanDescriptor(this.fs);
        if (beanDescriptor != null && (string = (String)beanDescriptor.getValue("VCS Icon Base")) != null) {
            runtimeFolderNode.setIconBase(string);
        }
        runtimeFolderNode.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.rcl, (Object)((Object)runtimeFolderNode)));
        return runtimeFolderNode;
    }

    private static BeanDescriptor getFsBeanDescriptor(VcsFileSystem vcsFileSystem) {
        BeanInfo beanInfo;
        try {
            beanInfo = Utilities.getBeanInfo(vcsFileSystem.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        if (beanInfo != null) {
            return beanInfo.getBeanDescriptor();
        }
        return null;
    }

    public RuntimeCommand[] children() {
        return this.commands.toArray(new RuntimeCommand[this.commands.size()]);
    }

    public boolean cutCommandsToMaxToKeep() {
        Object object;
        boolean bl = false;
        ArrayList<VcsCommandExecutor> arrayList = new ArrayList<VcsCommandExecutor>();
        VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = this;
        synchronized (vcsRuntimeCommandsProvider) {
            int n = this.commands.size();
            while (n > this.numOfCommandsToKeep && this.finishedCommands.size() > 0) {
                object = (RuntimeCommand)this.finishedCommands.remove(0);
                this.commands.remove(object);
                VcsCommandExecutor vcsCommandExecutor = (VcsCommandExecutor)this.finishedExecutorsForCommands.remove(object);
                arrayList.add(vcsCommandExecutor);
                --n;
                bl = true;
            }
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            object = (VcsCommandExecutor)iterator.next();
            this.cpool.removeFinishedCommand((VcsCommandExecutor)object);
        }
        return bl;
    }

    protected void notifyRemoved() {
        this.cpool.removeCommandListener(this.rcl);
        this.cpool.removeFinishedCommandsUponRequest(false, this.fs);
    }

    private class RuntimeCommandsListener
    implements CommandListener,
    PropertyChangeListener {
        private RuntimeCommandsListener() {
        }

        public void commandPreprocessing(VcsCommandExecutor vcsCommandExecutor) {
            VcsFileSystem vcsFileSystem = VcsRuntimeCommandsProvider.this.cpool.getFileSystemForExecutor(vcsCommandExecutor);
            if (VcsRuntimeCommandsProvider.this.fs == vcsFileSystem || VcsRuntimeCommandsProvider.this.equals(RuntimeCommandsProvider.findProvider((FileSystem)vcsFileSystem))) {
                VcsRuntimeCommand vcsRuntimeCommand = new VcsRuntimeCommand(vcsCommandExecutor);
                vcsRuntimeCommand.setState(10);
                VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = VcsRuntimeCommandsProvider.this;
                synchronized (vcsRuntimeCommandsProvider) {
                    VcsRuntimeCommandsProvider.this.commands.add(vcsRuntimeCommand);
                    VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.put(vcsCommandExecutor, vcsRuntimeCommand);
                    VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep();
                }
                VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
            }
        }

        public void commandPreprocessed(VcsCommandExecutor vcsCommandExecutor, boolean bl) {
            if (!bl) {
                VcsFileSystem vcsFileSystem = VcsRuntimeCommandsProvider.this.cpool.getFileSystemForExecutor(vcsCommandExecutor);
                if (VcsRuntimeCommandsProvider.this.fs == vcsFileSystem || VcsRuntimeCommandsProvider.this.equals(RuntimeCommandsProvider.findProvider((FileSystem)vcsFileSystem))) {
                    VcsRuntimeCommand vcsRuntimeCommand = (VcsRuntimeCommand)VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.get(vcsCommandExecutor);
                    VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = VcsRuntimeCommandsProvider.this;
                    synchronized (vcsRuntimeCommandsProvider) {
                        VcsRuntimeCommandsProvider.this.commands.remove(vcsRuntimeCommand);
                        VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.remove(vcsCommandExecutor);
                    }
                    VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
                }
            }
        }

        public void commandStarted(VcsCommandExecutor vcsCommandExecutor) {
            VcsFileSystem vcsFileSystem = VcsRuntimeCommandsProvider.this.cpool.getFileSystemForExecutor(vcsCommandExecutor);
            if (VcsRuntimeCommandsProvider.this.fs == vcsFileSystem || VcsRuntimeCommandsProvider.this.equals(RuntimeCommandsProvider.findProvider((FileSystem)vcsFileSystem))) {
                VcsRuntimeCommand vcsRuntimeCommand = (VcsRuntimeCommand)VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.get(vcsCommandExecutor);
                if (vcsRuntimeCommand == null) {
                    vcsRuntimeCommand = new VcsRuntimeCommand(vcsCommandExecutor);
                    VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = VcsRuntimeCommandsProvider.this;
                    synchronized (vcsRuntimeCommandsProvider) {
                        VcsRuntimeCommandsProvider.this.commands.add(vcsRuntimeCommand);
                        VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.put(vcsCommandExecutor, vcsRuntimeCommand);
                        VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep();
                    }
                    VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
                }
                vcsRuntimeCommand.setState(11);
            }
        }

        public void commandDone(VcsCommandExecutor vcsCommandExecutor) {
            RuntimeCommand runtimeCommand;
            VcsFileSystem vcsFileSystem = VcsRuntimeCommandsProvider.this.cpool.getFileSystemForExecutor(vcsCommandExecutor);
            if (vcsFileSystem == null) {
                return;
            }
            if ((VcsRuntimeCommandsProvider.this.fs == vcsFileSystem || VcsRuntimeCommandsProvider.this.equals(RuntimeCommandsProvider.findProvider((FileSystem)vcsFileSystem))) && (runtimeCommand = (RuntimeCommand)VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.get(vcsCommandExecutor)) != null) {
                VcsRuntimeCommandsProvider vcsRuntimeCommandsProvider = VcsRuntimeCommandsProvider.this;
                synchronized (vcsRuntimeCommandsProvider) {
                    VcsRuntimeCommandsProvider.this.runtimeCommandsForExecutors.remove(vcsCommandExecutor);
                    VcsRuntimeCommandsProvider.this.finishedExecutorsForCommands.put(runtimeCommand, vcsCommandExecutor);
                    VcsRuntimeCommandsProvider.this.finishedCommands.add(runtimeCommand);
                    VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep();
                }
                runtimeCommand.setState(12);
                VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object == VcsRuntimeCommandsProvider.this.fs) {
                RuntimeFolderNode runtimeFolderNode;
                if ("numberOfFinishedCmdsToCollect".equals(string)) {
                    int n = VcsRuntimeCommandsProvider.this.fs.getNumberOfFinishedCmdsToCollect();
                    if (VcsRuntimeCommandsProvider.this.numOfCommandsToKeep == n) {
                        return;
                    }
                    VcsRuntimeCommandsProvider.this.numOfCommandsToKeep = n;
                    RuntimeFolderNode runtimeFolderNode2 = (RuntimeFolderNode)VcsRuntimeCommandsProvider.this.getExistingNodeDelegate();
                    if (runtimeFolderNode2 != null) {
                        runtimeFolderNode2.setNumOfFinishedCmdsToCollect(VcsRuntimeCommandsProvider.this.numOfCommandsToKeep);
                    }
                    if (VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep()) {
                        VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
                    }
                } else if ("displayName".equals(string) && (runtimeFolderNode = (RuntimeFolderNode)VcsRuntimeCommandsProvider.this.getExistingNodeDelegate()) != null) {
                    runtimeFolderNode.setDisplayName(VcsRuntimeCommandsProvider.this.fs.getDisplayName());
                }
            } else if (object instanceof RuntimeFolderNode) {
                RuntimeFolderNode runtimeFolderNode = (RuntimeFolderNode)((Object)object);
                if ("numberOfFinishedCmdsToCollect".equals(string)) {
                    int n = runtimeFolderNode.getNumOfFinishedCmdsToCollect();
                    if (VcsRuntimeCommandsProvider.this.numOfCommandsToKeep == n) {
                        return;
                    }
                    VcsRuntimeCommandsProvider.this.numOfCommandsToKeep = n;
                    VcsRuntimeCommandsProvider.this.fs.setNumberOfFinishedCmdsToCollect(VcsRuntimeCommandsProvider.this.numOfCommandsToKeep);
                    if (VcsRuntimeCommandsProvider.this.cutCommandsToMaxToKeep()) {
                        VcsRuntimeCommandsProvider.this.firePropertyChange("children", null, null);
                    }
                }
            }
        }
    }
}

