/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vcscore.ui.views.ChildrenInfoFilter;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoChildren;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class FileVcsInfo
implements Node.Cookie {
    public static final String BLANK = "BLANK";
    public static final String PROPERTY_NODE_PATH = "NODE_PATH";
    public static final String PROPERTY_FILTER = "FILTER_UPDATED";
    private static final String PROPERTY_CHILDREN = "Children.Keys Instance";
    private File file;
    private transient WeakReference fileObject = null;
    private transient WeakReference versFileObject = null;
    private transient FileVcsInfoFactory.GeneralTypeInfo info;
    private String type;
    private Map attrMap;
    private boolean dumped;
    private File dumpFile;
    private transient EventListenerList listenerList = null;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public FileVcsInfo() {
        this(new File(""), BLANK, (Children)new FileVcsInfoChildren());
    }

    private FileVcsInfo(File file, Children children) {
        this.file = file;
        this.attrMap = new HashMap(6, 0.9f);
        this.setAttribute(PROPERTY_CHILDREN, children);
        this.dumped = false;
    }

    public FileVcsInfo(File file, String string, Children children) {
        this(file, children);
        this.type = string;
    }

    public File getFile() {
        return this.file;
    }

    public Children getChildren() {
        return (Children)this.getAttribute(PROPERTY_CHILDREN);
    }

    protected void reviveDumpedIfNeccesary(String string) {
        if (!this.dumped || this.info.isDumpAbleAttribute(string)) {
            // empty if block
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dumpAttributesToDisk() {
        if (this.dumped) {
            return;
        }
        String[] stringArray = this.info.getAttributesAllowedToDump();
        if (stringArray == null) return;
        ObjectOutputStream objectOutputStream = null;
        this.dumpFile = File.createTempFile(this.getType(), "dmp");
        this.dumpFile.deleteOnExit();
        objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dumpFile));
        int n = 0;
        while (n < stringArray.length) {
            Object object = this.getAttribute(stringArray[n]);
            if (object instanceof Composite) {
                Composite composite = (Composite)object;
                composite.dumpAllRows(this, objectOutputStream);
            } else {
                objectOutputStream.writeUTF(stringArray[n]);
                objectOutputStream.writeObject(object);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.attrMap.remove(stringArray[n2]);
            ++n2;
        }
        this.dumped = true;
        Object var7_8 = null;
        if (objectOutputStream == null) return;
        try {
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.dumped = false;
        }
        return;
        {
            catch (IOException iOException) {
                this.dumped = false;
                Object var7_9 = null;
                if (objectOutputStream == null) return;
                try {
                    objectOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    this.dumped = false;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (objectOutputStream == null) throw throwable;
            try {
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.dumped = false;
            }
            throw throwable;
        }
    }

    public void setChildrenFilter(ChildrenInfoFilter childrenInfoFilter) {
        this.setChildrenFilter(childrenInfoFilter, true);
    }

    private void setChildrenFilter(ChildrenInfoFilter childrenInfoFilter, boolean bl) {
        Children children = this.getChildren();
        if (children instanceof FileVcsInfoChildren) {
            FileVcsInfoChildren fileVcsInfoChildren = (FileVcsInfoChildren)children;
            Iterator iterator = fileVcsInfoChildren.getAllKeys();
            while (iterator.hasNext()) {
                FileVcsInfo fileVcsInfo = (FileVcsInfo)iterator.next();
                fileVcsInfo.setChildrenFilter(childrenInfoFilter);
            }
            fileVcsInfoChildren.setChildrenNodesFilter(childrenInfoFilter);
            this.firePropertyChangeListener(new PropertyChangeEvent(this, PROPERTY_FILTER, null, childrenInfoFilter));
        }
    }

    void replaceChildrenWithClone() {
        if (this.getChildren() instanceof FileVcsInfoChildren) {
            Children children = (Children)((FileVcsInfoChildren)this.getChildren()).clone();
            this.setAttribute(PROPERTY_CHILDREN, children);
        }
    }

    void setGeneralTypeInfo(FileVcsInfoFactory.GeneralTypeInfo generalTypeInfo) {
        this.info = generalTypeInfo;
    }

    void overwriteAttributesFrom(FileVcsInfo fileVcsInfo) {
        Children children = this.getChildren();
        this.attrMap.clear();
        this.attrMap = fileVcsInfo.getMap();
    }

    Map getMap() {
        return this.attrMap;
    }

    public SystemAction[] getAdditionalActions() {
        if (this.info != null) {
            return this.info.getAdditionalActions();
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        this.reviveDumpedIfNeccesary(string);
        this.attrMap.put(string, object);
        this.firePropertyChangeListener(new PropertyChangeEvent(this, string, null, object));
    }

    public Object getAttribute(String string) {
        this.reviveDumpedIfNeccesary(string);
        return this.attrMap.get(string);
    }

    public String getAttributeNonNull(String string) {
        this.reviveDumpedIfNeccesary(string);
        Object v = this.attrMap.get(string);
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public String getType() {
        return this.type;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = FileVcsInfo.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = FileVcsInfo.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
    }

    private void firePropertyChangeListener(PropertyChangeEvent propertyChangeEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$beans$PropertyChangeListener == null ? FileVcsInfo.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                ((PropertyChangeListener)objectArray[n + 1]).propertyChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class CompositeItem
    implements Serializable {
        static final long serialVersionUID = 0L;
        private Map attrMap = new HashMap(5, 0.9f);

        public void setAttribute(String string, Object object) {
            this.attrMap.put(string, object);
        }

        public Object getAttribute(String string) {
            return this.attrMap.get(string);
        }

        public String getAttributeNonNull(String string) {
            Object v = this.attrMap.get(string);
            if (v == null) {
                return "";
            }
            return v.toString();
        }
    }

    public static class Composite {
        public static final String PROPERTY_SELECTED_ITEMS = "SelectedItems";
        public static final String PROPERTY_ADDED_ITEM = "AddedItem";
        static final String COMPOSITE_BLOCK_START = "COMPOSITE_DUMP_BLOCK_START";
        static final String COMPOSITE_BLOCK_END = "COMPOSITE_DUMP_BLOCK_END";
        private String type;
        private List list;
        private FileVcsInfo info;
        private CompositeItem[] selectedItems;
        private EventListenerList listenerList = null;
        static /* synthetic */ Class class$java$beans$PropertyChangeListener;

        public Composite(String string) {
            this.list = new ArrayList();
            this.type = string;
            this.info = null;
        }

        public Composite(List list, String string) {
            this.type = string;
            this.list = new ArrayList(list);
        }

        void dumpAllRows(FileVcsInfo fileVcsInfo, ObjectOutputStream objectOutputStream) throws IOException {
            this.info = fileVcsInfo;
            Iterator iterator = this.list.iterator();
            objectOutputStream.writeUTF(this.getType());
            objectOutputStream.writeObject(COMPOSITE_BLOCK_START);
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
                iterator.remove();
            }
            objectOutputStream.writeObject(COMPOSITE_BLOCK_END);
        }

        void reviveDumpedRows(ObjectOutputStream objectOutputStream) throws IOException {
        }

        protected void reviveDumpedIfNeccesary() {
            if (this.info != null) {
                this.info.reviveDumpedIfNeccesary(this.getType());
            }
        }

        public void appendRow(CompositeItem compositeItem) {
            this.reviveDumpedIfNeccesary();
            this.list.add(compositeItem);
            this.firePropertyChangeListener(new PropertyChangeEvent(this, PROPERTY_ADDED_ITEM, null, compositeItem));
        }

        public String getType() {
            return this.type;
        }

        public CompositeItem getRow(int n) {
            this.reviveDumpedIfNeccesary();
            if (n >= 0 && n < this.list.size()) {
                return (CompositeItem)this.list.get(n);
            }
            return null;
        }

        public Object getItem(int n, String string) {
            this.reviveDumpedIfNeccesary();
            if (n >= 0 && n < this.list.size()) {
                CompositeItem compositeItem = (CompositeItem)this.list.get(n);
                return compositeItem.getAttribute(string);
            }
            return null;
        }

        public int getCount() {
            this.reviveDumpedIfNeccesary();
            return this.list.size();
        }

        public void setSelectedItems(CompositeItem[] compositeItemArray) {
            CompositeItem[] compositeItemArray2 = this.selectedItems;
            this.selectedItems = compositeItemArray;
            this.firePropertyChangeListener(new PropertyChangeEvent(this, PROPERTY_SELECTED_ITEMS, compositeItemArray2, this.selectedItems));
        }

        public CompositeItem[] getSelectedItems() {
            return this.selectedItems;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Composite.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Composite.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }

        private void firePropertyChangeListener(PropertyChangeEvent propertyChangeEvent) {
            if (this.listenerList == null) {
                return;
            }
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$java$beans$PropertyChangeListener == null ? Composite.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                    ((PropertyChangeListener)objectArray[n + 1]).propertyChange(propertyChangeEvent);
                }
                n -= 2;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

