/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.util.table.ColumnSortListener;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class TableView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = 0L;
    private transient ExplorerManager manager;
    protected transient JTable table;
    protected transient TableInfoModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupAdapter popupListener;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean listenerActive;
    private String compositeAttributeName;
    private transient FileVcsInfo.Composite composite = null;
    private transient FileVcsInfo info = null;
    private CallableSystemAction[] actions;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    public TableView(String string, TableInfoModel tableInfoModel) {
        this.model = tableInfoModel;
        this.initializeTable();
        this.compositeAttributeName = string;
    }

    private void initializeTable() {
        this.table = this.createTable();
        this.table.setModel(this.model);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setUpdateTableInRealTime(true);
        ColumnSortListener columnSortListener = new ColumnSortListener(this.table);
        jTableHeader.addMouseListener(columnSortListener);
        this.setViewportView(this.table);
        this.managerListener = new Listener();
        this.popupListener = new PopupAdapter();
        this.model.addTableModelListener(this.managerListener);
        this.table.addMouseListener(this.managerListener);
        this.table.addMouseListener((MouseListener)((Object)this.popupListener));
        this.table.getSelectionModel().setSelectionMode(0);
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.addFocusListener(new FocusAdapter());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Boolean(this.popupAllowed));
        objectOutput.writeObject(new Boolean(this.traversalAllowed));
        objectOutput.writeObject(this.compositeAttributeName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)objectInput.readObject();
        this.traversalAllowed = (Boolean)objectInput.readObject();
        this.compositeAttributeName = objectInput.readUTF();
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean bl) {
        this.popupAllowed = bl;
    }

    public boolean isTraversalAllowed() {
        return false;
    }

    public void setTraversalAllowed(boolean bl) {
        this.traversalAllowed = bl;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener actionListener) {
        this.defaultProcessor = actionListener;
    }

    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        this.table.setColumnModel(tableColumnModel);
    }

    public void setSelectedItems(FileVcsInfo.CompositeItem[] compositeItemArray, boolean bl) {
        if (compositeItemArray != null) {
            int[] nArray = new int[compositeItemArray.length];
            this.table.clearSelection();
            if (!bl) {
                this.table.getSelectionModel().setValueIsAdjusting(true);
            }
            int n = 0;
            while (n < compositeItemArray.length) {
                nArray[n] = this.model.getElementRow(compositeItemArray[n]);
                if (bl) {
                    this.table.changeSelection(nArray[n], 0, false, false);
                } else {
                    this.table.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
                }
                ++n;
            }
            if (!bl) {
                this.table.getSelectionModel().setValueIsAdjusting(false);
            }
        } else if (bl) {
            this.table.clearSelection();
        } else {
            this.table.getSelectionModel().clearSelection();
        }
    }

    public void setAdditionalActions(CallableSystemAction[] callableSystemActionArray) {
        this.actions = callableSystemActionArray;
    }

    public boolean isDragSource() {
        return false;
    }

    public void setDragSource(boolean bl) {
    }

    public boolean isDropTarget() {
        return false;
    }

    public void setDropTarget(boolean bl) {
    }

    protected JTable createTable() {
        NbTable nbTable = new NbTable();
        return nbTable;
    }

    public TableInfoModel getTableModel() {
        return this.model;
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        return true;
    }

    private void fillModelWithData(Node node) {
        this.clearModel();
        this.info = (FileVcsInfo)node.getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = TableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
        this.info.addPropertyChangeListener(this.managerListener);
        Object object = this.info.getAttribute(this.compositeAttributeName);
        if (object != null && object instanceof FileVcsInfo.Composite) {
            this.composite = (FileVcsInfo.Composite)object;
            if (this.composite.getCount() > 0) {
                int n = 0;
                while (n < this.composite.getCount()) {
                    this.model.addElement(this.composite.getRow(n));
                    ++n;
                }
            }
        }
    }

    private void clearModel() {
        if (this.info != null) {
            this.info.removePropertyChangeListener(this.managerListener);
            this.info = null;
        }
        if (this.composite != null) {
            FileVcsInfo.CompositeItem[] compositeItemArray = null;
            this.composite.setSelectedItems(compositeItemArray);
            this.composite = null;
        }
        this.model.clear();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListener.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.updateSelection();
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.table.getSelectionModel().addListSelectionListener(this.managerListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.table.getSelectionModel().removeListSelectionListener(this.managerListener);
        if (this.info != null) {
            this.info.removePropertyChangeListener(this.managerListener);
        }
    }

    public void requestFocus() {
        this.table.requestFocus();
    }

    final void performObjectAt(int n, int n2) {
        if (n < 0 || n >= this.model.getRowCount()) {
            return;
        }
    }

    private void updateSelection() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1 && nodeArray[0].getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = TableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo) != null) {
            this.fillModelWithData(nodeArray[0]);
            Collections.sort(this.model.getList(), this.model);
        } else {
            this.clearModel();
        }
        this.table.tableChanged(new TableModelEvent(this.model));
    }

    void createPopup(int n, int n2) {
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])this.manager.getSelectedNodes());
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0) {
            Object object;
            MenuElement[] menuElementArray;
            if (this.actions != null && this.actions.length > 0) {
                menuElementArray = jPopupMenu.getSubElements();
                if (menuElementArray != null && menuElementArray.length > 1 && !menuElementArray[0].getComponent().getClass().equals(class$javax$swing$JSeparator == null ? (class$javax$swing$JSeparator = TableView.class$("javax.swing.JSeparator")) : class$javax$swing$JSeparator)) {
                    jPopupMenu.insert(new JSeparator(), 0);
                }
                int n3 = 0;
                while (n3 < this.actions.length) {
                    object = this.actions[n3];
                    jPopupMenu.insert(object.getPopupPresenter(), n3);
                    ++n3;
                }
            }
            menuElementArray = this.getViewport().getViewPosition();
            menuElementArray.x = n - menuElementArray.x;
            menuElementArray.y = n2 - menuElementArray.y;
            SwingUtilities.convertPointToScreen((Point)menuElementArray, this);
            Dimension dimension = jPopupMenu.getPreferredSize();
            object = Toolkit.getDefaultToolkit().getScreenSize();
            if (menuElementArray.x + dimension.width > object.width) {
                menuElementArray.x = object.width - dimension.width;
            }
            if (menuElementArray.y + dimension.height > object.height) {
                menuElementArray.y = object.height - dimension.height;
            }
            SwingUtilities.convertPointFromScreen((Point)menuElementArray, this);
            jPopupMenu.show(this, menuElementArray.x, menuElementArray.y);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class Listener
    extends MouseAdapter
    implements TableModelListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        private Listener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                // empty if block
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            TableView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && !TableView.this.selectionAccept(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                TableView.this.updateSelection();
                return;
            }
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                TableView.this.updateSelection();
                return;
            }
            if (propertyChangeEvent.getSource() != null && propertyChangeEvent.getSource() instanceof FileVcsInfo) {
                FileVcsInfo fileVcsInfo = (FileVcsInfo)propertyChangeEvent.getSource();
                if (propertyChangeEvent.getPropertyName().equals(TableView.this.compositeAttributeName)) {
                    TableView.this.updateSelection();
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = TableView.this.table.getSelectedRows();
            if (nArray.length > 0 && TableView.this.composite != null) {
                FileVcsInfo.CompositeItem[] compositeItemArray = new FileVcsInfo.CompositeItem[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    compositeItemArray[n] = (FileVcsInfo.CompositeItem)TableView.this.model.getElementAt(nArray[n]);
                    ++n;
                }
                TableView.this.composite.setSelectedItems(compositeItemArray);
            } else if (TableView.this.composite != null) {
                TableView.this.composite.setSelectedItems(null);
            }
        }
    }

    final class FocusAdapter
    implements FocusListener {
        CallbackSystemAction csa;
        PopupPerformer performer;
        static /* synthetic */ Class class$org$openide$ErrorManager;

        FocusAdapter() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.csa == null) {
                try {
                    Class<?> clazz = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(clazz);
                    this.performer = new PopupPerformer();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError();
                    ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = FocusAdapter.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                    if (errorManager != null) {
                        errorManager.annotate((Throwable)noClassDefFoundError, (Throwable)classNotFoundException);
                    }
                    throw noClassDefFoundError;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this.performer);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    final class PopupPerformer
    implements ActionPerformer {
        PopupPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n;
                    ListSelectionModel listSelectionModel = ((PopupPerformer)this).TableView.this.table.getSelectionModel();
                    boolean bl = listSelectionModel.getSelectionMode() != 0;
                    int n2 = n = bl ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getLeadSelectionIndex();
                    if (n < 0) {
                        return;
                    }
                    Rectangle rectangle = ((PopupPerformer)this).TableView.this.table.getCellRect(((PopupPerformer)this).TableView.this.table.getSelectedRow(), ((PopupPerformer)this).TableView.this.table.getSelectedColumn(), false);
                    Point point = rectangle.getLocation();
                    if (point == null) {
                        return;
                    }
                    TableView.this.createPopup(point.x, point.y);
                }
            });
        }
    }

    private final class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        private PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = TableView.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (TableView.this.table.getSelectedRow() != n) {
                TableView.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
            TableView.this.createPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    final class NbTable
    extends JTable {
        static final long serialVersionUID = 0L;

        NbTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Object object;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && (object = TableView.this.model.getValueAt(n, n2)) != null) {
                    return object.toString();
                }
            }
            return null;
        }
    }
}

