/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.util.NbBundle;

public class ChooseFileDialog
extends JDialog {
    private Debug E;
    private Debug D;
    private JFileChooser chooser;
    private File initialDir;
    private File selectedFile;
    private boolean propFileFilter;
    static final long serialVersionUID = -4725583654994487624L;

    public ChooseFileDialog(Frame frame, File file, boolean bl) {
        super(frame, "", true);
        this.D = this.E = new Debug("ChooseFileDialog", false);
        this.chooser = null;
        this.initialDir = null;
        this.selectedFile = null;
        this.propFileFilter = false;
        this.setTitle(this.g("CTL_Select_file"));
        this.initialDir = file;
        this.propFileFilter = bl;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(0);
        if (this.propFileFilter) {
            this.chooser.setFileFilter(new PropertiesFileFilter());
        }
        if (this.initialDir != null) {
            this.chooser.setCurrentDirectory(this.initialDir);
        }
        this.chooser.setApproveButtonText(this.g("CTL_Select"));
        this.chooser.setApproveButtonToolTipText(this.g("CTL_SelectToolTip"));
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChooseFileDialog.this.selectedFile = null;
                ChooseFileDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ChooseFileDialog.this.selectedFile = null;
                    ChooseFileDialog.this.close();
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.chooser, "Center");
        this.chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                    File file = ChooseFileDialog.this.chooser.getSelectedFile();
                    ChooseFileDialog.this.selectedFile = file;
                    ChooseFileDialog.this.close();
                } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                    ChooseFileDialog.this.selectedFile = null;
                    ChooseFileDialog.this.close();
                }
            }
        });
    }

    private void close() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public String getSelectedFile() {
        String string = null;
        if (this.selectedFile == null) {
            return null;
        }
        try {
            string = this.selectedFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.E.err(iOException, "getSelectedFile()");
            string = null;
        }
        return string;
    }

    String g(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.cmdline.Bundle").getString(string);
    }

    String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }

    class PropertiesFileFilter
    extends FileFilter {
        private static final String EXTENSION = "properties";

        PropertiesFileFilter() {
        }

        public boolean accept(File file) {
            int n = file.getName().indexOf(".");
            String string = "";
            if (n > 0) {
                string = file.getName().substring(n + 1);
            }
            return string.equals(EXTENSION);
        }

        public String getDescription() {
            return "Properties files (*.properties)";
        }
    }
}

