/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.vcscore.util.VariableInputValidator;

public class VariableInputComponent {
    private int component;
    private boolean expert = false;
    private String variable;
    private String label;
    private Character labelMnemonic;
    private String a11yName = null;
    private String a11yDescription = null;
    private String value = null;
    private String valueSelected = null;
    private String valueUnselected = null;
    private String defaultValue = null;
    private Dimension dimension = null;
    private HashSet enable = null;
    private HashSet disable = null;
    private String selector = null;
    private String validator = null;
    private ArrayList subComponents = null;
    private String[] varConditions = new String[2];
    private String[] selectorVarConditions = new String[2];
    private ArrayList history = new ArrayList();

    public VariableInputComponent(int n, String string, String string2) {
        this(n, string, string2, null);
    }

    public VariableInputComponent(int n, String string, String string2, String string3) {
        this.component = n;
        this.variable = string;
        this.label = string2;
        this.labelMnemonic = string3 != null && string3.length() > 0 ? new Character(string3.charAt(0)) : null;
    }

    public int getComponent() {
        return this.component;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVarConditions(String[] stringArray) {
        this.varConditions = stringArray;
    }

    public String[] getVarConditions() {
        return this.varConditions;
    }

    public static boolean isVarConditionMatch(String[] stringArray, Map map) {
        String string;
        boolean bl = true;
        if (map == null) {
            return true;
        }
        if (stringArray[0] != null) {
            string = (String)map.get(stringArray[0]);
            bl &= string == null || string.length() == 0;
        }
        if (stringArray[1] != null) {
            string = (String)map.get(stringArray[1]);
            bl &= string != null && string.length() > 0;
        }
        return bl;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabelMnemonic(String string) {
        this.labelMnemonic = string != null && string.length() > 0 ? new Character(string.charAt(0)) : null;
    }

    public Character getLabelMnemonic() {
        return this.labelMnemonic;
    }

    public void setA11yName(String string) {
        this.a11yName = string;
    }

    public String getA11yName() {
        return this.a11yName;
    }

    public void setA11yDescription(String string) {
        this.a11yDescription = string;
    }

    public String getA11yDescription() {
        return this.a11yDescription;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValueSelected(String string) {
        this.valueSelected = string;
    }

    public String getValueSelected() {
        return this.valueSelected;
    }

    public void setValueUnselected(String string) {
        this.valueUnselected = string;
    }

    public String getValueUnselected() {
        return this.valueUnselected;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    private boolean canResetDefaultValue() {
        String string = this.getDefaultValue();
        if (string == null) {
            return true;
        }
        int n = string.indexOf("${");
        if (n >= 0 && (n == 0 || string.charAt(n - 1) != '\\')) {
            return false;
        }
        return !this.needsPreCommandPerform();
    }

    public boolean needsPreCommandPerform() {
        String string = this.getDefaultValue();
        return string != null && (string.indexOf("{INSERT_OUTPUT_OF_") >= 0 || string.indexOf("{INSERT_ERROR_OF_") >= 0 || string.indexOf("{FILE_OUTPUT_OF_") >= 0);
    }

    public void setValuesAsDefault() {
        if (this.canResetDefaultValue()) {
            this.setDefaultValue(this.getValue());
        }
        VariableInputComponent[] variableInputComponentArray = this.subComponents();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputComponentArray[n].setValuesAsDefault();
            ++n;
        }
    }

    public void setDefaultValues() {
        if (this.canResetDefaultValue()) {
            this.setValue(this.getDefaultValue());
        }
        VariableInputComponent[] variableInputComponentArray = this.subComponents();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputComponentArray[n].setDefaultValues();
            ++n;
        }
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void addEnable(String string) {
        if (this.enable == null) {
            this.enable = new HashSet();
        }
        this.enable.add(string);
    }

    public Set getEnable() {
        if (this.enable != null) {
            return Collections.unmodifiableSet(this.enable);
        }
        return Collections.EMPTY_SET;
    }

    public Set getDisable() {
        if (this.disable != null) {
            return Collections.unmodifiableSet(this.disable);
        }
        return Collections.EMPTY_SET;
    }

    public void addDisable(String string) {
        if (this.disable == null) {
            this.disable = new HashSet();
        }
        this.disable.add(string);
    }

    public void setSelector(String string) {
        this.selector = string;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelectorVarConditions(String[] stringArray) {
        this.selectorVarConditions = stringArray;
    }

    public String[] getSelectorVarConditions() {
        return this.selectorVarConditions;
    }

    public void setValidator(String string) {
        this.validator = string;
    }

    public String getValidator() {
        return this.validator;
    }

    public VariableInputValidator validate() {
        return new VariableInputValidator(this, this.validator);
    }

    void addValuesToHistory() {
        this.history.add(this.value);
        VariableInputComponent[] variableInputComponentArray = this.subComponents();
        int n = 0;
        while (n < variableInputComponentArray.length) {
            variableInputComponentArray[n].addValuesToHistory();
            ++n;
        }
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public String getHistoryValue(int n) {
        if (n < this.history.size()) {
            return (String)this.history.get(n);
        }
        return this.value;
    }

    public void addSubComponent(VariableInputComponent variableInputComponent) {
        if (this.subComponents == null) {
            this.subComponents = new ArrayList();
        }
        this.subComponents.add(variableInputComponent);
    }

    public VariableInputComponent[] subComponents() {
        if (this.subComponents == null) {
            return new VariableInputComponent[0];
        }
        return this.subComponents.toArray(new VariableInputComponent[0]);
    }
}

