/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.netbeans.modules.vcscore.util.VcsUtilities;

public class VariableValueAdjustment
implements Serializable {
    private static final String VAR_ADJUST_CHARS = "ADJUST_CHARS";
    private static final String VAR_ADJUST_VARS = "ADJUST_VARS";
    private char adjustingChar;
    private HashSet adjustedChars = null;
    private HashSet adjustedVars = null;
    private String quoting = null;
    static final long serialVersionUID = 2773459026157834845L;

    public synchronized void setAdjust(Hashtable hashtable) {
        String string = (String)hashtable.get(VAR_ADJUST_CHARS);
        if (string == null) {
            return;
        }
        this.adjustingChar = string.charAt(0);
        this.adjustedChars = new HashSet();
        int n = 1;
        while (n < string.length()) {
            this.adjustedChars.add(new Character(string.charAt(n)));
            ++n;
        }
        String string2 = (String)hashtable.get(VAR_ADJUST_VARS);
        if (string2 == null) {
            return;
        }
        String[] stringArray = VcsUtilities.getQuotedStrings(string2);
        this.adjustedVars = new HashSet<String>(Arrays.asList(stringArray));
        this.quoting = (String)hashtable.get("QUOTE");
    }

    public void adjustVarValues(Hashtable hashtable) {
        if (this.adjustedVars == null) {
            return;
        }
        Iterator iterator = this.adjustedVars.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashtable.get(string);
            if (string2 == null) continue;
            hashtable.put(string, this.adjustVarValue(string2));
        }
    }

    public String adjustVarValue(String string) {
        string = this.adjustCharsInValue(string);
        if (this.quoting != null && string != null) {
            int n = 0;
            String string2 = null;
            while ((n = string.indexOf(this.quoting, n)) >= 0) {
                if (string2 == null) {
                    string2 = this.adjustCharsInValue(this.quoting);
                }
                string = string.substring(0, n) + string2 + string.substring(n + this.quoting.length());
                n += string2.length();
            }
        }
        return string;
    }

    private String adjustCharsInValue(String string) {
        if (this.adjustedChars == null) {
            return string;
        }
        if (string == null) {
            return string;
        }
        int n = 0;
        while (n < string.length()) {
            Character c = new Character(string.charAt(n));
            if (this.adjustedChars.contains(c)) {
                string = string.substring(0, n) + this.adjustingChar + string.substring(n);
                ++n;
            }
            ++n;
        }
        return string;
    }

    public String revertAdjustedVarValue(String string) {
        string = this.revertAdjustedCharsInValue(string);
        if (this.quoting != null && string != null) {
            int n = 0;
            String string2 = null;
            while ((n = string.indexOf(this.quoting, n)) >= 0) {
                if (string2 == null) {
                    string2 = this.revertAdjustedCharsInValue(this.quoting);
                }
                string = string.substring(0, n) + string2 + string.substring(n + this.quoting.length());
                n += string2.length();
            }
        }
        return string;
    }

    private String revertAdjustedCharsInValue(String string) {
        if (this.adjustedChars == null) {
            return string;
        }
        if (string == null) {
            return string;
        }
        int n = string.indexOf(this.adjustingChar);
        while (n >= 0 && n < string.length() - 1) {
            if (this.adjustedChars.contains(new Character(string.charAt(n + 1)))) {
                string = string.substring(0, n) + string.substring(n + 1);
            }
            n = string.indexOf(this.adjustingChar, n + 1);
        }
        return string;
    }
}

