/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util.virtuals;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashSet;
import org.netbeans.modules.vcscore.util.virtuals.VirtualsRefreshing;
import org.openide.TopManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public final class VcsRefreshRequest
implements Runnable {
    private static final int REFRESH_COUNT = 30;
    private Reference system;
    private Reference refresher;
    private Enumeration en;
    private int refreshTime;
    private RequestProcessor.Task task;
    private HashSet preffered;
    private boolean interrupt;

    public VcsRefreshRequest(AbstractFileSystem abstractFileSystem, int n, VirtualsRefreshing virtualsRefreshing) {
        this.system = new WeakReference<AbstractFileSystem>(abstractFileSystem);
        this.refresher = new WeakReference<VirtualsRefreshing>(virtualsRefreshing);
        this.refreshTime = n;
        int n2 = (int)Math.round(Math.random() * 15000.0) + 15000;
        this.task = RequestProcessor.postRequest((Runnable)this, (int)n2, (int)1);
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public synchronized void stop() {
        this.refreshTime = 0;
        if (this.task == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void addPrefferedFolder(String string) {
        VcsRefreshRequest vcsRefreshRequest = this;
        synchronized (vcsRefreshRequest) {
            if (this.preffered == null) {
                this.preffered = new HashSet();
            }
            this.preffered.add(string);
            if (this.task != null) {
                if (this.task.getDelay() > 1000 || this.task.getDelay() < 600) {
                    this.task.schedule(1000);
                }
            } else {
                this.interrupt = true;
            }
        }
    }

    synchronized boolean hasPrefferedFolder() {
        return this.preffered != null && this.preffered.size() != 0;
    }

    private boolean shouldBeInterrupted() {
        return this.interrupt;
    }

    FileObject getPrefferedFolder() {
        boolean bl = false;
        FileObject fileObject = null;
        while (!bl) {
            String string;
            AbstractFileSystem abstractFileSystem;
            bl = true;
            VcsRefreshRequest vcsRefreshRequest = this;
            synchronized (vcsRefreshRequest) {
                if (this.preffered == null || this.preffered.size() == 0) {
                    abstractFileSystem = null;
                    return abstractFileSystem;
                }
                string = (String)this.preffered.iterator().next();
                this.preffered.remove(string);
            }
            if (string == null) {
                return null;
            }
            abstractFileSystem = (AbstractFileSystem)this.system.get();
            if (abstractFileSystem == null) {
                return null;
            }
            fileObject = abstractFileSystem.findResource(string);
            if (fileObject != null) continue;
            bl = false;
        }
        return fileObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        VcsRefreshRequest vcsRefreshRequest2;
        RequestProcessor.Task task;
        int n;
        VcsRefreshRequest vcsRefreshRequest = this;
        synchronized (vcsRefreshRequest) {
            n = this.refreshTime;
            if (n <= 0) {
                return;
            }
            task = this.task;
            this.interrupt = false;
        }
        try {
            this.task = null;
            this.doLoop(n);
            Object var6_5 = null;
            vcsRefreshRequest2 = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            VcsRefreshRequest vcsRefreshRequest3 = this;
            synchronized (vcsRefreshRequest3) {
                this.task = task;
                this.interrupt = false;
                this.notifyAll();
            }
            if (this.hasPrefferedFolder()) {
                task.schedule(1000);
                throw throwable;
            } else {
                task.schedule(n);
            }
            throw throwable;
        }
        synchronized (vcsRefreshRequest2) {
            this.task = task;
            this.interrupt = false;
            this.notifyAll();
        }
        if (this.hasPrefferedFolder()) {
            task.schedule(1000);
            return;
        }
        task.schedule(n);
    }

    private void doLoop(int n) {
        AbstractFileSystem abstractFileSystem = (AbstractFileSystem)this.system.get();
        if (abstractFileSystem == null) {
            return;
        }
        VirtualsRefreshing virtualsRefreshing = (VirtualsRefreshing)this.refresher.get();
        if (virtualsRefreshing == null) {
            TopManager.getDefault().getErrorManager().log(16, "VcsRefreshRequest: Missing refresher. Please file a bug against vcscore module");
            return;
        }
        if (this.en == null || !this.en.hasMoreElements()) {
            this.en = VcsRefreshRequest.existingFolders(virtualsRefreshing);
        }
        FileObject fileObject = this.getPrefferedFolder();
        while (fileObject != null) {
            virtualsRefreshing.doVirtualsRefresh(fileObject);
            if (this.shouldBeInterrupted()) {
                return;
            }
            fileObject = this.getPrefferedFolder();
        }
        int n2 = 0;
        while (n2 < 30 && this.en.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)this.en.nextElement();
            if (fileObject2 != null) {
                virtualsRefreshing.doVirtualsRefresh(fileObject2);
            }
            if (this.refreshTime <= 0 || this.shouldBeInterrupted()) {
                return;
            }
            ++n2;
        }
        if (!this.en.hasMoreElements()) {
            this.en = null;
        }
    }

    private static Enumeration existingFolders(VirtualsRefreshing virtualsRefreshing) {
        return virtualsRefreshing.getExistingFolders();
    }
}

