/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vcscore.versioning.RevisionChildren;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public abstract class RevisionList
extends TreeSet
implements Node.Cookie {
    private transient FileObject fo = null;
    private transient Vector listeners = new Vector();
    private transient WeakHashMap nodeDelegates = new WeakHashMap();
    static final long serialVersionUID = -8578787400541124223L;

    public void setFileObject(FileObject fileObject) {
        this.fo = fileObject;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public boolean add(Object object) {
        boolean bl = super.add(object);
        this.fireChanged();
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = super.addAll(collection);
        this.fireChanged();
        return bl;
    }

    public void clear() {
        super.clear();
        this.fireChanged();
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.nodeDelegates.remove(object);
        this.fireChanged();
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = super.removeAll(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.nodeDelegates.remove(iterator.next());
        }
        this.fireChanged();
        return bl;
    }

    public boolean removeRevision(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RevisionItem revisionItem = (RevisionItem)iterator.next();
            String string2 = revisionItem.getRevision();
            if (!string2.equals(string)) continue;
            this.remove(revisionItem);
            return true;
        }
        return false;
    }

    public void fireChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public abstract boolean containsSubRevisions(String var1);

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public boolean removeChangeListener(ChangeListener changeListener) {
        return this.listeners.remove(changeListener);
    }

    public Node getNodeDelegate(RevisionItem revisionItem, RevisionChildren revisionChildren) {
        Node node = (Node)this.nodeDelegates.get(revisionItem);
        if (node == null) {
            node = this.createNodeDelegate(revisionItem, revisionChildren);
            this.nodeDelegates.put(revisionItem, node);
        }
        return node;
    }

    protected Node createNodeDelegate(RevisionItem revisionItem, RevisionChildren revisionChildren) {
        RevisionNode revisionNode;
        if (revisionChildren == null || Children.LEAF.equals(revisionChildren)) {
            revisionNode = new RevisionNode(this, revisionItem);
        } else {
            revisionNode = new RevisionNode(revisionChildren);
            revisionNode.setItem(revisionItem);
        }
        revisionNode.setDisplayName(revisionItem.getDisplayName());
        return revisionNode;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, NotActiveException {
        objectInputStream.defaultReadObject();
        this.listeners = new Vector();
        this.nodeDelegates = new WeakHashMap();
    }
}

