/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning.impl;

import java.util.EventListener;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusListener;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.impl.VersioningDataNode;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class VersioningDataObject
extends MultiDataObject {
    public static final String PROP_STATUS = "status";
    public static final String PROP_LOCKER = "locker";
    public static final String PROP_REVISION = "revision";
    public static final String PROP_STICKY = "sticky";
    public static final String PROP_ALL_STATES = "all";
    private String status = null;
    private String locker = null;
    private String revision = null;
    private String sticky = null;
    private EditorCookie editor;
    private VCSFileStatusListener vcsFileStatusListener;
    private static final long serialVersionUID = 5622788615406683488L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener;

    public VersioningDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.initListeners();
    }

    private void initListeners() {
        VersioningFileSystem versioningFileSystem;
        try {
            versioningFileSystem = (VersioningFileSystem)this.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return;
        }
        this.vcsFileStatusListener = new VCSFileStatusListener();
        versioningFileSystem.addVcsFileStatusListener((VcsFileStatusListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener == null ? (class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener = VersioningDataObject.class$("org.netbeans.modules.vcscore.versioning.VcsFileStatusListener")) : class$org$netbeans$modules$vcscore$versioning$VcsFileStatusListener), (EventListener)this.vcsFileStatusListener, (Object)versioningFileSystem));
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    protected Node createNodeDelegate() {
        VersioningDataNode versioningDataNode = new VersioningDataNode(this);
        return versioningDataNode;
    }

    public RevisionList getRevisionList(boolean bl) {
        VersioningFileSystem versioningFileSystem;
        try {
            versioningFileSystem = (VersioningFileSystem)this.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
        return versioningFileSystem.getVersions().getRevisions(this.getPrimaryFile().getPackageNameExt('/', '.'), bl);
    }

    private FileStatusProvider getFileStatusProvider() {
        VersioningFileSystem versioningFileSystem;
        try {
            versioningFileSystem = (VersioningFileSystem)this.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
        return versioningFileSystem.getFileStatusProvider();
    }

    public String getStatus() {
        if (this.status == null) {
            FileStatusProvider fileStatusProvider = this.getFileStatusProvider();
            if (fileStatusProvider == null) {
                return null;
            }
            this.status = fileStatusProvider.getFileStatus(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.status;
    }

    public String getLocker() {
        if (this.locker == null) {
            FileStatusProvider fileStatusProvider = this.getFileStatusProvider();
            if (fileStatusProvider == null) {
                return null;
            }
            this.locker = fileStatusProvider.getFileLocker(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.locker;
    }

    public String getRevision() {
        if (this.revision == null) {
            FileStatusProvider fileStatusProvider = this.getFileStatusProvider();
            if (fileStatusProvider == null) {
                return null;
            }
            this.revision = fileStatusProvider.getFileRevision(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.revision;
    }

    public String getSticky() {
        if (this.sticky == null) {
            FileStatusProvider fileStatusProvider = this.getFileStatusProvider();
            if (fileStatusProvider == null) {
                return null;
            }
            this.sticky = fileStatusProvider.getFileSticky(this.getPrimaryFile().getPackageNameExt('/', '.'));
        }
        return this.sticky;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class VCSFileStatusListener
    implements VcsFileStatusListener {
        private VCSFileStatusListener() {
        }

        public void vcsStatusChanged(VcsFileStatusEvent vcsFileStatusEvent) {
            if (vcsFileStatusEvent.hasChanged(VersioningDataObject.this.getPrimaryFile())) {
                String string;
                FileStatusProvider fileStatusProvider = VersioningDataObject.this.getFileStatusProvider();
                if (fileStatusProvider == null) {
                    return;
                }
                String string2 = VersioningDataObject.this.getPrimaryFile().getPackageNameExt('/', '.');
                String string3 = fileStatusProvider.getFileStatus(string2);
                if (VersioningDataObject.this.status == null && string3 != null || VersioningDataObject.this.status != null && !VersioningDataObject.this.status.equals(string3)) {
                    string = VersioningDataObject.this.status;
                    VersioningDataObject.this.status = string3;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_STATUS, string, string3);
                }
                string3 = fileStatusProvider.getFileLocker(string2);
                if (VersioningDataObject.this.locker == null && string3 != null || VersioningDataObject.this.locker != null && !VersioningDataObject.this.locker.equals(string3)) {
                    string = VersioningDataObject.this.locker;
                    VersioningDataObject.this.locker = string3;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_LOCKER, string, string3);
                }
                string3 = fileStatusProvider.getFileRevision(string2);
                if (VersioningDataObject.this.revision == null && string3 != null || VersioningDataObject.this.revision != null && !VersioningDataObject.this.revision.equals(string3)) {
                    string = VersioningDataObject.this.revision;
                    VersioningDataObject.this.revision = string3;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_REVISION, string, string3);
                }
                string3 = fileStatusProvider.getFileSticky(string2);
                if (VersioningDataObject.this.sticky == null && string3 != null || VersioningDataObject.this.sticky != null && !VersioningDataObject.this.sticky.equals(string3)) {
                    string = VersioningDataObject.this.sticky;
                    VersioningDataObject.this.sticky = string3;
                    VersioningDataObject.super.firePropertyChange(VersioningDataObject.PROP_STICKY, string, string3);
                }
            }
        }
    }
}

