/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryEvent;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener;
import org.netbeans.modules.vcscore.versioning.impl.RootFolderNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

final class VersioningDataSystem
extends AbstractNode
implements VersioningRepositoryListener {
    private static VersioningDataSystem def;
    private VersioningRepository repository;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction;

    private VersioningDataSystem(Children children, VersioningRepository versioningRepository) {
        super(children);
        this.repository = versioningRepository;
        this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem = VersioningDataSystem.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataSystem")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem), (String)"versioningSystemName"));
        this.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem == null ? (class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem = VersioningDataSystem.class$("org.netbeans.modules.vcscore.versioning.impl.VersioningDataSystem")) : class$org$netbeans$modules$vcscore$versioning$impl$VersioningDataSystem), (String)"VersioningDataSystem.Description"));
        this.setIconBase("org/netbeans/modules/vcscore/versioning/impl/versioningExplorer");
        this.initialize();
    }

    public static synchronized VersioningDataSystem getVersioningDataSystem() {
        if (def == null) {
            def = new VersioningDataSystem((Children)new DataChildren(), VersioningRepository.getRepository());
        }
        return def;
    }

    private void initialize() {
        this.repository.addRepositoryListener(this);
        List list = this.repository.getVersioningFileSystems();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VersioningFileSystem versioningFileSystem = (VersioningFileSystem)iterator.next();
            versioningFileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DataChildren)this.getChildren()), (Object)versioningFileSystem));
        }
        this.refresh();
    }

    private static Node createRoot(VersioningFileSystem versioningFileSystem) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)versioningFileSystem.getRoot());
        return new RootFolderNode(dataFolder, dataFolder.createNodeChildren(DataFilter.ALL));
    }

    public void versioningSystemAdded(VersioningRepositoryEvent versioningRepositoryEvent) {
        versioningRepositoryEvent.getVersioningFileSystem().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DataChildren)this.getChildren()), (Object)versioningRepositoryEvent.getVersioningFileSystem()));
        this.refresh();
    }

    public void versioningSystemRemoved(VersioningRepositoryEvent versioningRepositoryEvent) {
        this.refresh();
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction = VersioningDataSystem.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction))};
    }

    private void refresh() {
        this.refresh(null);
    }

    private void refresh(VersioningFileSystem versioningFileSystem) {
        ((DataChildren)this.getChildren()).refresh(this.repository, versioningFileSystem);
    }

    public Node.Handle getHandle() {
        return new DataSystemHandler();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DataChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private DataChildren() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VersioningDataSystem versioningDataSystem = (VersioningDataSystem)this.getNode();
            if (versioningDataSystem == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("root")) {
                VersioningFileSystem versioningFileSystem = (VersioningFileSystem)propertyChangeEvent.getSource();
                versioningDataSystem.refresh(versioningFileSystem);
                versioningDataSystem.refresh();
            }
        }

        protected Node[] createNodes(Object object) {
            Node node = VersioningDataSystem.createRoot((VersioningFileSystem)object);
            return new Node[]{node};
        }

        public void refresh(VersioningRepository versioningRepository, VersioningFileSystem versioningFileSystem) {
            List list = versioningRepository.getVersioningFileSystems();
            list.remove(versioningFileSystem);
            this.setKeys(list);
        }
    }

    private static class DataSystemHandler
    implements Node.Handle {
        static final long serialVersionUID = -360330468336250300L;

        DataSystemHandler() {
        }

        public Node getNode() {
            return VersioningDataSystem.getVersioningDataSystem();
        }
    }
}

