/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.wizard.mountcvs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vcscore.settings.GeneralVcsSettings;
import org.netbeans.modules.vcscore.wizard.mountcvs.AbstractWizardPanel;
import org.netbeans.modules.vcscore.wizard.mountcvs.CvsWizardData;
import org.netbeans.modules.vcscore.wizard.mountcvs.util.SimpleComboBoxEditor;
import org.netbeans.modules.vcscore.wizard.mountcvs.util.Utilities;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class WDPanel
extends AbstractWizardPanel
implements DocumentListener {
    private LinkedList previousItems;
    private CvsWizardData data;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JTextArea descriptionTextArea;
    private JComboBox jComboBox1;
    private JLabel wdLabel;
    private JButton wdButton;
    private static final long serialVersionUID = 4155272251443011619L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel;

    public WDPanel() {
        Object object;
        this.initComponents();
        GeneralVcsSettings generalVcsSettings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = WDPanel.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        this.previousItems = new LinkedList();
        Iterator iterator = generalVcsSettings.getWizardDirectoryCache().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().toString();
            this.previousItems.add(object);
        }
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.CMPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$CMPanel)).getString("WDPanel.title"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        this.putClientProperty("WizardPanel_autoWizardStyle", new Boolean(true));
        this.putClientProperty("WizardPanel_contentDisplayed", new Boolean(true));
        this.putClientProperty("WizardPanel_contentNumbered", new Boolean(true));
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.setPreferredSize(new Dimension(500, 350));
        object = new SimpleComboBoxEditor();
        ((SimpleComboBoxEditor)object).addDocumentListener(this);
        this.jComboBox1.setEditor((ComboBoxEditor)object);
        this.initAccessibility();
    }

    protected void storeCvsWizardSettings(CvsWizardData cvsWizardData) {
        String string = (String)this.jComboBox1.getEditor().getItem();
        if (org.openide.util.Utilities.isWindows() && string.length() == 2 && Character.isLetter(string.charAt(0)) && ':' == string.charAt(1)) {
            string = string + "\\";
        }
        cvsWizardData.setWorkingDir(string);
        this.previousItems.addFirst(string);
        int n = 1;
        while (n < Math.min(4, this.previousItems.size())) {
            if (this.previousItems.get(n).equals(string)) {
                this.previousItems.remove(n);
            }
            ++n;
        }
        while (this.previousItems.size() > 4) {
            this.previousItems.removeLast();
        }
        cvsWizardData.setRootFile(WDPanel.getCvsRootFile(new File(string)));
    }

    protected void readCvsWizardSettings(CvsWizardData cvsWizardData) {
        this.jComboBox1.removeAllItems();
        int n = 0;
        while (n < this.previousItems.size()) {
            this.jComboBox1.addItem(this.previousItems.get(n));
            ++n;
        }
        String string = cvsWizardData.getWorkingDir();
        if (string != null) {
            this.jComboBox1.setSelectedItem(string);
        }
        this.data = cvsWizardData;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.wdLabel = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.wdButton = new JButton();
        this.jPanel2 = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.wdLabel.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("WDPanel.wdLabel"));
        this.wdLabel.setLabelFor(this.jComboBox1);
        this.wdLabel.setNextFocusableComponent(this.wdButton);
        this.wdLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("WDPanel.wdLabel_Mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.wdLabel, gridBagConstraints);
        this.jComboBox1.setEditable(true);
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WDPanel.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel1.add((Component)this.jComboBox1, gridBagConstraints);
        this.wdButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("WDPanel.wdBrowse_Mnemonic").charAt(0));
        this.wdButton.setText(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("WDPanel.wdBrowse"));
        this.wdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WDPanel.this.browseDir(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.wdButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.descriptionTextArea.setBackground(Color.lightGray);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("TIP_WorkingDirectoryPanel"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setDisabledTextColor(Color.black);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanel2.add((Component)this.descriptionTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        this.fireChange();
    }

    private void browseDir(ActionEvent actionEvent) {
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){
            static /* synthetic */ Class class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel;

            public boolean accept(File file) {
                return file.exists() && file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = 3.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel)).getString("TXT_Directory");
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        jFileChooser.setFileSelectionMode(1);
        Object object2 = Utilities.findDirectory((String)this.jComboBox1.getEditor().getItem());
        if (object2 != null) {
            jFileChooser.setCurrentDirectory((File)object2);
        } else {
            try {
                object = new File(System.getProperty("user.home"));
                if (org.openide.util.Utilities.isUnix()) {
                    object2 = object;
                } else if (org.openide.util.Utilities.isWindows()) {
                    while ((object = ((File)object).getParentFile()) != null && ((File)object).getParentFile() != null) {
                    }
                    if (object != null) {
                        object2 = object;
                    }
                }
            }
            catch (Exception exception) {
                object2 = null;
            }
        }
        if (object2 != null) {
            jFileChooser.setCurrentDirectory((File)object2);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            object = jFileChooser.getSelectedFile().getAbsolutePath();
            this.jComboBox1.getEditor().setItem(object);
            this.fireChange();
        }
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel == null ? (class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel = WDPanel.class$("org.netbeans.modules.vcscore.wizard.mountcvs.WDPanel")) : class$org$netbeans$modules$vcscore$wizard$mountcvs$WDPanel);
    }

    public boolean isValid() {
        String string = (String)this.jComboBox1.getEditor().getItem();
        if (string == null || string.length() == 0) {
            return false;
        }
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    public File getCvsRootFile() {
        return WDPanel.getCvsRootFile(new File((String)this.jComboBox1.getEditor().getItem()));
    }

    public static File getCvsRootFile(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = WDPanel.getCvsRootFileIn(file);
        if (file2 != null) {
            return file2;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                file2 = WDPanel.getCvsRootFileIn(fileArray[n]);
                if (file2 != null) {
                    return file2;
                }
                ++n;
            }
        }
        return null;
    }

    private static File getCvsRootFileIn(File file) {
        File file2;
        File file3 = new File(file, "CVS");
        if (file3.exists() && file3.isDirectory() && (file2 = new File(file3, "Root")).exists() && file2.canRead()) {
            return file2;
        }
        return null;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("ACSD_WDPanel.title"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(this.descriptionTextArea.getText());
        this.wdButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/vcscore/wizard/mountcvs/Bundle").getString("ACSD_WDPanel.wdBrowse"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

