/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.wizard.mountcvs.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class CvsHelper {
    public static final String LOCAL = "local";
    public static final String SERVER = "server";
    public static final String PSERVER = "pserver";
    public static final String EXTERNAL = "ext";
    public static final int T_UNKNOWN = 0;
    public static final int T_LOCAL = 1;
    public static final int T_SERVER = 2;
    public static final int T_PSERVER = 3;
    public static final int T_EXTERNAL = 4;
    private String cvsRoot_;
    private String serverName_;
    private String serverPort_;
    private String userName_;
    private String repository_;
    private String method_;
    private boolean modified_;
    private ArrayList listeners_;

    public CvsHelper(String string) {
        this.cvsRoot_ = string;
        this.modified_ = false;
        this.listeners_ = new ArrayList();
        this.method_ = "";
        this.repository_ = "";
        this.userName_ = "";
        this.serverPort_ = "";
        this.serverName_ = "";
        if (this.cvsRoot_ != null) {
            try {
                this.parseCvsRoot();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.cvsRoot_ = "";
            }
        } else {
            this.cvsRoot_ = "";
        }
    }

    public CvsHelper() {
        this(null);
    }

    public String getCvsRoot() {
        if (this.modified_) {
            this.buildCvsRoot();
        }
        return this.cvsRoot_;
    }

    public boolean wasModified() {
        return this.modified_;
    }

    public String getMethod() {
        return this.method_;
    }

    public int getMethodType() {
        if (this.method_.equals(LOCAL)) {
            return 1;
        }
        if (this.method_.equals(SERVER)) {
            return 2;
        }
        if (this.method_.equals(PSERVER)) {
            return 3;
        }
        if (this.method_.equals(EXTERNAL)) {
            return 4;
        }
        return 0;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getServerPort() {
        return this.serverPort_;
    }

    public String getUserName() {
        return this.userName_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void setCvsRoot(String string) {
        String string2 = this.cvsRoot_;
        this.repository_ = "";
        this.method_ = "";
        this.serverName_ = "";
        this.userName_ = "";
        this.cvsRoot_ = string;
        if (string != null) {
            try {
                this.parseCvsRoot();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.cvsRoot_ = "";
            }
        } else {
            this.cvsRoot_ = "";
        }
        this.modified_ = false;
        this.fireChange("cvsRoot", string2, this.cvsRoot_);
    }

    public void setMethod(String string) {
        String string2 = this.method_;
        this.method_ = string;
        this.modified_ = true;
        this.fireChange("method", string2, this.method_);
    }

    public void setUserName(String string) {
        String string2 = this.userName_;
        this.userName_ = string;
        this.modified_ = true;
        this.fireChange("userName", string2, this.userName_);
    }

    public void setServerName(String string) {
        String string2 = this.serverName_;
        this.serverName_ = string;
        this.modified_ = true;
        this.fireChange("serverName", string2, this.serverName_);
    }

    public void setServerPort(String string) {
        String string2 = this.serverPort_;
        this.serverPort_ = string;
        this.modified_ = true;
        this.fireChange("serverPort", string2, this.serverPort_);
    }

    public void setRepository(String string) {
        String string2 = this.repository_;
        this.repository_ = string;
        this.modified_ = true;
        this.fireChange("repository", string2, this.repository_);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners_.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ((AbstractCollection)this.listeners_).remove(propertyChangeListener);
    }

    private void buildCvsRoot() {
        String string = ":" + this.method_ + ":";
        if (!this.method_.equals(LOCAL)) {
            if (this.userName_.length() > 0) {
                string = string + this.userName_ + "@";
            }
            if (this.serverName_.length() > 0) {
                string = string + this.serverName_;
            }
            string = string + ":";
        }
        this.cvsRoot_ = string + this.serverPort_ + this.repository_;
    }

    private void parseCvsRoot() throws IllegalArgumentException {
        StringTokenizer stringTokenizer;
        this.cvsRoot_ = this.cvsRoot_.trim();
        if (this.cvsRoot_.charAt(0) != ':') {
            this.cvsRoot_ = ":local:" + this.cvsRoot_;
        }
        if ((stringTokenizer = new StringTokenizer(this.cvsRoot_, ":", true)).countTokens() < 4) {
            this.cvsRoot_ = "";
            throw new IllegalArgumentException();
        }
        stringTokenizer.nextToken();
        this.method_ = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        if (this.method_.equals(LOCAL)) {
            this.repository_ = this.restTokens(stringTokenizer);
        } else {
            char c;
            Object object;
            if (stringTokenizer.countTokens() < 2) {
                this.method_ = "";
                this.cvsRoot_ = "";
                throw new IllegalArgumentException();
            }
            String string = stringTokenizer.nextToken();
            if (!string.equals(":")) {
                object = new StringTokenizer(string, "@");
                if (((StringTokenizer)object).countTokens() == 2) {
                    this.userName_ = ((StringTokenizer)object).nextToken();
                    this.serverName_ = ((StringTokenizer)object).nextToken();
                    stringTokenizer.nextToken();
                } else if (((StringTokenizer)object).countTokens() == 1) {
                    this.userName_ = "";
                    this.serverName_ = ((StringTokenizer)object).nextToken();
                    stringTokenizer.nextToken();
                } else {
                    this.method_ = "";
                    this.cvsRoot_ = "";
                    throw new IllegalArgumentException();
                }
            }
            this.repository_ = this.restTokens(stringTokenizer);
            object = new StringBuffer();
            int n = 0;
            while (this.repository_.length() > n && Character.isDigit(c = this.repository_.charAt(n))) {
                ((StringBuffer)object).append(c);
                ++n;
            }
            if (((StringBuffer)object).length() > 0) {
                this.serverPort_ = ((StringBuffer)object).toString();
                this.repository_ = this.repository_.substring(((StringBuffer)object).length());
            } else {
                this.serverPort_ = "";
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fireChange(String string, Object object, Object object2) {
        Iterator iterator;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        CvsHelper cvsHelper = this;
        synchronized (cvsHelper) {
            iterator = ((AbstractList)((ArrayList)this.listeners_.clone())).iterator();
        }
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
        }
    }

    private String restTokens(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = string + stringTokenizer.nextToken();
        }
        return string;
    }
}

