/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;

class RepositoryCP
extends ClassPath {
    FileSystemCapability filterCap;
    Collection roots;
    List entries;
    Map capMap;

    public RepositoryCP(FileSystemCapability fileSystemCapability) {
        this.filterCap = fileSystemCapability;
    }

    public List entries() {
        List list = this.entries;
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            if (list != null) {
                List list2 = this.entries;
                return list2;
            }
            Enumeration enumeration = this.filterCap.fileSystems();
            LinkedList<CPEntry> linkedList = new LinkedList<CPEntry>();
            this.capMap = new HashMap(5);
            while (enumeration.hasMoreElements()) {
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                CPEntry cPEntry = new CPEntry(fileSystem);
                this.capMap.put(fileSystem.getCapability(), cPEntry);
                linkedList.add(cPEntry);
            }
            this.entries = Collections.unmodifiableList(linkedList);
        }
        return this.entries;
    }

    void resetEntries() {
        this.roots = null;
        this.entries = null;
    }

    public final synchronized FileObject[] getRoots() {
        ArrayList<FileObject> arrayList = this.roots;
        if (arrayList == null) {
            List list = this.entries();
            arrayList = new ArrayList<FileObject>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                FileObject fileObject = entry.getRoot();
                if (fileObject == null) continue;
                arrayList.add(fileObject);
            }
            this.roots = arrayList;
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    boolean accept(FileSystem fileSystem) {
        return fileSystem.getCapability().capableOf(this.filterCap);
    }

    public synchronized void resetRoots() {
        this.entries = null;
        this.roots = null;
    }

    void capsChanged(FileSystem fileSystem) {
        boolean bl;
        FileObject fileObject = null;
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            CPEntry cPEntry = this.find(fileSystem);
            bl = fileSystem.getCapability().capableOf(this.filterCap);
            if (cPEntry != null == bl) {
                return;
            }
            if (bl) {
                CPEntry cPEntry2 = null;
                List<FileSystem> list = Arrays.asList(Repository.getDefault().toArray());
                ListIterator<FileSystem> listIterator = list.listIterator(list.indexOf(fileSystem));
                while (fileObject != null && listIterator.hasPrevious()) {
                    FileSystem fileSystem2 = listIterator.previous();
                    cPEntry2 = this.find(fileSystem2);
                    if (cPEntry2 == null) continue;
                    fileObject = cPEntry2.getRoot();
                }
                list = new ArrayList<FileSystem>(this.entries);
                if (fileObject == null) {
                    list.add(0, (FileSystem)new CPEntry(fileSystem));
                } else {
                    list.add(list.indexOf(cPEntry2), (FileSystem)new CPEntry(fileSystem));
                }
            }
        }
        if (!bl) {
            this.fileSystemRemoved(fileSystem);
        }
    }

    CPEntry find(FileSystem fileSystem) {
        if (this.capMap == null) {
            return null;
        }
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            CPEntry cPEntry = (CPEntry)this.capMap.get(fileSystem.getCapability());
            return cPEntry;
        }
    }

    void fileSystemsReordered(int[] nArray) {
        FileSystem[] fileSystemArray = Repository.getDefault().toArray();
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            List list = this.entries;
            if (list != null) {
                ArrayList<CPEntry> arrayList = new ArrayList<CPEntry>(list.size());
                nArray = new int[list.size()];
                boolean bl = false;
                int n = 0;
                while (n < fileSystemArray.length) {
                    FileSystem fileSystem = fileSystemArray[n];
                    if (this.accept(fileSystem)) {
                        CPEntry cPEntry = (CPEntry)this.capMap.get(fileSystem.getCapability());
                        int n2 = list.indexOf(cPEntry);
                        if (n2 == -1) {
                            nArray = null;
                            bl = true;
                            break;
                        }
                        nArray[n2] = arrayList.size();
                        bl |= n2 != nArray[n2];
                        arrayList.add(cPEntry);
                    }
                    ++n;
                }
                if (!bl) {
                    return;
                }
                if (nArray != null) {
                    this.changeEntries(arrayList);
                } else {
                    this.entries = null;
                }
            }
        }
        this.firePropertyChange("entries", null, null);
        this.firePropertyChange("roots", null, null);
    }

    private void changeEntries(List list) {
        this.entries = Collections.unmodifiableList(list);
        this.roots = null;
    }

    private void addEntry(CPEntry cPEntry) {
        ArrayList<CPEntry> arrayList = this.entries == null ? new ArrayList<CPEntry>() : new ArrayList(this.entries);
        arrayList.add(cPEntry);
        this.capMap.put(cPEntry.getFileSystem().getCapability(), cPEntry);
        this.changeEntries(arrayList);
    }

    private void removeEntry(CPEntry cPEntry) {
        ArrayList arrayList = new ArrayList(this.entries);
        arrayList.remove(cPEntry);
        this.capMap.remove(cPEntry.getFileSystem().getCapability());
        this.changeEntries(arrayList);
    }

    void fileSystemAdded(FileSystem fileSystem) {
        if (!this.accept(fileSystem)) {
            return;
        }
        boolean bl = this.initializeEntries();
        if (bl) {
            this.addEntry(new CPEntry(fileSystem));
        }
        this.firePropertyChange("entries", null, null);
        if (this.isValid(fileSystem)) {
            this.rootsChanged();
        }
    }

    void rootsChanged() {
        this.roots = null;
        this.firePropertyChange("roots", null, null);
    }

    void fileSystemRemoved(FileSystem fileSystem) {
        boolean bl;
        boolean bl2 = bl = this.entries == null;
        if (!bl) {
            RepositoryCP repositoryCP = this;
            synchronized (repositoryCP) {
                CPEntry cPEntry = null;
                Iterator iterator = this.entries.iterator();
                while (iterator.hasNext()) {
                    cPEntry = (CPEntry)iterator.next();
                    if (cPEntry.getFileSystem() != fileSystem) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.removeEntry(cPEntry);
                }
            }
        }
        if (bl) {
            this.firePropertyChange("entries", null, null);
        }
        if (this.isValid(fileSystem)) {
            this.rootsChanged();
        }
    }

    boolean isValid(FileSystem fileSystem) {
        return fileSystem.getRoot().isValid();
    }

    synchronized boolean initializeEntries() {
        if (this.entries != null) {
            return true;
        }
        FileSystem[] fileSystemArray = RepositoryCP.getRepository().toArray();
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(fileSystemArray.length);
        int n = 0;
        while (n < fileSystemArray.length) {
            FileSystemCapability fileSystemCapability = fileSystemArray[n].getCapability();
            if (fileSystemCapability.capableOf(this.filterCap)) {
                arrayList.add(fileSystemArray[n]);
            }
            ++n;
        }
        this.changeEntries(arrayList);
        return false;
    }

    static Repository getRepository() {
        return Repository.getDefault();
    }

    class CPEntry
    extends ClassPath.Entry {
        FileSystem fs;
        boolean active;

        CPEntry(FileSystem fileSystem) {
            this.fs = fileSystem;
        }

        final FileSystem getFileSystem() {
            return this.fs;
        }

        public ClassPath getDefiningClassPath() {
            return RepositoryCP.this;
        }

        public IOException getError() {
            try {
                URL uRL = this.fs.getRoot().getURL();
                return null;
            }
            catch (IOException iOException) {
                return iOException;
            }
        }

        public FileObject getRoot() {
            if (!this.isValid()) {
                return null;
            }
            return this.fs.getRoot();
        }

        public boolean isValid() {
            return this.fs.getRoot().isValid();
        }
    }
}

