/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FileEntry;
import org.openide.loaders.FilesSet;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class MultiDataObject
extends DataObject {
    static final long serialVersionUID = -7750146802134210308L;
    private static final Object cookieSetLock = new Object();
    private static final RequestProcessor firingProcessor = new RequestProcessor("MDO PropertyChange processor");
    private Entry primary;
    private HashMap secondary = new HashMap(11);
    private CookieSet cookieSet;
    boolean checked = false;
    private ChangeListener chLis;
    private static EmptyRecognizer RECOGNIZER = new EmptyRecognizer();

    public MultiDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, (DataLoader)multiFileLoader);
        this.primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    }

    MultiDataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
        this.primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    }

    public final MultiFileLoader getMultiFileLoader() {
        DataLoader dataLoader = this.getLoader();
        if (!(dataLoader instanceof MultiFileLoader)) {
            return null;
        }
        return (MultiFileLoader)dataLoader;
    }

    public Set files() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            FilesSet filesSet = new FilesSet((Object)this.getPrimaryFile(), this.secondary);
            return filesSet;
        }
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    private boolean existReadOnlySecondary() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Iterator iterator = this.secondary.keySet().iterator();
            while (iterator.hasNext()) {
                if (!((FileObject)iterator.next()).isReadOnly()) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private HashMap getSecondary() {
        if (!this.checked) {
            this.checkFiles(this);
            this.checked = true;
        }
        return this.secondary;
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    Object synchObjectSecondary() {
        return this.getSecondary();
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        return dataNode;
    }

    protected final void addSecondaryEntry(Entry entry) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            this.secondary.put(entry.getFile(), entry);
        }
        this.firePropertyChangeLater("files", null, null);
    }

    protected final void removeSecondaryEntry(Entry entry) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            this.secondary.remove(entry.getFile());
        }
        this.firePropertyChangeLater("files", null, null);
        if (entry.isImportant()) {
            this.checkConsistency(this);
        }
    }

    final void markSecondaryEntriesRecognized(DataLoader.RecognizedFiles recognizedFiles) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Iterator iterator = this.secondary.keySet().iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                recognizedFiles.markRecognized(fileObject);
            }
        }
    }

    protected final Entry registerEntry(FileObject fileObject) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            if (fileObject == null) {
                Entry entry = this.primary;
                return entry;
            }
            if (fileObject.equals(this.getPrimaryFile())) {
                Entry entry = this.primary;
                return entry;
            }
            Entry entry = (Entry)this.secondary.get(fileObject);
            if (entry != null) {
                Entry entry2 = entry;
                return entry2;
            }
            entry = this.createSecondaryEntry(this, fileObject);
            this.addSecondaryEntry(entry);
            Entry entry3 = entry;
            return entry3;
        }
    }

    final void removeFile(FileObject fileObject) {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Entry entry = (Entry)this.secondary.get(fileObject);
            if (entry != null) {
                this.removeSecondaryEntry(entry);
            }
        }
    }

    public final Entry getPrimaryEntry() {
        return this.primary;
    }

    public final Set secondaryEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            HashSet hashSet = new HashSet(this.secondary.values());
            return hashSet;
        }
    }

    public final Entry findSecondaryEntry(FileObject fileObject) {
        Entry entry;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            entry = (Entry)this.secondary.get(fileObject);
        }
        return entry;
    }

    private void removeAllInvalid() {
        Iterator iterator = this.getSecondary().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FileObject fileObject = (FileObject)entry.getKey();
            if (fileObject.isValid()) continue;
            iterator.remove();
            this.firePropertyChangeLater("files", null, null);
        }
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryEntry().takeLock();
    }

    private String existInFolder(FileObject fileObject, FileObject fileObject2) {
        if (fileObject.isFolder() && this.isMergingFolders()) {
            return "";
        }
        String string = fileObject.getName();
        String string2 = FileUtil.findFreeFileName((FileObject)fileObject2, (String)string, (String)fileObject.getExt());
        if (string2.length() <= string.length()) {
            return "";
        }
        return string2.substring(string.length());
    }

    boolean isMergingFolders() {
        return false;
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        FileObject fileObject = this.getPrimaryEntry().copy(dataFolder.getPrimaryFile(), string);
        Iterator iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).copy(dataFolder.getPrimaryFile(), string);
        }
        try {
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleDelete() throws IOException {
        Object object;
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.synchObjectSecondary();
        synchronized (object2) {
            iterator = ((AbstractList)new ArrayList(this.secondary.entrySet())).iterator();
        }
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            ((Entry)object.getValue()).delete();
            arrayList.add(object.getKey());
        }
        object = this.synchObjectSecondary();
        synchronized (object) {
            Object[] objectArray = arrayList.toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.secondary.remove(objectArray[n]);
                ++n;
            }
        }
        this.getPrimaryEntry().delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileObject handleRename(String string) throws IOException {
        Object[] objectArray;
        Object object;
        Iterator iterator;
        this.getPrimaryEntry().changeFile(this.getPrimaryEntry().rename(string));
        HashMap<FileObject, Entry> hashMap = null;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.synchObjectSecondary();
        synchronized (object2) {
            iterator = ((AbstractList)new ArrayList(this.secondary.entrySet())).iterator();
        }
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            objectArray = ((Entry)object.getValue()).rename(string);
            if (objectArray == null) {
                arrayList.add(object.getKey());
                continue;
            }
            if (objectArray.equals(object.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<FileObject, Entry>();
            }
            Entry entry = (Entry)object.getValue();
            entry.changeFile((FileObject)objectArray);
            hashMap.put(entry.getFile(), entry);
            arrayList.add(object.getKey());
        }
        if (hashMap != null || !arrayList.isEmpty()) {
            object = this.synchObjectSecondary();
            synchronized (object) {
                if (!arrayList.isEmpty()) {
                    objectArray = arrayList.toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        this.secondary.remove(objectArray[n]);
                        ++n;
                    }
                }
                if (hashMap != null) {
                    this.secondary.putAll(hashMap);
                }
            }
            this.firePropertyChangeLater("files", null, null);
        }
        return this.getPrimaryEntry().getFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        List list = this.saveEntries();
        try {
            Object[] objectArray;
            Object object;
            Iterator iterator;
            this.getPrimaryEntry().changeFile(this.getPrimaryEntry().move(dataFolder.getPrimaryFile(), string));
            HashMap<FileObject, Entry> hashMap = null;
            ArrayList arrayList = new ArrayList();
            Object object2 = this.synchObjectSecondary();
            synchronized (object2) {
                iterator = ((AbstractList)new ArrayList(this.secondary.entrySet())).iterator();
            }
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                objectArray = ((Entry)object.getValue()).move(dataFolder.getPrimaryFile(), string);
                if (objectArray == null) {
                    arrayList.add(object.getKey());
                    continue;
                }
                if (objectArray.equals(object.getKey())) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<FileObject, Entry>();
                }
                Entry entry = (Entry)object.getValue();
                entry.changeFile((FileObject)objectArray);
                hashMap.put(entry.getFile(), entry);
                arrayList.add(object.getKey());
            }
            if (hashMap != null || !arrayList.isEmpty()) {
                object = this.synchObjectSecondary();
                synchronized (object) {
                    if (!arrayList.isEmpty()) {
                        objectArray = arrayList.toArray();
                        int n = 0;
                        while (n < objectArray.length) {
                            this.secondary.remove(objectArray[n]);
                            ++n;
                        }
                    }
                    if (hashMap != null) {
                        this.secondary.putAll(hashMap);
                    }
                }
                this.firePropertyChangeLater("files", null, null);
            }
            return this.getPrimaryEntry().getFile();
        }
        catch (IOException iOException) {
            this.restoreEntries(list);
            throw iOException;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.getPrimaryFile().getExt());
        }
        FileObject fileObject = this.getPrimaryEntry().createFromTemplate(dataFolder.getPrimaryFile(), string);
        Iterator iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).createFromTemplate(dataFolder.getPrimaryFile(), string);
        }
        try {
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    public void setCookieSet(CookieSet cookieSet) {
        this.setCookieSet(cookieSet, true);
    }

    private void setCookieSet(CookieSet cookieSet, boolean bl) {
        Object object = cookieSetLock;
        synchronized (object) {
            ChangeListener changeListener = this.getChangeListener();
            if (this.cookieSet != null) {
                this.cookieSet.removeChangeListener(changeListener);
            }
            cookieSet.addChangeListener(changeListener);
            this.cookieSet = cookieSet;
        }
        if (bl) {
            this.fireCookieChange();
        }
    }

    public CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        Object object = cookieSetLock;
        synchronized (object) {
            if (this.cookieSet != null) {
                CookieSet cookieSet2 = this.cookieSet;
                return cookieSet2;
            }
            this.setCookieSet(new CookieSet(), false);
            CookieSet cookieSet3 = this.cookieSet;
            return cookieSet3;
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie;
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null && (cookie = cookieSet.getCookie(clazz)) != null) {
            return cookie;
        }
        return super.getCookie(clazz);
    }

    final void fireCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    private void firePropertyChangeLater(final String string, final Object object, final Object object2) {
        firingProcessor.post(new Runnable(){

            public void run() {
                MultiDataObject.this.firePropertyChange(string, object, object2);
            }
        });
    }

    final void recognizedByFolder() {
        this.checked = true;
    }

    final ChangeListener getChangeListener() {
        if (this.chLis == null) {
            this.chLis = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MultiDataObject.this.fireCookieChange();
                }
            };
        }
        return this.chLis;
    }

    private final Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createPrimaryEntry(multiDataObject, fileObject);
        }
        Object object = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return object;
    }

    private final Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createSecondaryEntryImpl(multiDataObject, fileObject);
        }
        Object object = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return object;
    }

    private final MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        MultiDataObject multiDataObject = multiFileLoader != null ? multiFileLoader.createMultiObject(fileObject) : (MultiDataObject)this.getLoader().findDataObject(fileObject, (DataLoader.RecognizedFiles)RECOGNIZER);
        DataObjectPool.getPOOL().notifyCreation((DataObject)multiDataObject);
        return multiDataObject;
    }

    private final void checkConsistency(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkConsistency(multiDataObject);
        }
    }

    private final void checkFiles(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkFiles(multiDataObject);
        }
    }

    final List saveEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Serializable serializable;
            LinkedList<Pair> linkedList = new LinkedList<Pair>();
            Iterator iterator = this.secondaryEntries().iterator();
            linkedList.add(new Pair(this.getPrimaryEntry()));
            while (iterator.hasNext()) {
                serializable = (Entry)iterator.next();
                linkedList.add(new Pair((Entry)serializable));
            }
            serializable = linkedList;
            return serializable;
        }
    }

    final void restoreEntries(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.entry.getFile().equals(pair.file)) continue;
            if (pair.file.isValid()) {
                pair.entry.changeFile(pair.file);
                continue;
            }
            try {
                if (pair.entry.getFile().isData()) {
                    pair.entry.changeFile(pair.entry.getFile().copy(pair.file.getParent(), pair.file.getName(), pair.file.getExt()));
                    continue;
                }
                FileObject fileObject = pair.file.getParent().createFolder(pair.file.getName());
                FileUtil.copyAttributes((FileObject)pair.entry.getFile(), (FileObject)fileObject);
                pair.entry.changeFile(fileObject);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void notifyFileDeleted(FileEvent fileEvent) {
        this.removeFile(fileEvent.getFile());
        if (fileEvent.getFile().equals(this.getPrimaryFile())) {
            try {
                this.setValid(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            }
        }
    }

    void notifyFileDataCreated(FileEvent fileEvent) {
        this.checked = false;
    }

    private static final class EntryReplace
    implements Serializable {
        static final long serialVersionUID = -1498798537289529182L;
        private FileObject file;
        private transient Entry entry;

        public EntryReplace(FileObject fileObject) {
            this.file = fileObject;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                if (dataObject instanceof MultiDataObject) {
                    MultiDataObject multiDataObject = (MultiDataObject)dataObject;
                    if (this.file.equals(multiDataObject.getPrimaryFile())) {
                        this.entry = multiDataObject.getPrimaryEntry();
                    } else {
                        Entry entry = multiDataObject.findSecondaryEntry(this.file);
                        if (entry == null) {
                            throw new InvalidObjectException(dataObject.toString());
                        }
                        this.entry = entry;
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new InvalidObjectException(dataObjectNotFoundException.getMessage());
            }
        }

        public Object readResolve() {
            return this.entry;
        }
    }

    public abstract class Entry
    implements Serializable {
        static final long serialVersionUID = 6024795908818133571L;
        private FileObject file;
        private transient WeakReference lock;

        protected Entry(FileObject fileObject) {
            this.changeFile(fileObject);
        }

        final void changeFile(FileObject fileObject) {
            FileLock fileLock;
            if (fileObject.equals(this.file)) {
                return;
            }
            fileObject.setImportant(this.isImportant());
            this.file = fileObject;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock != null && fileLock.isValid()) {
                fileLock.releaseLock();
            }
            this.lock = null;
        }

        public final FileObject getFile() {
            return this.file;
        }

        public final MultiDataObject getDataObject() {
            return MultiDataObject.this;
        }

        public boolean isImportant() {
            return true;
        }

        public abstract FileObject copy(FileObject var1, String var2) throws IOException;

        public abstract FileObject rename(String var1) throws IOException;

        public abstract FileObject move(FileObject var1, String var2) throws IOException;

        public abstract void delete() throws IOException;

        public abstract FileObject createFromTemplate(FileObject var1, String var2) throws IOException;

        public FileLock takeLock() throws IOException {
            FileLock fileLock;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock == null || !fileLock.isValid()) {
                fileLock = this.getFile().lock();
                this.lock = new WeakReference<FileLock>(fileLock);
            }
            return fileLock;
        }

        public boolean isLocked() {
            FileLock fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            return fileLock != null && fileLock.isValid();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return this.getFile().equals(((Entry)object).getFile());
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        protected Object writeReplace() {
            return new EntryReplace(this.getFile());
        }
    }

    private static final class Pair {
        Entry entry;
        FileObject file;

        Pair(Entry entry) {
            this.entry = entry;
            this.file = entry.getFile();
        }
    }

    private static class EmptyRecognizer
    implements DataLoader.RecognizedFiles {
        private EmptyRecognizer() {
        }

        public void markRecognized(FileObject fileObject) {
        }
    }
}

