/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.netbeans.spi.xml.cookies.Util;
import org.openide.filesystems.FileStateInvalidException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class SharedXMLSupport {
    private CookieObserver console;
    private final InputSource inputSource;
    private final int mode;
    private Locator locator;
    private int fatalErrors;
    private int errors;
    private boolean bogusSchemaRequest;
    private boolean reportBogusSchemaRequest = Boolean.getBoolean("netbeans.xml.reportBogusSchemaLocation");
    static /* synthetic */ Class class$java$lang$Object;

    public SharedXMLSupport(InputSource inputSource) {
        this(inputSource, 3);
    }

    public SharedXMLSupport(InputSource inputSource, int mode) {
        if (inputSource == null) {
            throw new NullPointerException();
        }
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException();
        }
        this.inputSource = inputSource;
        this.mode = mode;
    }

    boolean checkXML(CookieObserver l) {
        try {
            this.console = l;
            this.parse(false);
            boolean bl = this.fatalErrors == 0;
            Object var4_3 = null;
            this.console = null;
            this.locator = null;
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.console = null;
            this.locator = null;
            throw throwable;
        }
    }

    boolean validateXML(CookieObserver l) {
        boolean bl;
        try {
            this.console = l;
            if (this.mode != 3) {
                this.sendMessage(Util.THIS.getString("MSG_not_a_doc"));
                boolean bl2 = false;
                Object var4_4 = null;
                this.console = null;
                this.locator = null;
                return bl2;
            }
            this.parse(true);
            bl = this.errors == 0 && this.fatalErrors == 0;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.console = null;
            this.locator = null;
            throw throwable;
        }
        Object var4_5 = null;
        this.console = null;
        this.locator = null;
        return bl;
    }

    private void parse(boolean validate) {
        this.fatalErrors = 0;
        this.errors = 0;
        String checkedFile = this.inputSource.getSystemId();
        this.sendMessage(Util.THIS.getString("MSG_checking", checkedFile));
        Handler handler = new Handler();
        try {
            XMLReader parser = this.createParser(validate);
            if (parser == null) {
                ++this.fatalErrors;
                this.console.receive(new CookieMessage(Util.THIS.getString("MSG_cannot_create_parser"), 3));
                return;
            }
            parser.setErrorHandler(handler);
            parser.setContentHandler(handler);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(checkedFile + ":" + this.parserDescription(parser));
            }
            InputSource input = this.createInputSource();
            if (this.mode == 1) {
                new SAXEntityParser(parser, true).parse(input);
            } else if (this.mode == 2) {
                new SAXEntityParser(parser, false).parse(input);
            } else {
                parser.parse(input);
            }
        }
        catch (SAXException ex) {
        }
        catch (FileStateInvalidException ex) {
            handler.fatalError(new SAXParseException(ex.getLocalizedMessage(), this.locator, (Exception)((Object)ex)));
        }
        catch (IOException ex) {
            handler.fatalError(new SAXParseException(ex.getLocalizedMessage(), this.locator, ex));
        }
        catch (RuntimeException ex) {
            String msg = Util.THIS.getString("EX_parser_ierr", ex.getMessage());
            handler.fatalError(new SAXParseException(msg, this.locator, ex));
        }
    }

    protected EntityResolver createEntityResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        return catalog == null ? null : catalog.getEntityResolver();
    }

    protected InputSource createInputSource() throws IOException {
        return this.inputSource;
    }

    protected XMLReader createParser(boolean validate) {
        EntityResolver res;
        XMLReader ret = null;
        String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
        String XERCES_PROPERTY_PREFIX = "http://apache.org/xml/properties/";
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validate);
        try {
            SAXParser parser = factory.newSAXParser();
            ret = parser.getXMLReader();
        }
        catch (Exception ex) {
            this.sendMessage(Util.THIS.getString("MSG_parser_err_1"));
            return null;
        }
        if (validate) {
            try {
                ret.setFeature("http://apache.org/xml/features/validation/schema", validate);
            }
            catch (SAXException ex) {
                this.sendMessage(Util.THIS.getString("MSG_parser_no_schema"));
            }
        }
        if (ret != null && (res = this.createEntityResolver()) != null) {
            ret.setEntityResolver(new VerboseEntityResolver(res));
        }
        return ret;
    }

    private String parserDescription(XMLReader parser) {
        Class<?> klass = parser.getClass();
        try {
            ProtectionDomain domain = klass.getProtectionDomain();
            CodeSource source = domain.getCodeSource();
            if (source == null && (klass.getClassLoader() == null || klass.getClassLoader().equals((class$java$lang$Object == null ? (class$java$lang$Object = SharedXMLSupport.class$("java.lang.Object")) : class$java$lang$Object).getClassLoader()))) {
                return Util.THIS.getString("MSG_platform_parser");
            }
            if (source == null) {
                return Util.THIS.getString("MSG_unknown_parser", klass.getName());
            }
            URL location = source.getLocation();
            return Util.THIS.getString("MSG_parser_plug", location.toExternalForm());
        }
        catch (SecurityException ex) {
            return Util.THIS.getString("MSG_unknown_parser", klass.getName());
        }
    }

    private void sendMessage(String message) {
        if (this.console != null) {
            this.console.receive(new CookieMessage(message));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VerboseEntityResolver
    implements EntityResolver {
        private final EntityResolver peer;

        public VerboseEntityResolver(EntityResolver res) {
            if (res == null) {
                throw new NullPointerException();
            }
            this.peer = res;
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException, IOException {
            InputSource result = this.peer.resolveEntity(pid, sid);
            if (result == null) {
                String warning;
                SharedXMLSupport.this.bogusSchemaRequest = pid == null && sid == null;
                if (SharedXMLSupport.this.bogusSchemaRequest) {
                    return null;
                }
                String pidLabel = pid != null ? pid : Util.THIS.getString("MSG_no_pid");
                try {
                    String file = new URL(sid).getFile();
                    warning = file != null ? Util.THIS.getString("MSG_resolver_1", pidLabel, sid) : Util.THIS.getString("MSG_resolver_2", pidLabel, sid);
                }
                catch (MalformedURLException ex) {
                    warning = Util.THIS.getString("MSG_resolver_3", pidLabel, sid);
                }
                SharedXMLSupport.this.sendMessage(warning);
            }
            return result;
        }
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void warning(SAXParseException ex) {
            String msg = ex.getLocalizedMessage();
            if (SharedXMLSupport.this.bogusSchemaRequest) {
                SharedXMLSupport.this.bogusSchemaRequest = false;
                if (msg != null && msg.indexOf("schema_reference.4") != -1) {
                    if (SharedXMLSupport.this.reportBogusSchemaRequest) {
                        SharedXMLSupport.this.reportBogusSchemaRequest = false;
                    } else {
                        return;
                    }
                }
            }
            CookieMessage message = new CookieMessage(msg, 1, new DefaultXMLProcessorDetail(ex));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(message);
            }
        }

        public void error(SAXParseException ex) throws SAXException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Just diagnostic exception", ex);
            }
            if (SharedXMLSupport.this.errors++ == this.getMaxErrorCount()) {
                String msg = Util.THIS.getString("MSG_too_many_errs");
                SharedXMLSupport.this.sendMessage(msg);
                throw ex;
            }
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 2, new DefaultXMLProcessorDetail(ex));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(message);
            }
        }

        public void fatalError(SAXParseException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Just diagnostic exception", ex);
            }
            SharedXMLSupport.this.fatalErrors++;
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 3, new DefaultXMLProcessorDetail(ex));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(message);
            }
        }

        public void setDocumentLocator(Locator locator) {
            SharedXMLSupport.this.locator = locator;
        }

        private int getMaxErrorCount() {
            return 20;
        }
    }
}

