/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.DateComparator;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.QuestionableRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public abstract class BasicCommand
extends BuildableCommand {
    protected List requests = new LinkedList();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected File[] files;

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setFiles(File[] fileArray) {
        if (fileArray == null) {
            this.files = fileArray;
            return;
        }
        this.files = new File[fileArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = fileArray[n4];
            if (file.isDirectory()) {
                this.files[n3 - (1 + n2)] = file;
                ++n2;
            } else {
                this.files[n] = file;
                ++n;
            }
            ++n4;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getXthFile(int n) {
        if (n < 0 || n >= this.files.length) {
            return null;
        }
        File file = this.files[n];
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public File getFileEndingWith(String string) {
        String string2 = string.replace('\\', '/');
        String string3 = this.getLocalDirectory().replace('\\', '/');
        int n = 0;
        n = 0;
        while (n < this.files.length) {
            String string4 = this.files[n].getAbsolutePath();
            String string5 = this.files[n].getParentFile().getAbsolutePath().replace('\\', '/');
            if ((string4 = string4.replace('\\', '/')).endsWith(string2) && string2.indexOf(47) >= 0 || this.files[n].getName().equals(string2) && string5.equals(string3)) {
                return this.files[n];
            }
            ++n;
        }
        return null;
    }

    private void addRequests(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot add requests for a null path.");
        }
        if (!file.exists() || file.isFile()) {
            this.addRequestsForFile(file);
        } else {
            this.addRequestsForDirectory(file);
        }
    }

    protected boolean doesCheckFileTime() {
        return true;
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (entry == null) {
            return;
        }
        if (file != null && !file.exists() && entry.isNewUserFile()) {
            return;
        }
        Date date = entry.getLastModified();
        boolean bl = entry.hadConflicts();
        if (!bl) {
            entry.setConflict(null);
        }
        this.addRequest(new EntryRequest(entry));
        if (file == null || !file.exists() || entry.isUserFileToBeRemoved()) {
            return;
        }
        if (this.doesCheckFileTime() && !bl && date != null && DateComparator.getInstance().equals(file.lastModified(), date.getTime())) {
            this.addRequest(new UnchangedRequest(file.getName()));
            return;
        }
        this.addRequest(new ModifiedRequest(file, entry.isBinary()));
    }

    protected void addRequestsForDirectory(File file) throws IOException {
        Object object;
        Object object2;
        if (!file.exists()) {
            return;
        }
        this.addDirectoryRequest(file);
        List list = this.createLocalFileList(file);
        LinkedList<File> linkedList = null;
        if (this.isRecursive()) {
            linkedList = new LinkedList<File>();
        }
        Iterator iterator = this.clientServices.getEntries(file);
        while (iterator.hasNext()) {
            object2 = (Entry)iterator.next();
            if (((Entry)object2).isDirectory()) {
                if (!this.isRecursive()) continue;
                linkedList.add(new File(file, ((Entry)object2).getName()));
                continue;
            }
            object = new File(file, ((Entry)object2).getName());
            this.addRequestForFile((File)object, (Entry)object2);
            list.remove(object);
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = ((File)object2.next()).getName();
            if (this.clientServices.shouldBeIgnored(file, (String)object)) continue;
            this.addRequest(new QuestionableRequest((String)object));
        }
        if (this.isRecursive()) {
            object = linkedList.iterator();
            while (object.hasNext()) {
                File file2 = (File)object.next();
                File file3 = new File(file2, "CVS");
                if (!file3.exists()) continue;
                this.addRequestsForDirectory(file2);
            }
        }
    }

    private List createLocalFileList(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (!fileArray[n].isDirectory()) {
                    linkedList.add(fileArray[n]);
                }
                ++n;
            }
        }
        return linkedList;
    }

    protected void addRequestForFile(File file, Entry entry) {
        this.sendEntryAndModifiedRequests(entry, file);
    }

    protected void addRequestsForFile(File file) throws IOException {
        this.addDirectoryRequest(file.getParentFile());
        try {
            Entry entry = this.clientServices.getEntry(file);
            if (entry != null) {
                this.addRequestForFile(file, entry);
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred getting the Entry for file " + file + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    protected final void addDirectoryRequest(File file) {
        String string = this.getRelativeToLocalPathInUnixStyle(file);
        try {
            String string2 = this.clientServices.getRepositoryForDirectory(file.getAbsolutePath());
            this.addRequest(new DirectoryRequest(string, string2));
            String string3 = this.clientServices.getStickyTagForDirectory(file);
            if (string3 != null) {
                this.addRequest(new StickyRequest(string3));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println("An error occurred reading the respository for the directory " + string + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    protected void addArgumentRequests() {
        if (this.files == null) {
            return;
        }
        int n = 0;
        while (n < this.files.length) {
            File file = this.files[n];
            String string = this.getRelativeToLocalPathInUnixStyle(file);
            this.addRequest(new ArgumentRequest(string));
            ++n;
        }
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        this.requests.clear();
        super.execute(clientServices, eventManager);
        this.clientServices = clientServices;
        if (clientServices.isFirstCommand()) {
            this.addRequest(new RootRequest(clientServices.getRepository()));
        }
        this.addFileRequests();
    }

    private void addFileRequests() throws CommandException {
        try {
            if (this.files != null && this.files.length > 0) {
                int n = 0;
                while (n < this.files.length) {
                    this.addRequests(this.files[n]);
                    ++n;
                }
            } else if (this.assumeLocalPathWhenUnspecified()) {
                this.addRequests(new File(this.getLocalDirectory()));
            }
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return true;
    }

    protected final void addRequest(Request request) {
        this.requests.add(request);
    }

    protected final void addRequestForWorkingDirectory(ClientServices clientServices) throws IOException {
        this.addRequest(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
    }

    protected final void addArgumentRequest(boolean bl, String string) {
        if (!bl) {
            return;
        }
        this.addRequest(new ArgumentRequest(string));
    }

    protected final void appendFileArguments(StringBuffer stringBuffer) {
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(fileArray[n].getName());
            ++n;
        }
    }
}

