/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class CommitBuilder
implements Builder {
    public static final String UNKNOWN = "commit: nothing known about `";
    public static final String EXAM_DIR = "server: Examining";
    public static final String CHECKING_IN = "Checking in ";
    public static final String REMOVING = "Removing ";
    public static final String NEW_REVISION = "new revision:";
    public static final String INITIAL_REVISION = "initial revision:";
    public static final String DONE = "done";
    public static final String RCS_FILE = "RCS file: ";
    public static final String ADD = "commit: use `cvs add' to create an entry for ";
    private CommitInformation commitInformation;
    private String fileDirectory;
    private final EventManager eventManager;
    private final String localPath;
    private boolean isAdding;

    public CommitBuilder(EventManager eventManager, String string) {
        this.eventManager = eventManager;
        this.localPath = string;
    }

    public void outputDone() {
        if (this.commitInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.commitInformation));
            this.commitInformation = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (string.indexOf(UNKNOWN) >= 0) {
            this.processUnknownFile(string.substring(string.indexOf(UNKNOWN) + UNKNOWN.length()).trim());
        } else if (string.indexOf(ADD) > 0) {
            this.processToAddFile(string.substring(string.indexOf(ADD) + ADD.length()).trim());
        } else if (string.startsWith(CHECKING_IN)) {
            this.processFile(string.substring(CHECKING_IN.length(), string.length() - 1));
            if (this.isAdding) {
                this.commitInformation.setType("Added");
                this.isAdding = false;
            } else {
                this.commitInformation.setType("Changed");
            }
        } else if (string.startsWith(REMOVING)) {
            this.processFile(string.substring(REMOVING.length(), string.length() - 1));
            this.commitInformation.setType("Removed");
        } else if (string.indexOf(EXAM_DIR) >= 0) {
            this.fileDirectory = string.substring(string.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
        } else if (string.startsWith(RCS_FILE)) {
            this.isAdding = true;
        } else if (string.startsWith(DONE)) {
            this.outputDone();
        } else if (string.startsWith(INITIAL_REVISION)) {
            this.processRevision(string.substring(INITIAL_REVISION.length()));
        } else if (string.startsWith(NEW_REVISION)) {
            this.processRevision(string.substring(NEW_REVISION.length()));
        }
    }

    private File createFile(String string) {
        return new File(this.localPath, string);
    }

    private void processUnknownFile(String string) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("Unknown");
        int n = string.indexOf(39);
        String string2 = string.substring(0, n - 1).trim();
        this.commitInformation.setFile(this.createFile(string2));
        this.outputDone();
    }

    private void processToAddFile(String string) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("To-be-added");
        String string2 = string.trim();
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        this.commitInformation.setFile(this.createFile(string2));
        this.outputDone();
    }

    private void processFile(String string) {
        if (this.commitInformation == null) {
            this.commitInformation = new CommitInformation();
        }
        if (string.startsWith("no file")) {
            string = string.substring(8);
        }
        this.commitInformation.setFile(this.createFile(string));
    }

    private void processRevision(String string) {
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        this.commitInformation.setRevision(string.trim());
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

