/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.diff;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.diff.DiffCommand;
import org.netbeans.lib.cvsclient.command.diff.DiffInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class SimpleDiffBuilder
implements Builder {
    protected EventManager eventManager;
    protected DiffCommand diffCommand;
    protected DiffInformation diffInformation;
    protected String fileDirectory;
    protected boolean readingDiffs = false;
    private static final String UNKNOWN = "server: I know nothing about";
    private static final String CANNOT_FIND = "server: cannot find";
    private static final String UNKNOWN_TAG = "server: tag";
    private static final String EXAM_DIR = "server: Diffing";
    private static final String FILE = "Index: ";
    private static final String RCS_FILE = "RCS file: ";
    private static final String REVISION = "retrieving revision ";
    private static final String PARAMETERS = "diff ";
    private DiffInformation.DiffChange currentChange;

    public SimpleDiffBuilder(EventManager eventManager, DiffCommand diffCommand) {
        this.eventManager = eventManager;
        this.diffCommand = diffCommand;
    }

    public void outputDone() {
        if (this.diffInformation != null) {
            if (this.currentChange != null) {
                this.diffInformation.addChange(this.currentChange);
                this.currentChange = null;
            }
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.diffInformation));
            this.diffInformation = null;
            this.readingDiffs = false;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (this.readingDiffs) {
            if (string.startsWith(FILE)) {
                this.outputDone();
            } else {
                this.processDifferences(string);
                return;
            }
        }
        if (string.indexOf(UNKNOWN) >= 0) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.diffInformation));
            this.diffInformation = null;
            return;
        }
        if (string.indexOf(EXAM_DIR) >= 0) {
            this.fileDirectory = string.substring(string.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
            return;
        }
        if (string.startsWith(FILE)) {
            this.processFile(string.substring(FILE.length()));
            return;
        }
        if (string.startsWith(RCS_FILE)) {
            this.processRCSfile(string.substring(RCS_FILE.length()));
            return;
        }
        if (string.startsWith(REVISION)) {
            this.processRevision(string.substring(REVISION.length()));
            return;
        }
        if (string.startsWith(PARAMETERS)) {
            this.processParameters(string.substring(PARAMETERS.length()));
            this.readingDiffs = true;
            return;
        }
    }

    protected void processFile(String string) {
        this.outputDone();
        this.diffInformation = this.createDiffInformation();
        String string2 = string.trim();
        if (string2.startsWith("no file")) {
            string2 = string2.substring(8);
        }
        this.diffInformation.setFile(new File(this.diffCommand.getLocalDirectory(), string2));
    }

    protected void processRCSfile(String string) {
        if (this.diffInformation == null) {
            return;
        }
        this.diffInformation.setRepositoryFileName(string.trim());
    }

    protected void processRevision(String string) {
        if (this.diffInformation == null) {
            return;
        }
        string = string.trim();
        if (this.diffInformation.getLeftRevision() != null) {
            this.diffInformation.setRightRevision(string);
        } else {
            this.diffInformation.setLeftRevision(string);
        }
    }

    protected void processParameters(String string) {
        if (this.diffInformation == null) {
            return;
        }
        this.diffInformation.setParameters(string.trim());
    }

    public DiffInformation createDiffInformation() {
        return new DiffInformation();
    }

    protected void assignType(DiffInformation.DiffChange diffChange, String string) {
        int n = 0;
        int n2 = string.indexOf(99);
        if (n2 > 0) {
            diffChange.setType(2);
            n = n2;
        } else {
            int n3 = string.indexOf(97);
            if (n3 > 0) {
                diffChange.setType(0);
                n = n3;
            } else {
                int n4 = string.indexOf(100);
                if (n4 > 0) {
                    diffChange.setType(1);
                    n = n4;
                }
            }
        }
        String string2 = string.substring(0, n);
        diffChange.setLeftRange(this.getMin(string2), this.getMax(string2));
        String string3 = string.substring(n + 1);
        diffChange.setRightRange(this.getMin(string3), this.getMax(string3));
    }

    private int getMin(String string) {
        int n;
        String string2 = string;
        int n2 = string2.indexOf(44);
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private int getMax(String string) {
        int n;
        String string2 = string;
        int n2 = string2.indexOf(44);
        if (n2 > 0) {
            string2 = string2.substring(n2 + 1);
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    protected void processDifferences(String string) {
        char c = string.charAt(0);
        if (c >= '0' && c <= '9') {
            if (this.currentChange != null) {
                this.diffInformation.addChange(this.currentChange);
            }
            this.currentChange = this.diffInformation.createDiffChange();
            this.assignType(this.currentChange, string);
        }
        if (c == '<') {
            this.currentChange.appendLeftLine(string.substring(2));
        }
        if (c == '>') {
            this.currentChange.appendRightLine(string.substring(2));
        }
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

