/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.edit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class EditCommand
extends BasicCommand {
    private boolean checkThatUnedited;
    private boolean forceEvenIfEdited;
    private Watch temporaryWatch;
    private transient ClientServices clientServices;

    public static File getEditBackupFile(File file) {
        return new File(file.getParent(), "CVS/Base/" + file.getName());
    }

    public EditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        block7: {
            this.clientServices = clientServices;
            try {
                try {
                    clientServices.ensureConnection();
                    super.execute(clientServices, eventManager);
                    this.addArgumentRequest(this.isCheckThatUnedited(), "-c");
                    this.addArgumentRequest(this.isForceEvenIfEdited(), "-f");
                    this.addRequestForWorkingDirectory(clientServices);
                    this.addRequest(CommandRequest.NOOP);
                    clientServices.processRequests(this.requests);
                }
                catch (AuthenticationException authenticationException) {
                    Object var8_4 = null;
                    this.requests.clear();
                    this.clientServices = null;
                    break block7;
                }
                catch (CommandException commandException) {
                    throw commandException;
                }
                catch (EOFException eOFException) {
                    throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
                }
                catch (Exception exception) {
                    throw new CommandException(exception, exception.getLocalizedMessage());
                }
                Object var8_3 = null;
                this.requests.clear();
                this.clientServices = null;
            }
            catch (Throwable throwable) {
                Object var8_5 = null;
                this.requests.clear();
                this.clientServices = null;
                throw throwable;
            }
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String string = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "E", string));
        try {
            this.editFile(this.clientServices, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("edit ");
        stringBuffer.append(this.getCVSArguments());
        this.appendFileArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnedited(false);
        this.setForceEvenIfEdited(true);
        this.setTemporaryWatch(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }

    public boolean isCheckThatUnedited() {
        return this.checkThatUnedited;
    }

    public void setCheckThatUnedited(boolean bl) {
        this.checkThatUnedited = bl;
    }

    public boolean isForceEvenIfEdited() {
        return this.forceEvenIfEdited;
    }

    public void setForceEvenIfEdited(boolean bl) {
        this.forceEvenIfEdited = bl;
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch watch) {
        this.temporaryWatch = watch;
    }

    private void editFile(ClientServices clientServices, File file) throws IOException {
        this.addBaserevEntry(clientServices, file);
        FileUtils.copyFile(file, EditCommand.getEditBackupFile(file));
        FileUtils.setFileReadOnly(file, false);
    }

    /*
     * Loose catch block
     */
    private void addBaserevEntry(ClientServices clientServices, File file) throws IOException {
        File file2;
        File file3;
        block26: {
            IOException iOException2222;
            String string;
            boolean bl;
            boolean bl2;
            BufferedWriter bufferedWriter;
            BufferedReader bufferedReader;
            Entry entry;
            block24: {
                entry = clientServices.getEntry(file);
                if (entry == null || entry.getRevision() == null || entry.isNewUserFile() || entry.isUserFileToBeRemoved()) {
                    throw new IllegalArgumentException("File does not have an Entry or Entry is invalid!");
                }
                file3 = new File(file.getParentFile(), "CVS/Baserev");
                file2 = new File(file3.getAbsolutePath() + '~');
                bufferedReader = null;
                bufferedWriter = null;
                bl2 = true;
                bl = true;
                string = 'B' + file.getName() + '/';
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                bl = false;
                bufferedReader = new BufferedReader(new FileReader(file3));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.startsWith(string)) {
                        bl2 = false;
                    }
                    bl = true;
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                    bl = false;
                    string2 = bufferedReader.readLine();
                }
                Object var13_13 = null;
                if (bufferedReader == null) break block24;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (bufferedWriter != null) {
                if (bl2 && !bl) {
                    bufferedWriter.write(string + entry.getRevision() + '/');
                    bufferedWriter.newLine();
                }
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException2222) {}
            }
            break block26;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    if (bl) {
                        throw iOException3;
                    }
                    Object var13_14 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (bufferedWriter != null) {
                        if (bl2 && !bl) {
                            bufferedWriter.write(string + entry.getRevision() + '/');
                            bufferedWriter.newLine();
                        }
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException42222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var13_15 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (bufferedWriter != null) {
                    if (bl2 && !bl) {
                        bufferedWriter.write(string + entry.getRevision() + '/');
                        bufferedWriter.newLine();
                    }
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        file3.delete();
        file2.renameTo(file3);
    }
}

