/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.export;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.export.ExportBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class ExportCommand
extends BasicCommand {
    private final Set emptyDirectories = new HashSet();
    private final List modules = new LinkedList();
    private final List expandedModules = new LinkedList();
    private boolean pruneDirectories;
    private KeywordSubstitutionOptions keywordSubstitutionOptions;
    private String exportByDate;
    private String exportByRevision;
    private String exportDirectory;
    private boolean useHeadIfNotFound;

    public ExportCommand() {
        this.resetCVSCommand();
    }

    public KeywordSubstitutionOptions getKeywordSubstitutionOptions() {
        return this.keywordSubstitutionOptions;
    }

    public void setKeywordSubstitutionOptions(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubstitutionOptions = keywordSubstitutionOptions;
    }

    public void setPruneDirectories(boolean bl) {
        this.pruneDirectories = bl;
    }

    public boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    public void setModule(String string) {
        this.modules.add(string);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] stringArray) {
        this.clearModules();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.modules.add(string);
            ++n;
        }
    }

    public String[] getModules() {
        String[] stringArray = new String[this.modules.size()];
        stringArray = this.modules.toArray(stringArray);
        return stringArray;
    }

    private void processExistingModules(String string) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        String[] stringArray = new String[this.expandedModules.size()];
        stringArray = this.expandedModules.toArray(stringArray);
        this.setModules(stringArray);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.requests = new LinkedList();
        if (clientServices.isFirstCommand()) {
            this.requests.add(new RootRequest(clientServices.getRepository()));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.expandedModules.clear();
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(new ExpandModulesRequest());
        try {
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(clientServices, eventManager);
    }

    public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        this.expandedModules.add(moduleExpansionEvent.getModule());
    }

    private void postExpansionExecute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        this.processExistingModules(clientServices.getLocalPath());
        super.execute(clientServices, eventManager);
        if (!this.isRecursive()) {
            this.requests.add(0, new ArgumentRequest("-l"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(0, new ArgumentRequest("-f"));
        }
        if (this.exportDirectory != null && !this.exportDirectory.equals("")) {
            this.requests.add(0, new ArgumentRequest("-d"));
            this.requests.add(1, new ArgumentRequest(this.getExportDirectory()));
        }
        if (this.exportByDate != null && this.exportByDate.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-D"));
            this.requests.add(1, new ArgumentRequest(this.getExportByDate()));
        }
        if (this.exportByRevision != null && this.exportByRevision.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-r"));
            this.requests.add(1, new ArgumentRequest(this.getExportByRevision()));
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubstitutionOptions()));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(CommandRequest.EXPORT);
        try {
            clientServices.processRequests(this.requests);
            if (this.pruneDirectories) {
                this.pruneEmptyDirectories();
            }
            this.requests.clear();
        }
        catch (CommandException commandException) {
            this.removeAllCVSAdminFiles();
            throw commandException;
        }
        catch (Exception exception) {
            this.removeAllCVSAdminFiles();
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        this.removeAllCVSAdminFiles();
    }

    private void removeAllCVSAdminFiles() {
        File file = null;
        if (this.getExportDirectory() != null) {
            file = new File(this.getLocalDirectory(), this.getExportDirectory());
            this.deleteCVSSubDirs(file);
        } else {
            file = new File(this.getLocalDirectory());
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                File file2 = new File(file.getAbsolutePath(), string);
                this.deleteCVSSubDirs(file2);
            }
        }
    }

    private void deleteCVSSubDirs(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    if (fileArray[n].getName().equalsIgnoreCase("CVS")) {
                        File[] fileArray2 = fileArray[n].listFiles();
                        int n2 = 0;
                        while (n2 < fileArray2.length) {
                            fileArray2[n2].delete();
                            ++n2;
                        }
                        fileArray[n].delete();
                    } else {
                        this.deleteCVSSubDirs(fileArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("export ");
        stringBuffer.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
        } else {
            String string = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.getExportByDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getExportByDate());
            stringBuffer.append(" ");
        }
        if (this.getExportByRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getExportByRevision());
            stringBuffer.append(" ");
        }
        if (this.isPruneDirectories()) {
            stringBuffer.append("-P ");
        }
        if (this.getExportDirectory() != null) {
            stringBuffer.append("-d ");
            stringBuffer.append(this.getExportDirectory());
            stringBuffer.append(" ");
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubstitutionOptions().toString());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'k') {
            this.setKeywordSubstitutionOptions(KeywordSubstitutionOptions.findKeywordSubstOption(string));
        } else if (c == 'r') {
            this.setExportByRevision(string);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (c == 'D') {
            this.setExportByDate(string);
        } else if (c == 'd') {
            this.setExportDirectory(string);
        } else if (c == 'P') {
            this.setPruneDirectories(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'R') {
            this.setRecursive(true);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setModules(null);
        this.setKeywordSubstitutionOptions(null);
        this.setPruneDirectories(false);
        this.setRecursive(true);
        this.setExportByDate(null);
        this.setExportByRevision(null);
        this.setExportDirectory(null);
        this.setUseHeadIfNotFound(false);
    }

    public String getOptString() {
        return "k:r:D:PlRd:f";
    }

    public Builder createBuilder(EventManager eventManager) {
        return new ExportBuilder(eventManager, this);
    }

    public void messageSent(MessageEvent messageEvent) {
        super.messageSent(messageEvent);
        if (this.pruneDirectories && messageEvent.getMessage().startsWith("cvs server: Exporting ")) {
            File file = new File(this.getLocalDirectory(), messageEvent.getMessage().substring(21));
            this.emptyDirectories.add(file);
        }
    }

    private boolean pruneEmptyDirectory(File file) throws IOException {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File file2;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    bl = false;
                } else if (!fileArray[n].getName().equals("CVS")) {
                    bl = this.pruneEmptyDirectory(fileArray[n]);
                }
                if (!bl) break;
                ++n;
            }
            if (bl && (file2 = new File(file, "CVS/Entries")).exists()) {
                File file3 = new File(file, "CVS");
                File[] fileArray2 = file3.listFiles();
                int n2 = 0;
                while (n2 < fileArray2.length) {
                    fileArray2[n2].delete();
                    ++n2;
                }
                file3.delete();
                file.delete();
            }
        }
        return bl;
    }

    private void pruneEmptyDirectories() throws IOException {
        Iterator iterator = this.emptyDirectories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            this.pruneEmptyDirectory(file);
        }
        this.emptyDirectories.clear();
    }

    public String getExportByDate() {
        return this.exportByDate;
    }

    public void setExportByDate(String string) {
        this.exportByDate = string;
    }

    public String getExportByRevision() {
        return this.exportByRevision;
    }

    public void setExportByRevision(String string) {
        this.exportByRevision = string;
    }

    public String getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(String string) {
        this.exportDirectory = string;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }
}

