/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.remove;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.remove.RemoveBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public class RemoveCommand
extends BasicCommand {
    private boolean deleteBeforeRemove;
    private boolean ignoreLocallyExistingFiles;

    public boolean isDeleteBeforeRemove() {
        return this.deleteBeforeRemove;
    }

    public void setDeleteBeforeRemove(boolean bl) {
        this.deleteBeforeRemove = bl;
    }

    public boolean doesIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public boolean isIgnoreLocallyExistingFiles() {
        return this.ignoreLocallyExistingFiles;
    }

    public void setIgnoreLocallyExistingFiles(boolean bl) {
        this.ignoreLocallyExistingFiles = bl;
    }

    public Builder createBuilder(EventManager eventManager) {
        return new RemoveBuilder(eventManager, this);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        if (this.files == null || this.files.length == 0) {
            throw new CommandException("No files have been specified for removal.", CommandException.getLocalMessage("RemoveCommand.noFilesSpecified", null));
        }
        clientServices.ensureConnection();
        if (this.isDeleteBeforeRemove()) {
            this.removeAll(this.files);
        }
        super.execute(clientServices, eventManager);
        try {
            try {
                this.addRequestForWorkingDirectory(clientServices);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.REMOVE);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var6_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (this.isIgnoreLocallyExistingFiles()) {
            file = null;
        }
        super.sendEntryAndModifiedRequests(entry, file);
        if (entry.getRevision().equals("0")) {
            try {
                this.clientServices.removeEntry(file);
            }
            catch (IOException iOException) {
                BugLog.getInstance().showException(iOException);
            }
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("remove ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                stringBuffer.append(fileArray[n].getName() + " ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'f') {
            this.setDeleteBeforeRemove(true);
        } else {
            return false;
        }
        return true;
    }

    private void removeAll(File[] fileArray) throws CommandException {
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            if (file.exists() && file.isFile()) {
                if (!file.delete()) {
                    throw new CommandException("Cannot delete file " + file.getAbsolutePath(), CommandException.getLocalMessage("RemoveCommand.cannotDelete", new Object[]{file.getAbsolutePath()}));
                }
            } else if (this.isRecursive() && !file.getName().equalsIgnoreCase("CVS")) {
                this.removeAll(file.listFiles());
            }
            ++n;
        }
    }

    public String getOptString() {
        return "flR";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDeleteBeforeRemove(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isDeleteBeforeRemove()) {
            stringBuffer.append("-f ");
        }
        return stringBuffer.toString();
    }
}

