/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class StatusBuilder
implements Builder {
    private static final String UNKNOWN = "server: nothing known about";
    private static final String EXAM_DIR = "server: Examining";
    private static final String NOT_IN_REPOSITORY = "No revision control file";
    private static final String FILE = "File: ";
    private static final String STATUS = "Status:";
    private static final String NO_FILE_FILENAME = "no file";
    private static final String WORK_REV = "   Working revision:";
    private static final String REP_REV = "   Repository revision:";
    private static final String TAG = "   Sticky Tag:";
    private static final String DATE = "   Sticky Date:";
    private static final String OPTIONS = "   Sticky Options:";
    private static final String EXISTING_TAGS = "   Existing Tags:";
    private static final String EMPTY_BEFORE_TAGS = "   ";
    private static final String NO_TAGS = "   No Tags Exist";
    private static final String UNKNOWN_FILE = "? ";
    private StatusInformation statusInformation;
    private EventManager eventManager;
    private final StatusCommand statusCommand;
    private String relativeDirectory;
    private final String localPath;
    private boolean beginning;
    private boolean readingTags;
    private final File[] fileArray;

    public StatusBuilder(EventManager eventManager, StatusCommand statusCommand) {
        this.eventManager = eventManager;
        this.statusCommand = statusCommand;
        File[] fileArray = statusCommand.getFiles();
        if (fileArray != null) {
            this.fileArray = new File[fileArray.length];
            System.arraycopy(fileArray, 0, this.fileArray, 0, fileArray.length);
        } else {
            this.fileArray = null;
        }
        this.localPath = statusCommand.getLocalDirectory();
        this.beginning = true;
    }

    public void outputDone() {
        if (this.statusInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.statusInformation));
            this.statusInformation = null;
            this.readingTags = false;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (this.readingTags) {
            if (string.startsWith(NO_TAGS)) {
                this.outputDone();
                return;
            }
            int n = string.indexOf(40);
            if (n > 0) {
                String string2 = string.substring(0, n - 1).trim();
                String string3 = string.substring(n + 1, string.length() - 1);
                if (this.statusInformation == null) {
                    this.statusInformation = new StatusInformation();
                }
                this.statusInformation.addExistingTag(string2, string3);
            } else {
                this.outputDone();
                return;
            }
        }
        if (string.startsWith(UNKNOWN_FILE) && this.beginning) {
            File file = new File(this.localPath, string.substring(UNKNOWN_FILE.length()));
            this.statusInformation = new StatusInformation();
            this.statusInformation.setFile(file);
            this.statusInformation.setStatusString(FileStatus.UNKNOWN.toString());
            this.outputDone();
        }
        if (string.startsWith(UNKNOWN)) {
            this.outputDone();
            this.beginning = false;
        } else if (string.indexOf(EXAM_DIR) >= 0) {
            this.relativeDirectory = string.substring(string.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
            this.beginning = false;
        } else if (string.startsWith(FILE)) {
            this.outputDone();
            this.statusInformation = new StatusInformation();
            this.processFileAndStatusLine(string.substring(FILE.length()));
            this.beginning = false;
        } else if (string.startsWith(WORK_REV)) {
            this.processWorkRev(string.substring(WORK_REV.length()));
        } else if (string.startsWith(REP_REV)) {
            this.processRepRev(string.substring(REP_REV.length()));
        } else if (string.startsWith(TAG)) {
            this.processTag(string.substring(TAG.length()));
        } else if (string.startsWith(DATE)) {
            this.processDate(string.substring(DATE.length()));
        } else if (string.startsWith(OPTIONS)) {
            this.processOptions(string.substring(OPTIONS.length()));
            if (!this.statusCommand.isIncludeTags()) {
                this.outputDone();
            }
        } else if (string.startsWith(EXISTING_TAGS)) {
            this.readingTags = true;
        }
    }

    private File createFile(String string) {
        File file = null;
        if (this.relativeDirectory != null) {
            file = this.relativeDirectory.trim().equals(".") ? new File(this.localPath, string) : new File(this.localPath, this.relativeDirectory + '/' + string);
        } else if (this.fileArray != null) {
            int n = 0;
            while (n < this.fileArray.length) {
                String string2;
                File file2 = this.fileArray[n];
                if (file2 != null && !file2.isDirectory() && string.equals(string2 = file2.getName())) {
                    this.fileArray[n] = null;
                    file = file2;
                    break;
                }
                ++n;
            }
        }
        if (file == null) {
            System.err.println("JAVACVS ERROR!! wrong algorithm for assigning path to single files(1)!!");
        }
        return file;
    }

    private void processFileAndStatusLine(String string) {
        int n = string.lastIndexOf(STATUS);
        String string2 = string.substring(0, n).trim();
        if (string2.startsWith(NO_FILE_FILENAME)) {
            string2 = string2.substring(8);
        }
        this.statusInformation.setFile(this.createFile(string2));
        String string3 = new String(string.substring(n + 8).trim());
        this.statusInformation.setStatusString(string3);
    }

    private boolean assertNotNull() {
        if (this.statusInformation == null) {
            System.err.println("Bug: statusInformation must not be null!");
            return false;
        }
        return true;
    }

    private void processWorkRev(String string) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setWorkingRevision(string.trim().intern());
    }

    private void processRepRev(String string) {
        if (!this.assertNotNull()) {
            return;
        }
        if ((string = string.trim()).startsWith(NOT_IN_REPOSITORY)) {
            this.statusInformation.setRepositoryRevision(string.trim().intern());
            return;
        }
        int n = string.indexOf(9);
        if (n > 0) {
            this.statusInformation.setRepositoryRevision(string.substring(0, n).trim().intern());
            this.statusInformation.setRepositoryFileName(new String(string.substring(n).trim()));
        } else {
            this.statusInformation.setRepositoryRevision("");
            this.statusInformation.setRepositoryFileName("");
        }
    }

    private void processTag(String string) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setStickyTag(string.trim().intern());
    }

    private void processDate(String string) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setStickyDate(string.trim().intern());
    }

    private void processOptions(String string) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setStickyOptions(string.trim().intern());
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

