/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.unedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.edit.EditCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class UneditCommand
extends BasicCommand {
    private Watch temporaryWatch;

    public UneditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        try {
            try {
                super.execute(clientServices, eventManager);
                this.addRequestForWorkingDirectory(clientServices);
                this.addRequest(CommandRequest.NOOP);
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (EOFException eOFException) {
                throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            Object var7_3 = null;
            this.requests.clear();
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.requests.clear();
            throw throwable;
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String string = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "U", string));
        try {
            this.uneditFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("unedit ");
        stringBuffer.append(this.getCVSArguments());
        this.appendFileArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch watch) {
        this.temporaryWatch = watch;
    }

    private void uneditFile(File file) throws IOException {
        this.removeBaserevEntry(file);
        EditCommand.getEditBackupFile(file).delete();
        FileUtils.setFileReadOnly(file, true);
    }

    /*
     * Loose catch block
     */
    private void removeBaserevEntry(File file) throws IOException {
        File file2;
        File file3;
        block23: {
            IOException iOException2222;
            BufferedWriter bufferedWriter;
            BufferedReader bufferedReader;
            block21: {
                file3 = new File(file.getParentFile(), "CVS/Baserev");
                file2 = new File(file3.getAbsolutePath() + '~');
                bufferedReader = null;
                bufferedWriter = null;
                String string = 'B' + file.getName() + '/';
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                bufferedReader = new BufferedReader(new FileReader(file3));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (!string2.startsWith(string)) {
                        bufferedWriter.write(string2);
                        bufferedWriter.newLine();
                    }
                    string2 = bufferedReader.readLine();
                }
                Object var9_9 = null;
                if (bufferedWriter == null) break block21;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2222) {}
            }
            break block23;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    IOException iOException32222;
                    Object var9_10 = null;
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException32222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var9_11 = null;
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        file3.delete();
        if (file2.length() > 0L) {
            file2.renameTo(file3);
        } else {
            file2.delete();
        }
    }
}

