/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.text.MessageFormat;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class PServerConnection
implements Connection {
    protected static final String OPEN_PREAMBLE = "BEGIN AUTH REQUEST\n";
    protected static final String OPEN_POSTAMBLE = "END AUTH REQUEST\n";
    protected static final String VERIFY_PREAMBLE = "BEGIN VERIFICATION REQUEST\n";
    protected static final String VERIFY_POSTAMBLE = "END VERIFICATION REQUEST\n";
    protected static final String AUTHENTICATION_SUCCEEDED_RESPONSE = "I LOVE YOU";
    protected static final String AUTHENTICATION_FAILED_RESPONSE = "I HATE YOU";
    protected String repository;
    protected String userName;
    protected String encodedPassword;
    public static final int DEFAULT_PORT = 2401;
    protected int port = 2401;
    protected String hostName;
    protected Socket socket;
    protected LoggedDataInputStream inputStream;
    protected LoggedDataOutputStream outputStream;

    public LoggedDataInputStream getInputStream() {
        return this.inputStream;
    }

    public LoggedDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    private void openConnection(String string, String string2) throws AuthenticationException {
        if (this.hostName == null) {
            String string3 = AuthenticationException.getBundleString("AuthenticationException.HostIsNull");
            throw new AuthenticationException("HostIsNull", string3);
        }
        try {
            this.socket = new Socket(this.hostName, this.port);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
            this.outputStream = new LoggedDataOutputStream(bufferedOutputStream);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.inputStream = new LoggedDataInputStream(bufferedInputStream);
            this.outputStream.writeBytes(string);
            this.outputStream.writeBytes(this.repository + "\n");
            this.outputStream.writeBytes(this.userName + "\n");
            this.outputStream.writeBytes(this.getEncodedPasswordNotNull() + "\n");
            this.outputStream.writeBytes(string2);
            this.outputStream.flush();
            String string4 = this.inputStream.readLine();
            if (string4.equals(AUTHENTICATION_SUCCEEDED_RESPONSE)) {
                return;
            }
            if (string4.equals(AUTHENTICATION_FAILED_RESPONSE)) {
                String string5 = this.getLocalMessage("AuthenticationException.badPassword", null);
                throw new AuthenticationException("AuthenticationFailed", string5);
            }
            String string6 = this.getLocalMessage("AuthenticationException.AuthenticationFailed", new Object[]{string4});
            throw new AuthenticationException("AuthenticationFailed", string6);
        }
        catch (AuthenticationException authenticationException) {
            this.reset();
            throw authenticationException;
        }
        catch (ConnectException connectException) {
            this.reset();
            String string7 = this.getLocalMessage("AuthenticationException.ConnectException", new Object[]{this.hostName});
            throw new AuthenticationException("ConnectException", connectException, string7);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.reset();
            String string8 = this.getLocalMessage("AuthenticationException.NoRouteToHostException", new Object[]{this.hostName});
            throw new AuthenticationException("NoRouteToHostException", noRouteToHostException, string8);
        }
        catch (IOException iOException) {
            this.reset();
            String string9 = this.getLocalMessage("AuthenticationException.IOException", new Object[]{this.hostName});
            throw new AuthenticationException("IOException", iOException, string9);
        }
    }

    private void reset() {
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    public void verify() throws AuthenticationException {
        this.openConnection(VERIFY_PREAMBLE, VERIFY_POSTAMBLE);
        if (this.socket == null) {
            return;
        }
        try {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                String string = AuthenticationException.getBundleString("AuthenticationException.Throwable");
                throw new AuthenticationException("General error", iOException, string);
            }
            Object var4_1 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.reset();
            throw throwable;
        }
    }

    public void open() throws AuthenticationException {
        this.openConnection(OPEN_PREAMBLE, OPEN_POSTAMBLE);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String string) {
        this.repository = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    private String getEncodedPasswordNotNull() {
        if (this.encodedPassword == null) {
            return "";
        }
        return this.encodedPassword;
    }

    public void setEncodedPassword(String string) {
        this.encodedPassword = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.socket.close();
            Object var2_1 = null;
            this.reset();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.reset();
            throw throwable;
        }
    }

    public void modifyInputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyInputStream(this.inputStream);
    }

    public void modifyOutputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyOutputStream(this.outputStream);
    }

    private String getLocalMessage(String string, Object[] objectArray) {
        String string2 = AuthenticationException.getBundleString(string);
        if (string2 == null) {
            return null;
        }
        string2 = MessageFormat.format(string2, objectArray);
        return string2;
    }

    public boolean isOpen() {
        return this.socket != null;
    }
}

