/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public final class Logger {
    private static Writer outLog;
    private static Writer inLog;
    private static final String LOG_PROPERTY = "cvsClientLog";
    private static boolean logging;

    public static void setLogging(String string) {
        logging = string != null;
        try {
            if (logging) {
                if (string.equals("system")) {
                    outLog = new BufferedWriter(new OutputStreamWriter(System.err));
                    inLog = new BufferedWriter(new OutputStreamWriter(System.err));
                } else {
                    outLog = new BufferedWriter(new FileWriter(string + ".out"));
                    inLog = new BufferedWriter(new FileWriter(string + ".in"));
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Unable to create log files: " + iOException);
            System.err.println("Logging DISABLED");
            logging = false;
            try {
                if (outLog != null) {
                    outLog.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (inLog != null) {
                    inLog.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
    }

    public static void logInput(String string) {
        if (!logging) {
            return;
        }
        try {
            inLog.write(string);
            inLog.flush();
        }
        catch (IOException iOException) {
            System.err.println("Could not write to log file: " + iOException);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logInput(char c) {
        if (!logging) {
            return;
        }
        try {
            inLog.write(c);
            inLog.flush();
        }
        catch (IOException iOException) {
            System.err.println("Could not write to log file: " + iOException);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logOutput(String string) {
        if (!logging) {
            return;
        }
        try {
            outLog.write(string);
            outLog.flush();
        }
        catch (IOException iOException) {
            System.err.println("Could not write to log file: " + iOException);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    static {
        Logger.setLogging(System.getProperty(LOG_PROPERTY));
    }
}

