/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;

public class BaseCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
DocumentListener,
ActionListener,
SettingsChangeListener {
    public static final String BLOCK_CARET = "block-caret";
    public static final String LINE_CARET = "line-caret";
    public static final String THIN_LINE_CARET = "thin-line-caret";
    private static final boolean debugCaretFocus = Boolean.getBoolean("netbeans.debug.editor.caret.focus");
    protected JTextComponent component;
    Point magicCaretPosition;
    MarkFactory.DrawMark caretMark = new MarkFactory.CaretMark();
    MarkFactory.DrawMark selectionMark = new MarkFactory.DrawMark("caret-layer", null);
    boolean visible;
    boolean blinkVisible;
    boolean selectionVisible;
    protected EventListenerList listenerList = new EventListenerList();
    protected Timer flasher;
    String type;
    boolean italic;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private Action selectWordAction;
    private Action selectLineAction;
    protected ChangeEvent changeEvent;
    private static char[] emptyDotChar = new char[]{' '};
    protected char[] dotChar = emptyDotChar;
    private boolean overwriteMode;
    private BaseDocument listenDoc;
    CaretDG caretDG = new CaretDG();
    protected Font afterCaretFont;
    protected Font beforeCaretFont;
    protected Color textForeColor;
    protected Color textBackColor;
    private transient FocusListener focusListener;
    private transient boolean nextPaintUpdate;
    private transient Rectangle nextPaintScrollRect;
    private transient int nextPaintScrollPolicy;
    static final long serialVersionUID = -9113841520331402768L;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public BaseCaret() {
        Settings.addSettingsChangeListener(this);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent != null && "caret-blink-rate".equals(settingsChangeEvent.getSettingName())) {
            JTextComponent jTextComponent = this.component;
            if (jTextComponent == null) {
                return;
            }
            if (settingsChangeEvent.getKitClass() != Utilities.getKitClass(jTextComponent)) {
                return;
            }
            Object object = settingsChangeEvent.getNewValue();
            if (object instanceof Integer) {
                this.setBlinkRate((Integer)object);
            }
        }
        this.updateType();
    }

    void updateType() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Color color;
            boolean bl;
            String string;
            Class clazz = Utilities.getKitClass(jTextComponent);
            if (this.overwriteMode) {
                string = SettingsUtil.getString(clazz, "caret-type-overwrite-mode", LINE_CARET);
                bl = SettingsUtil.getBoolean(clazz, "caret-italic-overwrite-mode", false);
                color = BaseCaret.getColor(clazz, "caret-color-overwrite-mode", SettingsDefaults.defaultCaretColorOvwerwriteMode);
            } else {
                string = SettingsUtil.getString(clazz, "caret-type-insert-mode", LINE_CARET);
                bl = SettingsUtil.getBoolean(clazz, "caret-italic-insert-mode", false);
                color = BaseCaret.getColor(clazz, "caret-color-insert-mode", SettingsDefaults.defaultCaretColorInsertMode);
            }
            this.type = string;
            this.italic = bl;
            jTextComponent.setCaretColor(color);
            this.dispatchUpdate();
        }
    }

    private static Color getColor(Class clazz, String string, Color color) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof Color ? (Color)object : color;
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.blinkVisible = true;
        this.component.addPropertyChangeListener(this);
        this.focusListener = new FocusHandler(this);
        this.component.addFocusListener(this.focusListener);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        EditorUI editorUI = Utilities.getEditorUI(this.component);
        editorUI.addLayer(new DrawLayerFactory.CaretLayer(), 10000);
        this.caretMark.setEditorUI(editorUI);
        this.selectionMark.setEditorUI(editorUI);
        editorUI.addPropertyChangeListener(this);
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        if (baseDocument != null) {
            this.modelChanged(null, baseDocument);
        }
        if (this.component.hasFocus()) {
            this.focusGained(null);
            if (debugCaretFocus) {
                System.err.println("Component has focus, calling focusGained() on doc=" + this.component.getDocument().getProperty("title"));
            }
        }
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.component = null;
        if (this.flasher != null) {
            this.setBlinkRate(0);
        }
        Utilities.getEditorUI(jTextComponent).removeLayer("caret-layer");
        jTextComponent.removeMouseMotionListener(this);
        jTextComponent.removeMouseListener(this);
        if (this.focusListener != null) {
            jTextComponent.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        jTextComponent.removePropertyChangeListener(this);
        this.modelChanged(this.listenDoc, null);
    }

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        if (baseDocument != null && this.listenDoc == baseDocument) {
            block9: {
                baseDocument.removeDocumentListener(this);
                try {
                    this.caretMark.remove();
                    this.selectionMark.remove();
                }
                catch (InvalidMarkException invalidMarkException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                    invalidMarkException.printStackTrace();
                }
            }
            this.listenDoc = null;
        }
        if (baseDocument2 != null) {
            block10: {
                if (this.listenDoc != null) {
                    this.modelChanged(this.listenDoc, null);
                }
                baseDocument2.addDocumentListener(this);
                this.listenDoc = baseDocument2;
                try {
                    Utilities.insertMark(baseDocument2, this.caretMark, 0);
                    Utilities.insertMark(baseDocument2, this.selectionMark, 0);
                }
                catch (InvalidMarkException invalidMarkException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        invalidMarkException.printStackTrace();
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block10;
                    badLocationException.printStackTrace();
                }
            }
            this.settingsChange(null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BaseCaret.this.updateType();
                }
            });
        }
    }

    public void paint(Graphics graphics) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (this.nextPaintUpdate && editorUI.isFontsInited()) {
            this.nextPaintUpdate = false;
            this.update(this.nextPaintScrollRect, this.nextPaintScrollPolicy);
            this.nextPaintScrollRect = null;
        }
        if (this.visible && this.blinkVisible) {
            this.paintCustomCaret(graphics);
        }
    }

    protected void paintCustomCaret(Graphics graphics) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            if (THIN_LINE_CARET.equals(this.type)) {
                graphics.setColor(jTextComponent.getCaretColor());
                int n = this.x;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    n = (int)((double)n + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.height);
                }
                graphics.drawLine(n, this.y, this.x, this.y + this.height - 1);
            } else if (BLOCK_CARET.equals(this.type)) {
                int n;
                graphics.setColor(jTextComponent.getCaretColor());
                graphics.setFont(this.afterCaretFont);
                if (this.afterCaretFont.isItalic() && this.italic) {
                    this.xPoints[0] = n = (int)((double)this.x + Math.tan(this.afterCaretFont.getItalicAngle()) * (double)this.height);
                    this.yPoints[0] = this.y;
                    this.xPoints[1] = n + this.width;
                    this.yPoints[1] = this.y;
                    this.xPoints[2] = this.x + this.width;
                    this.yPoints[2] = this.y + this.height - 1;
                    this.xPoints[3] = this.x;
                    this.yPoints[3] = this.y + this.height - 1;
                    graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    graphics.fillRect(this.x, this.y, this.width, this.height);
                }
                if (!Character.isWhitespace(this.dotChar[0])) {
                    graphics.setColor(Color.white);
                    n = FontMetricsCache.getFontMetrics(this.afterCaretFont, jTextComponent).getAscent();
                    graphics.drawChars(this.dotChar, 0, 1, this.x, this.y + editorUI.getLineAscent());
                }
            } else {
                graphics.setColor(jTextComponent.getCaretColor());
                int n = 2;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    int n2;
                    this.xPoints[0] = n2 = (int)((double)this.x + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.height);
                    this.yPoints[0] = this.y;
                    this.xPoints[1] = n2 + n;
                    this.yPoints[1] = this.y;
                    this.xPoints[2] = this.x + n;
                    this.yPoints[2] = this.y + this.height - 1;
                    this.xPoints[3] = this.x;
                    this.yPoints[3] = this.y + this.height - 1;
                    graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    graphics.fillRect(this.x, this.y, n, this.height - 1);
                }
            }
        }
    }

    void dispatchUpdate() {
        this.dispatchUpdate(null, 1);
    }

    void dispatchUpdate(final Rectangle rectangle, final int n) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (!editorUI.isFontsInited()) {
            if (rectangle != null) {
                this.nextPaintScrollRect = rectangle;
            }
            this.nextPaintScrollPolicy = n;
            this.nextPaintUpdate = true;
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BaseDocument baseDocument;
                JTextComponent jTextComponent = BaseCaret.this.component;
                if (jTextComponent != null && (baseDocument = Utilities.getDocument(jTextComponent)) != null) {
                    baseDocument.readLock();
                    try {
                        BaseCaret.this.update(rectangle, n);
                        Object var4_3 = null;
                        baseDocument.readUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        baseDocument.readUnlock();
                        throw throwable;
                    }
                }
            }
        });
    }

    protected void update(Rectangle rectangle, int n) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            EditorUI editorUI = baseTextUI.getEditorUI();
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                Rectangle rectangle2;
                block6: {
                    rectangle2 = new Rectangle(this);
                    if (this.italic) {
                        rectangle2.width += rectangle2.height;
                    }
                    int n2 = this.getDot();
                    try {
                        baseTextUI.modelToViewDG(n2, this.caretDG);
                    }
                    catch (BadLocationException badLocationException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                        badLocationException.printStackTrace();
                    }
                }
                this.resetBlink();
                if (rectangle == null || !editorUI.scrollRectToVisibleFragile(rectangle, n)) {
                    rectangle2.add(this);
                    jTextComponent.repaint(rectangle2);
                }
            }
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BaseCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = BaseCaret.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireStateChanged() {
        Utilities.runInEventDispatchThread(new Runnable(){
            static /* synthetic */ Class class$javax$swing$event$ChangeListener;

            public void run() {
                Object[] objectArray = BaseCaret.this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? 3.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                        if (BaseCaret.this.changeEvent == null) {
                            BaseCaret.this.changeEvent = new ChangeEvent(BaseCaret.this);
                        }
                        ((ChangeListener)objectArray[n + 1]).stateChanged(BaseCaret.this.changeEvent);
                    }
                    n -= 2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected void setVisibleImpl(boolean bl) {
        Serializable serializable;
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            serializable = this.flasher;
            if (serializable != null) {
                if (this.visible) {
                    ((Timer)serializable).stop();
                }
                if (bl) {
                    ((Timer)serializable).start();
                } else {
                    ((Timer)serializable).stop();
                }
            }
            this.visible = bl;
        }
        serializable = this.component;
        if (serializable != null) {
            Rectangle rectangle = this;
            if (this.italic) {
                rectangle = new Rectangle(this);
                rectangle.width += rectangle.height;
            }
            ((JComponent)serializable).repaint(rectangle);
        }
    }

    synchronized void resetBlink() {
        Timer timer = this.flasher;
        if (timer != null) {
            timer.stop();
            this.blinkVisible = true;
            if (this.isVisible()) {
                timer.start();
            }
        }
    }

    public void setVisible(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BaseCaret.this.setVisibleImpl(bl);
            }
        });
    }

    public final boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public void setSelectionVisible(boolean bl) {
        block8: {
            if (this.selectionVisible == bl) {
                return;
            }
            JTextComponent jTextComponent = this.component;
            if (jTextComponent != null) {
                this.selectionVisible = bl;
                if (this.selectionVisible) {
                    boolean bl2;
                    int n = this.getDot();
                    int n2 = this.getMark();
                    this.selectionMark.activateLayer = bl2 = n2 < n;
                    this.caretMark.activateLayer = !bl2 && n2 != n;
                } else {
                    this.caretMark.activateLayer = false;
                    this.selectionMark.activateLayer = false;
                }
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                try {
                    baseTextUI.getEditorUI().repaintBlock(this.caretMark.getOffset(), this.selectionMark.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        badLocationException.printStackTrace();
                    }
                }
                catch (InvalidMarkException invalidMarkException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block8;
                    invalidMarkException.printStackTrace();
                }
            }
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public final Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public synchronized void setBlinkRate(int n) {
        if (this.flasher == null && n > 0) {
            this.flasher = new Timer(n, new WeakTimerListener(this));
        }
        if (this.flasher != null) {
            if (n > 0) {
                if (this.flasher.getDelay() != n) {
                    this.flasher.setDelay(n);
                }
            } else {
                this.flasher.stop();
                this.flasher.removeActionListener(this);
                this.flasher = null;
                this.blinkVisible = true;
            }
        }
    }

    public synchronized int getBlinkRate() {
        return this.flasher != null ? this.flasher.getDelay() : 0;
    }

    public int getDot() {
        if (this.component != null) {
            try {
                return this.caretMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getMark() {
        if (this.component != null) {
            if (this.selectionVisible) {
                try {
                    return this.selectionMark.getOffset();
                }
                catch (InvalidMarkException invalidMarkException) {
                }
            } else {
                return this.getDot();
            }
        }
        return 0;
    }

    public void setDot(int n) {
        this.setDot(n, this, 0);
    }

    public void setDot(int n, Rectangle rectangle, int n2) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            this.setSelectionVisible(false);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (baseDocument != null && n >= 0 && n <= baseDocument.getLength()) {
                try {
                    Utilities.moveMark(baseDocument, this.caretMark, n);
                }
                catch (BadLocationException badLocationException) {
                }
                catch (InvalidMarkException invalidMarkException) {
                    // empty catch block
                }
                this.fireStateChanged();
                this.dispatchUpdate(rectangle, n2);
            }
        }
    }

    public void moveDot(int n) {
        this.moveDot(n, this, 1);
    }

    public void moveDot(int n, Rectangle rectangle, int n2) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            block10: {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                try {
                    int n3;
                    int n4 = this.getDot();
                    if (n == n4) {
                        return;
                    }
                    if (this.selectionVisible) {
                        n3 = this.selectionMark.getOffset();
                    } else {
                        Utilities.moveMark(baseDocument, this.selectionMark, n4);
                        n3 = n4;
                    }
                    Utilities.moveMark(baseDocument, this.caretMark, n);
                    if (this.selectionVisible) {
                        boolean bl;
                        this.selectionMark.activateLayer = bl = n3 < n;
                        this.caretMark.activateLayer = !bl && n3 != n;
                        Utilities.getEditorUI(jTextComponent).repaintBlock(n4, n);
                        if (n3 == n) {
                            this.setSelectionVisible(false);
                        }
                    } else {
                        this.setSelectionVisible(true);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (InvalidMarkException invalidMarkException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block10;
                    invalidMarkException.printStackTrace();
                }
            }
            this.fireStateChanged();
            this.dispatchUpdate(rectangle, n2);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseDocument baseDocument = (BaseDocument)this.component.getDocument();
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if ((baseDocumentEvent.isInUndo() || baseDocumentEvent.isInRedo()) && this.component == Utilities.getLastActiveComponent()) {
                this.setDot(documentEvent.getOffset() + documentEvent.getLength());
            } else {
                this.fireStateChanged();
                if (documentEvent.getLength() == 0) {
                    this.updateType();
                    this.setVisible(false);
                    this.setVisible(jTextComponent.isEnabled() && jTextComponent.hasFocus());
                }
                this.dispatchUpdate(jTextComponent.hasFocus() ? this : null, 1);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseDocumentEvent baseDocumentEvent;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (this.selectionVisible && this.getDot() == this.getMark()) {
                this.setSelectionVisible(false);
            }
            if (((baseDocumentEvent = (BaseDocumentEvent)documentEvent).isInUndo() || baseDocumentEvent.isInRedo()) && jTextComponent == Utilities.getLastActiveComponent()) {
                this.setDot(documentEvent.getOffset());
            } else {
                this.fireStateChanged();
                this.dispatchUpdate(jTextComponent.hasFocus() ? this : null, 1);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.dispatchUpdate();
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent;
        if (debugCaretFocus) {
            System.err.println("BaseCaret.focusGained() in doc=" + this.component.getDocument().getProperty("title"));
        }
        if ((jTextComponent = this.component) != null) {
            this.updateType();
            this.setVisible(jTextComponent.isEnabled());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (debugCaretFocus) {
            System.err.println("BaseCaret.focusLost() in doc=" + this.component.getDocument().getProperty("title"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window window;
                JTextComponent jTextComponent = BaseCaret.this.component;
                if (jTextComponent != null && (window = SwingUtilities.windowForComponent(jTextComponent)) != null && window.getFocusOwner() == jTextComponent) {
                    return;
                }
                BaseCaret.this.setVisible(false);
            }
        });
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.getClickCount() == 2) {
                if (this.selectWordAction == null) {
                    BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    this.selectWordAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-word");
                }
                this.selectWordAction.actionPerformed(null);
            } else if (mouseEvent.getClickCount() == 3) {
                if (this.selectLineAction == null) {
                    BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    this.selectLineAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-line");
                }
                this.selectLineAction.actionPerformed(null);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Utilities.getEditorUI(jTextComponent).getWordMatch().clear();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiers() & 0xC) == 0 || !this.isSelectionVisible()) {
                int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0) {
                    if ((mouseEvent.getModifiers() & 1) != 0) {
                        this.moveDot(n);
                    } else {
                        this.setDot(n);
                    }
                    this.setMagicCaretPosition(null);
                }
                if (jTextComponent.isEnabled()) {
                    jTextComponent.requestFocus();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && jTextComponent != null) {
            int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                n = 0;
            }
            if (n >= 0 && (mouseEvent.getModifiers() & 1) == 0) {
                this.moveDot(n);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument = propertyChangeEvent.getOldValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getOldValue() : null;
            BaseDocument baseDocument2 = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            this.modelChanged(baseDocument, baseDocument2);
        } else if ("overwriteMode".equals(string)) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.overwriteMode = bl != null ? bl : false;
            this.updateType();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            this.blinkVisible = !this.blinkVisible;
            Rectangle rectangle = this;
            if (this.italic) {
                rectangle = new Rectangle(this);
                rectangle.width += rectangle.height;
            }
            jTextComponent.repaint(rectangle);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private transient FocusListener fl;

        FocusHandler(FocusListener focusListener) {
            this.fl = focusListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.fl.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.fl.focusLost(focusEvent);
        }
    }

    final class CaretDG
    extends DrawGraphics.SimpleDG {
        Font previousFont;

        CaretDG() {
        }

        public void setFont(Font font) {
            this.previousFont = this.getFont();
            super.setFont(font);
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            JTextComponent jTextComponent = BaseCaret.this.component;
            if (jTextComponent != null) {
                BaseCaret.this.beforeCaretFont = n == drawContext.getFragmentOffset() ? this.previousFont : drawContext.getFont();
                BaseCaret.this.afterCaretFont = drawContext.getFont();
                BaseCaret.this.x = n2;
                BaseCaret.this.y = this.getY();
                BaseCaret.this.width = n3;
                BaseCaret.this.height = Utilities.getEditorUI(jTextComponent).getLineHeight();
                BaseCaret.this.textForeColor = drawContext.getForeColor();
                BaseCaret.this.textBackColor = drawContext.getBackColor();
                BaseCaret.this.dotChar[0] = c;
            }
            return false;
        }
    }
}

