/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.AdjustFinder;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Bookmarks;
import org.netbeans.editor.DocOp;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.DrawLayerList;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.LeafElement;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.Utilities;

public class BaseDocument
extends AbstractDocument
implements SettingsChangeListener {
    public static final String ID_PROP = "id";
    public static final String READ_LINE_SEPARATOR_PROP = "__EndOfLine__";
    public static final String WRITE_LINE_SEPARATOR_PROP = "write-line-separator";
    public static final String FILE_NAME_PROP = "file-name";
    public static final String WRAP_SEARCH_MARK_PROP = "wrap-search-mark";
    public static final String UNDO_MANAGER_PROP = "undo-manager";
    public static final String KIT_CLASS_PROP = "kit-class";
    public static final String STRING_FINDER_PROP = "string-finder";
    public static final String STRING_BWD_FINDER_PROP = "string-bwd-finder";
    public static final String BLOCKS_FINDER_PROP = "blocks-finder";
    public static final String LINE_LIMIT_PROP = "line-limit";
    public static final String LINE_BATCH_SIZE = "line-batch-size";
    public static final String LS_CR = "\r";
    public static final String LS_LF = "\n";
    public static final String LS_CRLF = "\r\n";
    private static final int MAX_READ_THREADS = 10;
    private static final String WRITE_LOCK_MISSING = "extWriteUnlock() without extWriteLock()";
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.document");
    private static final boolean debugStack = Boolean.getBoolean("netbeans.debug.editor.document.stack");
    DocOp op;
    private int tabSize = SettingsDefaults.defaultTabSize;
    private Integer shiftWidth;
    private int writeDeep;
    private int atomicDepth;
    protected boolean inited;
    protected boolean modified;
    protected EventListenerList listenerList = new EventListenerList();
    PropertyChangeListener findSupportListener;
    protected BaseElement defaultRootElem;
    private SyntaxSupport syntaxSupport;
    private DrawLayerList drawLayerList = new DrawLayerList();
    private MarkChain bookmarkChain;
    boolean undoMergeReset;
    Class kitClass;
    private CompoundEdit atomicEdits;
    private Acceptor identifierAcceptor;
    private Acceptor whitespaceAcceptor;
    private ArrayList syntaxList = new ArrayList();
    private ArrayList posList = new ArrayList();
    private ArrayList posFreeList = new ArrayList();
    protected LineRootElement lineRootElement;
    private AbstractDocument.LeafElement composedTextElement;
    UndoableEdit lastModifyUndoEdit;
    private Annotations annotations;
    private Bookmarks bookmarks;

    public BaseDocument(Class clazz, boolean bl) {
        this(clazz, bl, new DocOp());
    }

    private BaseDocument(Class clazz, boolean bl, DocOp docOp) {
        super(docOp);
        this.op = docOp;
        this.kitClass = clazz;
        this.setDocumentProperties(new LazyPropertyMap(this.getDocumentProperties()));
        this.settingsChange(null);
        Settings.addSettingsChangeListener(this);
        docOp.setDocument(this);
        this.putProperty(READ_LINE_SEPARATOR_PROP, Analyzer.getPlatformLS());
        this.bookmarkChain = new MarkChain(this, "bookmark-layer");
        this.addLayer(new DrawLayerFactory.SyntaxLayer(), 1000);
        this.addLayer(new DrawLayerFactory.HighlightSearchLayer(), 9000);
        this.addLayer(new DrawLayerFactory.BookmarkLayer(), 2000);
        BaseKit baseKit = BaseKit.getKit(clazz);
        if (baseKit != null) {
            baseKit.initDocument(this);
        }
        if (bl) {
            Registry.addDocument(this);
        }
        this.findSupportListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BaseDocument.this.findSupportChange(propertyChangeEvent);
            }
        };
        FindSupport.getFindSupport().addPropertyChangeListener(this.findSupportListener);
        this.findSupportChange(null);
    }

    private void findSupportChange(PropertyChangeEvent propertyChangeEvent) {
        this.putProperty(STRING_FINDER_PROP, null);
        this.putProperty(STRING_BWD_FINDER_PROP, null);
        this.putProperty(BLOCKS_FINDER_PROP, null);
        DrawLayerFactory.HighlightSearchLayer highlightSearchLayer = (DrawLayerFactory.HighlightSearchLayer)this.findLayer("highlight-search-layer");
        Boolean bl = (Boolean)FindSupport.getFindSupport().getPropertyNoInit("find-highlight-search");
        highlightSearchLayer.setEnabled(bl != null ? bl : false);
        this.fireChangedUpdate(this.createDocumentEvent(0, this.getLength(), DocumentEvent.EventType.CHANGE));
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Object object;
        String string;
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (string == null || "tab-size".equals(string)) {
            this.tabSize = SettingsUtil.getPositiveInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if ((string == null || "indent-shift-width".equals(string)) && (object = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)object;
        }
        if (string == null || "read-buffer-size".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "read-buffer-size", SettingsDefaults.defaultReadBufferSize);
            this.putProperty("read-buffer-size", new Integer(n));
        }
        if (string == null || "write-buffer-size".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "write-buffer-size", SettingsDefaults.defaultWriteBufferSize);
            this.putProperty("write-buffer-size", new Integer(n));
        }
        if (string == null || "mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "mark-distance", SettingsDefaults.defaultMarkDistance);
            this.putProperty("mark-distance", new Integer(n));
        }
        if (string == null || "max-mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "max-mark-distance", SettingsDefaults.defaultMaxMarkDistance);
            this.putProperty("max-mark-distance", new Integer(n));
        }
        if (string == null || "min-mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "min-mark-distance", SettingsDefaults.defaultMinMarkDistance);
            this.putProperty("min-mark-distance", new Integer(n));
        }
        if (string == null || "read-mark-distance".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "read-mark-distance", SettingsDefaults.defaultReadMarkDistance);
            this.putProperty("read-mark-distance", new Integer(n));
        }
        if (string == null || "syntax-update-batch-size".equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, "syntax-update-batch-size", SettingsDefaults.defaultSyntaxUpdateBatchSize);
            this.putProperty("syntax-update-batch-size", new Integer(n));
        }
        if (string == null || LINE_BATCH_SIZE.equals(string)) {
            int n = SettingsUtil.getPositiveInteger(this.kitClass, LINE_BATCH_SIZE, SettingsDefaults.defaultLineBatchSize);
            this.putProperty(LINE_BATCH_SIZE, new Integer(n));
        }
        if (string == null || "identifier-acceptor".equals(string)) {
            this.identifierAcceptor = SettingsUtil.getAcceptor(this.kitClass, "identifier-acceptor", AcceptorFactory.LETTER_DIGIT);
        }
        if (string == null || "whitespace-acceptor".equals(string)) {
            this.whitespaceAcceptor = SettingsUtil.getAcceptor(this.kitClass, "whitespace-acceptor", AcceptorFactory.WHITESPACE);
        }
        boolean bl = SettingsUtil.getBoolean(this.kitClass, "word-move-newline-stop", true);
        if (string == null || "next-word-finder".equals(string)) {
            this.putProperty("next-word-finder", SettingsUtil.getValue(this.kitClass, "next-word-finder", new FinderFactory.NextWordFwdFinder(this, bl, false)));
        }
        if (string == null || "previous-word-finder".equals(string)) {
            this.putProperty("previous-word-finder", SettingsUtil.getValue(this.kitClass, "previous-word-finder", new FinderFactory.PreviousWordBwdFinder(this, bl, false)));
        }
    }

    Syntax getFreeSyntax() {
        ArrayList arrayList = this.syntaxList;
        synchronized (arrayList) {
            int n = this.syntaxList.size();
            Syntax syntax = n > 0 ? (Syntax)this.syntaxList.remove(n - 1) : BaseKit.getKit(this.kitClass).createSyntax(this);
            return syntax;
        }
    }

    void releaseSyntax(Syntax syntax) {
        ArrayList arrayList = this.syntaxList;
        synchronized (arrayList) {
            this.syntaxList.add(syntax);
        }
    }

    public Formatter getFormatter() {
        return Formatter.getFormatter(this.kitClass);
    }

    public SyntaxSupport getSyntaxSupport() {
        if (this.syntaxSupport == null) {
            this.syntaxSupport = BaseKit.getKit(this.kitClass).createSyntaxSupport(this);
        }
        return this.syntaxSupport;
    }

    /*
     * Unable to fully structure code
     */
    public int processText(TextBatchProcessor var1_1, int var2_2, int var3_3) throws BadLocationException {
        block4: {
            if (var3_3 == -1) {
                var3_3 = this.getLength();
            }
            var4_4 = (Integer)this.getProperty("line-batch-size");
            var5_5 = var2_2;
            var6_6 = -1;
            if (var2_2 >= var3_3) ** GOTO lbl19
            while (var6_6 < 0 && var5_5 < var3_3) {
                var7_7 = Math.min(Utilities.getRowStart(this, var5_5, var4_4), var3_3);
                if (var7_7 == -1) {
                    var7_7 = var3_3;
                }
                var6_6 = var1_1.processTextBatch(this, var5_5, var7_7, var7_7 == var3_3);
                var4_4 *= 2;
                var5_5 = var7_7;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var6_6 = var1_1.processTextBatch(this, var5_5, var7_8, (var7_8 = Math.max(Utilities.getRowStart(this, var5_5, -var4_4), var3_3)) == var3_3);
                var4_4 *= 2;
                var5_5 = var7_8;
lbl19:
                // 2 sources

                ** while (var6_6 < 0 && var5_5 > var3_3)
            }
        }
        return var6_6;
    }

    public boolean isIdentifierPart(char c) {
        return this.identifierAcceptor.accept(c);
    }

    public boolean isWhitespace(char c) {
        return this.whitespaceAcceptor.accept(c);
    }

    int storePosition(int n) throws BadLocationException {
        int n2;
        Mark mark = this.op.insertMark(n, false);
        if (this.posFreeList.size() > 0) {
            n2 = (Integer)this.posFreeList.remove(this.posFreeList.size() - 1);
            this.posList.set(n2, mark);
        } else {
            n2 = this.posList.size();
            this.posList.add(mark);
        }
        return n2;
    }

    int getStoredPosition(int n) {
        if (n < 0 || n >= this.posList.size()) {
            return -1;
        }
        try {
            return ((Mark)this.posList.get(n)).getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return -1;
        }
    }

    void removeStoredPosition(int n) {
        if (n >= 0 || n < this.posList.size()) {
            Mark mark = (Mark)this.posList.get(n);
            this.posList.set(n, null);
            this.posFreeList.add(new Integer(n));
            try {
                mark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (n < 0 || n > this.getLength()) {
            throw new BadLocationException("Wrong insert position", n);
        }
        string = Analyzer.convertLSToLF(string);
        this.extWriteLock();
        try {
            boolean bl;
            this.preInsertCheck(n, string, attributeSet);
            UndoableEdit undoableEdit = this.op.insertString(n, string);
            if (debug) {
                System.err.println("BaseDocument.insertString(): doc=" + this + (this.modified ? "" : " - first modification") + ", offset=" + n + ", text='" + string + "'");
            }
            if (debugStack) {
                Thread.dumpStack();
            }
            BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(n, string.length(), DocumentEvent.EventType.INSERT);
            if (undoableEdit != null) {
                baseDocumentEvent.addEdit(undoableEdit);
                this.lastModifyUndoEdit = undoableEdit;
            }
            this.modified = true;
            if (this.atomicDepth > 0) {
                if (this.atomicEdits == null) {
                    this.atomicEdits = new AtomicCompoundEdit();
                }
                this.atomicEdits.addEdit(baseDocumentEvent);
            }
            this.insertUpdate(baseDocumentEvent, attributeSet);
            baseDocumentEvent.end();
            this.fireInsertUpdate(baseDocumentEvent);
            boolean bl2 = bl = attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
            if (this.atomicDepth == 0 && !bl) {
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, baseDocumentEvent));
            }
            Object var8_7 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.extWriteUnlock();
            throw throwable;
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (n2 > 0) {
            this.extWriteLock();
            try {
                int n3 = this.getLength();
                if (n < 0 || n > n3) {
                    throw new BadLocationException("Wrong remove position", n);
                }
                if (n + n2 > n3) {
                    throw new BadLocationException("End offset of removed text " + (n + n2) + " > getLength()=" + n3, n + n2);
                }
                this.preRemoveCheck(n, n2);
                BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
                this.removeUpdate(baseDocumentEvent);
                UndoableEdit undoableEdit = this.op.remove(n, n2);
                if (undoableEdit != null) {
                    baseDocumentEvent.addEdit(undoableEdit);
                    this.lastModifyUndoEdit = undoableEdit;
                }
                if (debug) {
                    System.err.println("BaseDocument.remove(): doc=" + this + ", offset=" + n + ", len=" + n2);
                }
                if (debugStack) {
                    Thread.dumpStack();
                }
                if (this.atomicDepth > 0) {
                    if (this.atomicEdits == null) {
                        this.atomicEdits = new AtomicCompoundEdit();
                    }
                    this.atomicEdits.addEdit(baseDocumentEvent);
                }
                this.postRemoveUpdate(baseDocumentEvent);
                baseDocumentEvent.end();
                this.fireRemoveUpdate(baseDocumentEvent);
                if (this.atomicDepth == 0) {
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, baseDocumentEvent));
                }
                Object var7_6 = null;
                this.extWriteUnlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.extWriteUnlock();
                throw throwable;
            }
        }
    }

    protected void preInsertCheck(int n, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    protected void preRemoveCheck(int n, int n2) throws BadLocationException {
    }

    public String getText(int[] nArray) throws BadLocationException {
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public char[] getChars(int n, int n2) throws BadLocationException {
        return this.op.getChars(n, n2);
    }

    public char[] getChars(int[] nArray) throws BadLocationException {
        return this.getChars(nArray[0], nArray[1] - nArray[0]);
    }

    public void getChars(int n, char[] cArray, int n2, int n3) throws BadLocationException {
        this.op.getChars(n, cArray, n2, n3);
    }

    public int find(Finder finder, int n, int n2) throws BadLocationException {
        if (finder instanceof AdjustFinder) {
            boolean bl;
            int n3 = this.getLength();
            if (n2 == -1) {
                n2 = n3;
            }
            if (n == -1) {
                n = n3;
            }
            if (n == n2) {
                finder.reset();
                return -1;
            }
            boolean bl2 = n < n2;
            n = ((AdjustFinder)finder).adjustStartPos(this, n);
            n2 = ((AdjustFinder)finder).adjustLimitPos(this, n2);
            boolean bl3 = bl2 ? n >= n2 : (bl = n <= n2);
            if (bl) {
                finder.reset();
                return -1;
            }
        }
        return this.op.find(finder, n, n2);
    }

    public void repaintBlock(int n, int n2) {
        BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(n, n2 - n, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(baseDocumentEvent);
    }

    public void print(PrintContainer printContainer) {
        this.readLock();
        try {
            try {
                EditorUI editorUI = BaseKit.getKit(this.kitClass).createPrintEditorUI(this);
                DrawGraphics.PrintDG printDG = new DrawGraphics.PrintDG(printContainer);
                DrawEngine.getDrawEngine().draw(printDG, editorUI, 0, this.getLength(), 0, 0, Integer.MAX_VALUE);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                Object var5_6 = null;
                this.readUnlock();
            }
            Object var5_5 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public Position createPosition(int n, Position.Bias bias) throws BadLocationException {
        return this.op.createPosition(n, bias);
    }

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement()};
        return elementArray;
    }

    public Element getDefaultRootElement() {
        if (this.defaultRootElem == null) {
            this.defaultRootElem = new LeafElement(this, null, null, 0, this.getLength(), false, false);
        }
        return this.defaultRootElem;
    }

    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
            Object var3_2 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public void runAtomic(Runnable runnable) {
        this.runAtomicAsUser(runnable);
    }

    public void runAtomicAsUser(Runnable runnable) {
        Object v1;
        block7: {
            boolean bl = false;
            this.atomicLock();
            try {
                runnable.run();
                bl = true;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                try {
                    if (!bl) {
                        this.breakAtomicLock();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_8 = v0;
                this.atomicUnlock();
                throw throwable;
            }
            try {
                if (!bl) {
                    this.breakAtomicLock();
                }
                v1 = null;
                break block7;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_7 = v1;
        this.atomicUnlock();
    }

    public void read(Reader reader, int n) throws IOException, BadLocationException {
        this.extWriteLock();
        try {
            if (n < 0 || n > this.getLength()) {
                throw new BadLocationException("BaseDocument.read()", n);
            }
            if (this.inited || this.modified) {
                Analyzer.read(this, reader, n);
            } else {
                Analyzer.initialRead(this, reader, true);
                BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(0, 0, DocumentEvent.EventType.INSERT);
                baseDocumentEvent.end();
                this.fireInsertUpdate(baseDocumentEvent);
                this.inited = true;
            }
            Object var5_4 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.extWriteUnlock();
            throw throwable;
        }
    }

    public void write(Writer writer, int n, int n2) throws IOException, BadLocationException {
        this.readLock();
        try {
            if (n < 0 || n + n2 > this.getLength()) {
                throw new BadLocationException("BaseDocument.write()", n);
            }
            Analyzer.write(this, writer, n, n2);
            writer.flush();
            Object var5_4 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public void invalidateSyntaxMarks() {
        this.extWriteLock();
        try {
            this.op.invalidateSyntaxMarks();
            this.repaintBlock(0, this.getLength());
            Object var2_1 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.extWriteUnlock();
            throw throwable;
        }
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public int getShiftWidth() {
        if (this.shiftWidth != null) {
            return this.shiftWidth;
        }
        return this.getFormatter().getSpacesPerTab();
    }

    public final Class getKitClass() {
        return this.kitClass;
    }

    public void resetUndoMerge() {
        this.undoMergeReset = true;
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        super.fireChangedUpdate(documentEvent);
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        super.fireInsertUpdate(documentEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        super.fireRemoveUpdate(documentEvent);
    }

    public final synchronized void extWriteLock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            super.writeLock();
        } else {
            ++this.writeDeep;
        }
    }

    public final synchronized void extWriteUnlock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            throw new RuntimeException(WRITE_LOCK_MISSING);
        }
        if (this.writeDeep == 0) {
            super.writeUnlock();
        } else {
            --this.writeDeep;
        }
    }

    public final synchronized void atomicLock() {
        this.extWriteLock();
        ++this.atomicDepth;
    }

    public final synchronized void atomicUnlock() {
        this.extWriteUnlock();
        if (this.atomicDepth == 0) {
            return;
        }
        if (--this.atomicDepth == 0 && this.atomicEdits != null) {
            this.atomicEdits.end();
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, this.atomicEdits));
            this.atomicEdits = null;
        }
    }

    public final boolean isAtomicLock() {
        return this.atomicDepth > 0;
    }

    public final void breakAtomicLock() {
        this.atomicDepth = 0;
        if (this.atomicEdits != null) {
            this.atomicEdits.end();
            this.atomicEdits.undo();
            this.atomicEdits = null;
        }
    }

    protected final int getAtomicDepth() {
        return this.atomicDepth;
    }

    protected BaseDocumentEvent createDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
        return new BaseDocumentEvent(this, n, n2, eventType);
    }

    public boolean isModified() {
        return this.modified;
    }

    public DrawLayer findLayer(String string) {
        return this.drawLayerList.findLayer(string);
    }

    public boolean addLayer(DrawLayer drawLayer, int n) {
        if (this.drawLayerList.add(drawLayer, n)) {
            BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(0, 0, DocumentEvent.EventType.CHANGE);
            baseDocumentEvent.addEdit(new BaseDocumentEvent.DrawLayerChange(drawLayer.getName(), n));
            this.fireChangedUpdate(baseDocumentEvent);
            return true;
        }
        return false;
    }

    final DrawLayerList getDrawLayerList() {
        return this.drawLayerList;
    }

    public boolean toggleBookmark(int n) throws BadLocationException {
        n = Utilities.getRowStart(this, n);
        boolean bl = this.bookmarkChain.toggleMark(n);
        BaseDocumentEvent baseDocumentEvent = this.createDocumentEvent(n, 0, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(baseDocumentEvent);
        return bl;
    }

    public int getNextBookmark(int n, boolean bl) throws BadLocationException {
        try {
            n = Utilities.getRowStart(this, n);
            int n2 = this.bookmarkChain.compareMark(n);
            MarkFactory.ChainDrawMark chainDrawMark = this.bookmarkChain.getCurMark();
            if (n2 <= 0) {
                if (chainDrawMark != null) {
                    if (chainDrawMark.next != null) {
                        return chainDrawMark.next.getOffset();
                    }
                    return bl && this.bookmarkChain.chain != null ? this.bookmarkChain.chain.getOffset() : -1;
                }
                return -1;
            }
            return chainDrawMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                invalidMarkException.printStackTrace();
            }
            return 0;
        }
    }

    private LineRootElement getLineRootElement() {
        if (this.lineRootElement == null) {
            this.lineRootElement = new LineRootElement();
        }
        return this.lineRootElement;
    }

    public Element getParagraphElement(int n) {
        return this.getLineRootElement().getElement(this.getLineRootElement().getElementIndex(n));
    }

    public synchronized Annotations getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new Annotations(this);
        }
        return this.annotations;
    }

    public synchronized Bookmarks getBookmarks() {
        if (this.bookmarks == null) {
            this.bookmarks = new Bookmarks();
        }
        return this.bookmarks;
    }

    public String toString() {
        return super.toString() + ", kitClass=" + this.getKitClass() + ", docLen=" + this.getLength();
    }

    public String toStringDetail() {
        return this.toString();
    }

    private class LazyPropertyMap
    extends Hashtable {
        LazyPropertyMap(Dictionary dictionary) {
            super(5);
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.put(k, dictionary.get(k));
            }
        }

        public Object get(Object object) {
            Object object2 = super.get(object);
            if (object2 instanceof PropertyEvaluator) {
                object2 = ((PropertyEvaluator)object2).getValue();
            }
            return object2;
        }
    }

    public static interface PropertyEvaluator {
        public Object getValue();
    }

    class AtomicCompoundEdit
    extends CompoundEdit {
        AtomicCompoundEdit() {
        }

        public void undo() throws CannotUndoException {
            BaseDocument.this.extWriteLock();
            try {
                super.undo();
                Object var2_1 = null;
                BaseDocument.this.extWriteUnlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                BaseDocument.this.extWriteUnlock();
                throw throwable;
            }
        }

        public void redo() throws CannotRedoException {
            BaseDocument.this.extWriteLock();
            try {
                super.redo();
                Object var2_1 = null;
                BaseDocument.this.extWriteUnlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                BaseDocument.this.extWriteUnlock();
                throw throwable;
            }
        }
    }

    class LineElement
    implements Element {
        MarkFactory.LineMark startMark;

        LineElement(MarkFactory.LineMark lineMark) throws BadLocationException {
            this.startMark = lineMark;
        }

        public Document getDocument() {
            return BaseDocument.this;
        }

        public int getStartOffset() {
            try {
                return this.startMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                return 0;
            }
        }

        public int getEndOffset() {
            try {
                return BaseDocument.this.op.getEOLNL(this.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        public Element getParentElement() {
            return BaseDocument.this.lineRootElement;
        }

        public String getName() {
            return "line-element";
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public int getElementIndex(int n) {
            return 0;
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int n) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        public void finalize() throws Throwable {
            try {
                this.startMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            super.finalize();
        }

        public String toString() {
            return "getStartOffset()=" + this.getStartOffset() + ", getEndOffset()=" + this.getEndOffset() + ", getParentElement()=" + this.getParentElement();
        }
    }

    class LineRootElement
    implements Element {
        static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$LineMark;

        LineRootElement() {
        }

        public Document getDocument() {
            return BaseDocument.this;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "line-elements-root";
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return BaseDocument.this.getLength();
        }

        public int getElementIndex(int n) {
            try {
                return Utilities.getLineOffset(BaseDocument.this, n);
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        public int getElementCount() {
            return Utilities.getRowCount(BaseDocument.this);
        }

        public Element getElement(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("Line index=" + n + " must be >= 0");
            }
            try {
                LineElement lineElement;
                block9: {
                    int n2 = Utilities.getRowStartFromLineOffset(BaseDocument.this, n);
                    if (n2 < 0) {
                        return this.getElement(Utilities.getRowCount(BaseDocument.this) - 1);
                    }
                    lineElement = null;
                    MarkFactory.LineMark lineMark = (MarkFactory.LineMark)BaseDocument.this.op.getOffsetMark(n2, class$org$netbeans$editor$MarkFactory$LineMark == null ? (class$org$netbeans$editor$MarkFactory$LineMark = LineRootElement.class$("org.netbeans.editor.MarkFactory$LineMark")) : class$org$netbeans$editor$MarkFactory$LineMark);
                    if (lineMark != null) {
                        lineElement = lineMark.lineElemRef;
                    }
                    if (lineElement == null && lineMark == null) {
                        lineMark = new MarkFactory.LineMark();
                        lineMark.lineElemRef = lineElement = new LineElement(lineMark);
                        try {
                            BaseDocument.this.op.insertMark(lineMark, n2);
                        }
                        catch (InvalidMarkException invalidMarkException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                            invalidMarkException.printStackTrace();
                        }
                    }
                }
                return lineElement;
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    badLocationException.printStackTrace();
                }
                return null;
            }
        }

        public boolean isLeaf() {
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

