/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.DocCacheSupport;
import org.netbeans.editor.Finder;

class DocCache {
    private static final int MIN_FRAGMENT_BACK_OVERLAP_LEN = 256;
    private DocCacheSupport support;
    private Fragment[] frags;
    private Fragment defFrag;
    private boolean directMode;
    private int docLenDelta = 0;
    public int statRead = 0;
    public int statInsert = 0;
    public int statRemove = 0;
    public int statReadFragCnt = 0;
    public int statWriteFragCnt = 0;
    public int statOverlapCnt = 0;
    public int statBackOverlapCnt = 0;
    public int statFragSwitchCnt = 0;
    public int statFragSetEmpty = 0;

    public DocCache(DocCacheSupport docCacheSupport, int n, boolean bl) {
        this.support = docCacheSupport;
        if (bl && !docCacheSupport.supportsDirectMode()) {
            bl = false;
        }
        this.directMode = bl;
        if (!bl) {
            this.defFrag = this.addFragment(n);
        }
    }

    void initCacheContent(char[] cArray, int n, int n2) {
        if (this.directMode) {
            return;
        }
        if (cArray != null) {
            this.defFrag.origLen = this.defFrag.fragLen = Math.min(this.defFrag.buffer.length, n2 - n);
            System.arraycopy(cArray, n, this.defFrag.buffer, 0, this.defFrag.fragLen);
            this.defFrag.startPos = 0;
        }
    }

    public synchronized Fragment addFragment(int n) {
        if (this.directMode) {
            return null;
        }
        Fragment fragment = new Fragment(n);
        if (this.frags != null) {
            Fragment[] fragmentArray = new Fragment[this.frags.length + 1];
            System.arraycopy(this.frags, 0, fragmentArray, 0, this.frags.length);
            fragmentArray[this.frags.length] = fragment;
            this.frags = fragmentArray;
        } else {
            this.frags = new Fragment[1];
            this.frags[0] = fragment;
        }
        return fragment;
    }

    public synchronized void flush() {
        if (this.directMode) {
            return;
        }
        int n = 0;
        while (n < this.frags.length) {
            if (this.frags[n].valid) {
                this.frags[n].write();
            }
            ++n;
        }
    }

    private void readFrag(Fragment fragment, int n) {
        if (fragment.modified) {
            fragment.write();
        }
        int n2 = 0;
        int n3 = this.getDocLenImpl();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.frags.length) {
            Fragment fragment2 = this.frags[n5];
            if (fragment2.valid && fragment2 != fragment) {
                if (fragment2.startPos > n) {
                    n3 = fragment2.startPos;
                    break;
                }
                n4 += fragment2.origLen - fragment2.fragLen;
                n2 = fragment2.startPos + fragment2.fragLen;
            }
            ++n5;
        }
        n = Math.max(n - fragment.buffer.length / 2, n2);
        int n6 = Math.min(n3 - n, fragment.buffer.length);
        fragment.read(n, n6, n4);
        if (n5 == this.frags.length || this.frags[n5] != fragment && (n5 == 0 || this.frags[n5 - 1] != fragment)) {
            ++this.statFragSwitchCnt;
            int n7 = 0;
            while (n7 < this.frags.length) {
                if (this.frags[n7] == fragment) break;
                ++n7;
            }
            if (n7 < n5) {
                int n8 = n7 + 1;
                while (n8 < n5) {
                    this.frags[n8 - 1] = this.frags[n8];
                    ++n8;
                }
                this.frags[n5 - 1] = fragment;
            } else {
                int n9 = n7;
                while (n9 > n5) {
                    this.frags[n9] = this.frags[n9 - 1];
                    --n9;
                }
                this.frags[n5] = fragment;
            }
        }
        fragment.valid = true;
    }

    private Fragment getFrag(int n, Fragment fragment, boolean bl) {
        Fragment fragment2;
        int n2 = 0;
        while (n2 < this.frags.length) {
            fragment2 = this.frags[n2];
            if (fragment2.valid) {
                if (bl) {
                    if (fragment2.isIn(n)) {
                        if (n == fragment2.startPos + fragment2.fragLen) {
                            ++n2;
                            while (n2 < this.frags.length) {
                                if (this.frags[n2].valid && this.frags[n2].startPos == n) {
                                    fragment2 = this.frags[n2];
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (fragment2.modified && fragment2.lastMod == fragment2.buffer.length) {
                            this.readFrag(fragment2, n);
                        }
                        return fragment2;
                    }
                } else if (fragment2.isInside(n)) {
                    return fragment2;
                }
            }
            ++n2;
        }
        if (this.getDocLenImpl() == 0) {
            int n3 = 0;
            while (n3 < this.frags.length) {
                fragment2 = this.frags[n3];
                if (fragment2.valid) {
                    return fragment2;
                }
                ++n3;
            }
            this.defFrag.setEmptyValid();
            return this.defFrag;
        }
        fragment2 = fragment != null ? (fragment.actFrag = fragment) : this.defFrag;
        this.readFrag(fragment2, n);
        return fragment2;
    }

    private void updateStartPos(Fragment fragment, int n, int n2) {
        int n3 = this.frags.length - 1;
        while (n3 >= 0) {
            Fragment fragment2 = this.frags[n3];
            if (fragment2.valid) {
                if (fragment2.startPos < n) break;
                if (fragment2 != fragment) {
                    fragment2.startPos += n2;
                }
            }
            --n3;
        }
    }

    public synchronized void insert(int n, char[] cArray, Fragment fragment) throws BadLocationException {
        int n2;
        if (n < 0 || n > this.getDocLenImpl()) {
            this.throwPosException(n);
        }
        if ((n2 = cArray.length) == 0) {
            return;
        }
        if (this.directMode) {
            this.support.insert(n, cArray, 0, n2);
            return;
        }
        Fragment fragment2 = fragment == null ? this.defFrag : fragment.actFrag;
        boolean bl = false;
        if (fragment2.isInside(n) && (!fragment2.modified || fragment2.lastMod < fragment2.buffer.length)) {
            bl = true;
        }
        while (n2 > 0) {
            if (bl) {
                bl = false;
            } else {
                fragment2 = this.getFrag(n, fragment, true);
            }
            int n3 = n - fragment2.startPos;
            if (!fragment2.modified) {
                fragment2.modified = true;
                fragment2.firstMod = fragment2.lastMod = n3;
            }
            int n4 = fragment2.buffer.length - Math.max(n3, fragment2.lastMod);
            int n5 = Math.min(fragment2.fragLen - n3, fragment2.buffer.length - (n3 + (n4 = Math.min(n4, n2))));
            if (n5 > 0) {
                System.arraycopy(fragment2.buffer, n3, fragment2.buffer, n3 + n4, n5);
            }
            System.arraycopy(cArray, cArray.length - n2, fragment2.buffer, n3, n4);
            fragment2.updatePos(n3, n4);
            this.docLenDelta += n4;
            if (this.frags.length > 1) {
                this.updateStartPos(fragment2, n, n4);
            }
            n2 -= n4;
            n += n4;
        }
        if (fragment != null) {
            fragment.actFrag = fragment2;
        }
        this.statInsert += cArray.length;
    }

    public synchronized void insertString(int n, String string, Fragment fragment) throws BadLocationException {
        int n2;
        int n3;
        if (n < 0 || n > this.getDocLenImpl()) {
            this.throwPosException(n);
        }
        if ((n3 = (n2 = string.length())) == 0) {
            return;
        }
        if (this.directMode) {
            this.support.insertString(n, string, 0, n3);
            return;
        }
        Fragment fragment2 = fragment == null ? this.defFrag : fragment.actFrag;
        boolean bl = false;
        if (fragment2.isInside(n) && (!fragment2.modified || fragment2.lastMod < fragment2.buffer.length)) {
            bl = true;
        }
        while (n3 > 0) {
            if (bl) {
                bl = false;
            } else {
                fragment2 = this.getFrag(n, fragment, true);
            }
            int n4 = n - fragment2.startPos;
            if (!fragment2.modified) {
                fragment2.modified = true;
                fragment2.firstMod = fragment2.lastMod = n4;
            }
            int n5 = fragment2.buffer.length - Math.max(n4, fragment2.lastMod);
            int n6 = Math.min(fragment2.fragLen - n4, fragment2.buffer.length - (n4 + (n5 = Math.min(n5, n3))));
            if (n6 > 0) {
                System.arraycopy(fragment2.buffer, n4, fragment2.buffer, n4 + n5, n6);
            }
            string.getChars(n2 - n3, n2 - n3 + n5, fragment2.buffer, n4);
            fragment2.updatePos(n4, n5);
            this.docLenDelta += n5;
            if (this.frags.length > 1) {
                this.updateStartPos(fragment2, n, n5);
            }
            n3 -= n5;
            n += n5;
        }
        if (fragment != null) {
            fragment.actFrag = fragment2;
        }
        this.statInsert += n2;
    }

    public synchronized void remove(int n, int n2, Fragment fragment) throws BadLocationException {
        Fragment fragment2;
        int n3 = n2;
        if (n2 == 0) {
            return;
        }
        if (n < 0) {
            this.throwPosException(n);
        }
        if (n + n2 > this.getDocLenImpl()) {
            this.throwPosException(n + n2);
        }
        if (this.directMode) {
            this.support.remove(n, n2);
            return;
        }
        Fragment fragment3 = fragment2 = fragment == null ? this.defFrag : fragment.actFrag;
        if (n >= 0 && n + n2 > fragment2.startPos + fragment2.fragLen) {
            // empty if block
        }
        while (n3 > 0) {
            if (!fragment2.isInside(n)) {
                fragment2 = this.getFrag(n, fragment2, false);
            }
            int n4 = n - fragment2.startPos;
            int n5 = Math.min(n3, fragment2.fragLen - n4);
            System.arraycopy(fragment2.buffer, n4 + n5, fragment2.buffer, n4, fragment2.fragLen - (n4 + n5));
            if (!fragment2.modified) {
                fragment2.modified = true;
                fragment2.firstMod = fragment2.lastMod = n4;
            }
            fragment2.updatePos(n4, -n5);
            this.docLenDelta -= n5;
            if (this.frags.length > 1) {
                this.updateStartPos(fragment2, n, -n5);
            }
            n3 -= n5;
        }
        if (fragment != null) {
            fragment.actFrag = fragment2;
        }
        this.statRemove += n2;
    }

    public synchronized void read(int n, char[] cArray, int n2, int n3, Fragment fragment) throws BadLocationException {
        if (n < 0 || n3 < 0) {
            this.throwPosException(n);
        }
        if (n + n3 > this.getDocLenImpl()) {
            if (n + n3 == this.getDocLenImpl() + 1) {
                if (n3 == 0) {
                    return;
                }
                cArray[n2 + --n3] = 10;
                this.read(n, cArray, n2, n3, fragment);
                return;
            }
            this.throwPosException(n + n3);
        }
        if (this.directMode) {
            this.support.read(n, cArray, n2, n3);
            return;
        }
        int n4 = n3;
        Fragment fragment2 = fragment == null ? this.defFrag : fragment.actFrag;
        while (n4 > 0) {
            if (!fragment2.isInside(n)) {
                fragment2 = this.getFrag(n, fragment, false);
            }
            int n5 = n - fragment2.startPos;
            int n6 = Math.min(fragment2.fragLen - n5, n4);
            System.arraycopy(fragment2.buffer, n5, cArray, n3 - n4 + n2, n6);
            n += n6;
            n4 -= n6;
        }
        if (fragment != null) {
            fragment.actFrag = fragment2;
        }
        this.statRead += n3;
    }

    public final char[] read(int n, int n2, Fragment fragment) throws BadLocationException {
        if (n2 < 0) {
            this.throwPosException(n);
        }
        char[] cArray = new char[n2];
        this.read(n, cArray, 0, n2, fragment);
        return cArray;
    }

    public synchronized int find(Finder finder, int n, int n2, Fragment fragment) throws BadLocationException {
        Fragment fragment2;
        int n3;
        block12: {
            int n4 = this.getDocLenImpl();
            if (n == -1) {
                n = n4;
            }
            if (n2 == -1) {
                n2 = n4;
            }
            if (n < 0 || n > n4) {
                this.throwPosException(n);
            }
            if (n2 < 0 || n2 > n4) {
                this.throwPosException(n2);
            }
            finder.reset();
            if (n == n2) {
                return -1;
            }
            boolean bl = n < n2;
            int n5 = n3 = bl ? n : n - 1;
            if (this.directMode) {
                do {
                    n3 = finder.find(0, this.support.getDirectModeBuffer(), bl ? n : n2, bl ? n2 : n, n3, n2);
                    if (!finder.isFound()) continue;
                    if (bl ? n3 < n || n3 > n2 : n3 < n2 || n3 > n) {
                        return -1;
                    }
                    return n3;
                } while (!(bl ? n3 < n || n3 >= n2 : n3 < n2 || n3 >= n));
                return -1;
            }
            Fragment fragment3 = fragment2 = fragment == null ? this.defFrag : fragment.actFrag;
            do {
                if (!fragment2.isInside(n3)) {
                    fragment2 = this.getFrag(n3, fragment, false);
                }
                int n6 = Math.max(bl ? n : n2, fragment2.startPos) - fragment2.startPos;
                int n7 = Math.min(bl ? n2 : n, fragment2.startPos + fragment2.fragLen) - fragment2.startPos;
                n3 = finder.find(fragment2.startPos, fragment2.buffer, n6, n7, n3, n2);
                if (!finder.isFound()) continue;
                if (bl ? n3 < n || n3 > n2 : n3 < n2 || n3 > n) {
                    return -1;
                }
                break block12;
            } while (!(bl ? n3 < n || n3 >= n2 : n3 < n2 || n3 >= n));
            return -1;
        }
        if (fragment != null) {
            fragment.actFrag = fragment2;
        }
        return n3;
    }

    public final synchronized int getDocLength() {
        return this.getDocLenImpl();
    }

    private int getDocLenImpl() {
        return this.support.getDocLength() + this.docLenDelta;
    }

    final void throwPosException(int n) throws BadLocationException {
        throw new BadLocationException("DocCache: Invalid offset " + n + ". Document length is " + this.getDocLenImpl(), n);
    }

    public String toString() {
        String string = "support=" + this.support;
        if (this.directMode) {
            string = string + ", Direct mode, no fragments\n";
        } else {
            string = string + ", fragment count=" + this.frags.length + "\n";
            int n = 0;
            while (n < this.frags.length) {
                string = string + this.frags[n] + "\n";
                ++n;
            }
        }
        string = string + " getDocLength()=" + this.getDocLength() + ", docLenDelta=" + this.docLenDelta + ", statRead=" + this.statRead + ", statInsert=" + this.statInsert + ", statRemove=" + this.statRemove + ", statReadFragCnt=" + this.statReadFragCnt + ", statWriteFragCnt=" + this.statWriteFragCnt + ", statOverlapCnt=" + this.statOverlapCnt + ", statBackOverlapCnt=" + this.statBackOverlapCnt + ", statFragSwitchCnt=" + this.statFragSwitchCnt + ", statFragSetEmpty=" + this.statFragSetEmpty;
        return string;
    }

    private class Fragment {
        char[] buffer;
        int startPos = -1;
        int fragLen;
        int origLen;
        int firstMod;
        int lastMod;
        boolean modified;
        boolean valid;
        Fragment actFrag;

        Fragment(int n) {
            this.buffer = new char[n];
            this.actFrag = this;
        }

        boolean isInside(int n) {
            return n >= this.startPos && n < this.startPos + this.fragLen;
        }

        boolean isIn(int n) {
            return n >= this.startPos && n <= this.startPos + this.fragLen;
        }

        void write() {
            block13: {
                if (!this.modified) {
                    return;
                }
                int n = this.startPos + this.lastMod;
                int n2 = 0;
                int n3 = 0;
                while (n3 < DocCache.this.frags.length) {
                    Fragment fragment = DocCache.this.frags[n3];
                    if (fragment.valid) {
                        if (fragment.startPos >= this.startPos) break;
                        n2 += fragment.origLen - fragment.fragLen;
                    }
                    ++n3;
                }
                try {
                    int n4;
                    if (this.fragLen != this.origLen) {
                        int n5 = this.fragLen - this.origLen;
                        if (n5 > 0) {
                            DocCache.this.support.insert(n - n5 + n2, this.buffer, this.lastMod - n5, n5);
                            n4 = this.lastMod - this.firstMod - n5;
                        } else {
                            DocCache.this.support.remove(n + n2, -n5);
                            n4 = this.lastMod - this.firstMod;
                        }
                    } else {
                        n4 = this.lastMod - this.firstMod;
                    }
                    if (n4 > 0) {
                        try {
                            DocCache.this.support.write(this.startPos + this.firstMod + n2, this.buffer, this.firstMod, n4);
                        }
                        catch (BadLocationException badLocationException) {
                            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                badLocationException.printStackTrace();
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                    badLocationException.printStackTrace();
                }
            }
            DocCache.this.docLenDelta += this.origLen - this.fragLen;
            this.origLen = this.fragLen;
            this.modified = false;
            ++DocCache.this.statWriteFragCnt;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void read(int n, int n2, int n3) {
            block18: {
                block19: {
                    if (n >= this.startPos) break block19;
                    int n4 = Math.min(n + n2 - this.startPos, this.fragLen);
                    if (n4 > 256) {
                        block17: {
                            ++DocCache.this.statBackOverlapCnt;
                            System.arraycopy(this.buffer, 0, this.buffer, this.startPos - n, n4);
                            try {
                                DocCache.this.support.read(n + n3, this.buffer, 0, this.startPos - n);
                            }
                            catch (BadLocationException badLocationException) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block17;
                                badLocationException.printStackTrace();
                            }
                        }
                        n4 = this.startPos + n4;
                        if (n4 < n + n2) {
                            try {
                                DocCache.this.support.read(this.startPos + this.fragLen + n3, this.buffer, n4 - n, n + n2 - n4);
                            }
                            catch (BadLocationException badLocationException) {
                                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                    badLocationException.printStackTrace();
                                }
                                break block18;
                            }
                        }
                        break block18;
                    } else {
                        try {
                            DocCache.this.support.read(n + n3, this.buffer, 0, n2);
                        }
                        catch (BadLocationException badLocationException) {
                            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                badLocationException.printStackTrace();
                            }
                            break block18;
                        }
                    }
                }
                int n5 = this.startPos + this.fragLen - n;
                if (n5 > 0) {
                    ++DocCache.this.statOverlapCnt;
                    System.arraycopy(this.buffer, n - this.startPos, this.buffer, 0, n5);
                    try {
                        DocCache.this.support.read(n + n5 + n3, this.buffer, n5, n2 - n5);
                    }
                    catch (BadLocationException badLocationException) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            badLocationException.printStackTrace();
                        }
                        break block18;
                    }
                }
                try {
                    DocCache.this.support.read(n + n3, this.buffer, 0, n2);
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block18;
                    badLocationException.printStackTrace();
                }
            }
            this.startPos = n;
            this.fragLen = this.origLen = n2;
            this.valid = true;
            ++DocCache.this.statReadFragCnt;
        }

        void invalidate() {
            this.write();
            this.valid = false;
            this.startPos = -1;
            this.origLen = 0;
            this.fragLen = 0;
        }

        void setEmptyValid() {
            ++DocCache.this.statFragSetEmpty;
            this.origLen = 0;
            this.fragLen = 0;
            this.startPos = 0;
            this.valid = true;
        }

        void updatePos(int n, int n2) {
            if (n < this.firstMod) {
                this.firstMod = n;
            }
            if (n2 > 0) {
                this.lastMod = n > this.lastMod ? n + n2 : (this.lastMod += n2);
                this.fragLen += n2;
                if (this.fragLen > this.buffer.length) {
                    this.origLen -= this.fragLen - this.buffer.length;
                    this.fragLen = this.buffer.length;
                }
            } else {
                this.lastMod = n - n2 <= this.lastMod ? (this.lastMod += n2) : n;
                this.fragLen += n2;
                if (this.fragLen == 0) {
                    this.invalidate();
                }
            }
        }

        public String toString() {
            int n = 0;
            while (n < DocCache.this.frags.length) {
                if (DocCache.this.frags[n] == this) break;
                ++n;
            }
            return "Frag[" + n + "] valid=" + this.valid + ", startPos=" + this.startPos + ", fragLen=" + this.fragLen + ", origLen=" + this.origLen + ", fMod=" + this.firstMod + ", lMod=" + this.lastMod + ", mod=" + this.modified;
        }
    }
}

