/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;

public class GlyphGutter
extends JComponent
implements Annotations.AnnotationsListener,
Accessible {
    private EditorUI editorUI;
    private BaseDocument doc;
    private Annotations annos;
    private Image gutterButton;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight;
    private boolean init;
    private int numberWidth;
    private static final int glyphWidth = 16;
    private static final int glyphButtonWidth = 9;
    private boolean showLineNumbers = true;
    private ImageObserver imgObserver = null;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private boolean drawOverLineNumbers = false;
    private int cachedCountOfAnnos = -1;
    private int cachedCountOfAnnosForLine = -1;
    private PropertyChangeListener annoTypesListener;

    public GlyphGutter(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.init = false;
        this.doc = editorUI.getDocument();
        this.annos = this.doc.getAnnotations();
        this.annos.addAnnotationsListener(this);
        this.init();
        this.update();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        URL uRL = null;
        try {
            uRL = new URL("nbresloc:/org/netbeans/editor/resources/glyphbutton.gif");
        }
        catch (MalformedURLException malformedURLException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                malformedURLException.printStackTrace();
            }
            return;
        }
        if (uRL != null) {
            this.gutterButton = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        this.setToolTipText("");
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("ACSN_Glyph_Gutter"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_Glyph_Gutter"));
        GutterMouseListener gutterMouseListener = new GutterMouseListener();
        this.addMouseListener(gutterMouseListener);
        this.addMouseMotionListener(gutterMouseListener);
        this.imgObserver = new ImageObserver(){

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x20) == 32) {
                    GlyphGutter.this.repaint();
                    return true;
                }
                return true;
            }
        };
        this.annoTypesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "glyphsOverLineNumbers" || propertyChangeEvent.getPropertyName() == "showGlyphGutter") {
                    GlyphGutter.this.update();
                }
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public void update() {
        Coloring coloring = (Coloring)this.editorUI.getColoringMap().get("line-number");
        Coloring coloring2 = this.editorUI.getDefaultColoring();
        if (coloring == null) {
            return;
        }
        this.backgroundColor = coloring.getBackColor() != null ? coloring.getBackColor() : coloring2.getBackColor();
        this.foreColor = coloring.getForeColor() != null ? coloring.getForeColor() : coloring2.getForeColor();
        this.font = coloring.getFont() != null ? coloring.getFont() : coloring2.getFont();
        this.lineHeight = this.editorUI.getLineHeight();
        this.showLineNumbers = this.editorUI.lineNumberVisibleSetting;
        this.drawOverLineNumbers = AnnotationTypes.getTypes().isGlyphsOverLineNumbers();
        this.init = true;
        this.highestLineNumber = this.getLineCount();
        this.repaint();
        this.resize();
    }

    protected void resize() {
        Dimension dimension = new Dimension();
        dimension.width = this.getWidthDimension();
        dimension.height = this.getHeightDimension();
        dimension.height += 300 * this.lineHeight;
        this.numberWidth = this.getLineNumberWidth();
        if (!this.showLineNumbers) {
            this.numberWidth = 0;
        }
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    protected int getLineCount() {
        int n;
        try {
            n = Utilities.getLineOffset(this.doc, this.doc.getLength()) + 1;
        }
        catch (BadLocationException badLocationException) {
            n = 1;
        }
        return n;
    }

    protected int getDigitCount(int n) {
        return Integer.toString(n).length();
    }

    protected int getLineNumberWidth() {
        int n = 0;
        Insets insets = this.editorUI.getLineNumberMargin();
        if (insets != null) {
            n += insets.left + insets.right;
        }
        return n += this.getDigitCount(this.highestLineNumber) * this.editorUI.getLineNumberDigitWidth();
    }

    protected int getWidthDimension() {
        int n = 0;
        if (this.annos.isGlyphColumn() || AnnotationTypes.getTypes().isShowGlyphGutter().booleanValue()) {
            n += 16;
        }
        if (this.annos.isGlyphButtonColumn()) {
            n += 9;
        }
        if (this.showLineNumbers) {
            int n2 = this.getLineNumberWidth();
            if (this.drawOverLineNumbers) {
                if (n2 > n) {
                    n = n2;
                }
            } else {
                n += n2;
            }
        }
        return n;
    }

    protected int getHeightDimension() {
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return 0;
        }
        return this.highestLineNumber * this.lineHeight + (int)jTextComponent.getSize().getHeight();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        if (!this.init) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(this.font);
        graphics.setColor(this.foreColor);
        FontMetrics fontMetrics = FontMetricsCache.getFontMetrics(this.font, this);
        int n4 = 0;
        Insets insets = this.editorUI.getLineNumberMargin();
        if (insets != null) {
            n4 = insets.right;
        }
        if ((n3 = (int)((float)rectangle.y / (float)this.lineHeight)) > 0) {
            --n3;
        }
        int n5 = n3 * this.lineHeight;
        int n6 = Integer.MAX_VALUE;
        if (this.showLineNumbers) {
            n6 = this.getLineCount();
            n2 = (int)((float)(rectangle.y + rectangle.height) / (float)this.lineHeight) + 1;
            if (n2 > this.highestLineNumber) {
                n = this.highestLineNumber;
                this.highestLineNumber = n2;
                if (this.getDigitCount(this.highestLineNumber) > this.getDigitCount(n)) {
                    this.resize();
                    return;
                }
            }
        }
        n2 = this.annos.getNextLineWithAnnotation(n3);
        while (n5 + this.lineHeight / 2 <= rectangle.y + rectangle.height) {
            if (this.showLineNumbers && (!this.drawOverLineNumbers || this.drawOverLineNumbers && n3 != n2) && n3 < n6) {
                n = fontMetrics.stringWidth("" + (n3 + 1));
                graphics.drawString("" + (n3 + 1), this.numberWidth - n - n4, n5 + this.editorUI.getLineAscent());
            }
            if (n3 == n2) {
                n = this.annos.getNumberOfAnnotations(n3);
                AnnotationDesc annotationDesc = this.annos.getActiveAnnotation(n3);
                int n7 = this.numberWidth;
                if (this.drawOverLineNumbers) {
                    n7 = this.getWidth() - 16;
                    if (n > 1) {
                        n7 -= 9;
                    }
                }
                if (annotationDesc != null && (n != 1 || !annotationDesc.isDefaultGlyph()) && this.prepareImage(annotationDesc.getGlyph(), this.imgObserver)) {
                    graphics.drawImage(annotationDesc.getGlyph(), n7, n5 + (this.lineHeight - annotationDesc.getGlyph().getHeight(null)) / 2 + 1, null);
                }
                if (n > 1 && this.prepareImage(this.gutterButton, this.imgObserver) && this.prepareImage(annotationDesc.getGlyph(), this.imgObserver)) {
                    graphics.drawImage(this.gutterButton, n7 + 16, n5 + (this.lineHeight - annotationDesc.getGlyph().getHeight(null)) / 2, null);
                }
                n2 = this.annos.getNextLineWithAnnotation(n3 + 1);
            }
            n5 += this.lineHeight;
            ++n3;
        }
    }

    public void changedLine(int n) {
        if (!this.init) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        if (n > 0) {
            --n;
        }
        int n2 = n * this.lineHeight;
        this.repaint(0, n2, (int)this.getSize().getWidth(), 3 * this.lineHeight);
        this.checkSize();
    }

    public void changedAll() {
        if (!this.init) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        try {
            int n = Utilities.getLineOffset(this.doc, this.doc.getLength()) + 1;
        }
        catch (BadLocationException badLocationException) {
            boolean bl = true;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int n = this.getLineCount();
        if (n > this.highestLineNumber) {
            this.highestLineNumber = n;
        }
        Dimension dimension = this.getPreferredSize();
        if (this.getWidthDimension() > dimension.width || this.getHeightDimension() > dimension.height) {
            this.resize();
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = (int)((float)mouseEvent.getY() / (float)this.lineHeight);
        if (this.annos.getNumberOfAnnotations(n) == 0) {
            return null;
        }
        if (this.isMouseOverCycleButton(mouseEvent) && this.annos.getNumberOfAnnotations(n) > 1) {
            return MessageFormat.format(LocaleSupport.getString("cycling-glyph_tooltip"), new Integer(this.annos.getNumberOfAnnotations(n)));
        }
        if (this.isMouseOverGlyph(mouseEvent)) {
            return this.annos.getActiveAnnotation(n).getShortDescription();
        }
        return null;
    }

    private int getXPosOfGlyph(int n) {
        int n2 = this.numberWidth;
        if (this.drawOverLineNumbers) {
            n2 = this.getWidth() - 16;
            if (this.cachedCountOfAnnos == -1 || this.cachedCountOfAnnosForLine != n) {
                this.cachedCountOfAnnos = this.annos.getNumberOfAnnotations(n);
                this.cachedCountOfAnnosForLine = n;
            }
            if (this.cachedCountOfAnnos > 1) {
                n2 -= 9;
            }
        }
        return n2;
    }

    private boolean isMouseOverGlyph(MouseEvent mouseEvent) {
        int n = (int)((float)mouseEvent.getY() / (float)this.lineHeight);
        return mouseEvent.getX() >= this.getXPosOfGlyph(n) && mouseEvent.getX() <= this.getXPosOfGlyph(n) + 16;
    }

    private boolean isMouseOverCycleButton(MouseEvent mouseEvent) {
        int n = (int)((float)mouseEvent.getY() / (float)this.lineHeight);
        return mouseEvent.getX() >= this.getXPosOfGlyph(n) + 16 && mouseEvent.getX() <= this.getXPosOfGlyph(n) + 16 + 9;
    }

    class GutterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int dragStartLine;
        private int dragEndLine;
        private int currentEndLine;
        private boolean selectForward;

        GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2;
            if ((mouseEvent.getModifiers() & 0x10) == 16) {
                if (GlyphGutter.this.isMouseOverCycleButton(mouseEvent)) {
                    n2 = (int)((float)mouseEvent.getY() / (float)GlyphGutter.this.lineHeight);
                    GlyphGutter.this.annos.activateNextAnnotation(n2);
                } else {
                    Action action = ImplementationProvider.getDefault().getToggleBreakpointAction();
                    if (action != null) {
                        n = (int)((float)mouseEvent.getY() / (float)GlyphGutter.this.lineHeight);
                        int n3 = -1;
                        try {
                            n3 = Utilities.getLineOffset(GlyphGutter.this.doc, GlyphGutter.this.editorUI.getComponent().getCaret().getDot());
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (n != n3) {
                            int n4 = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, n);
                            JumpList.checkAddEntry();
                            GlyphGutter.this.editorUI.getComponent().getCaret().setDot(n4);
                        }
                        action.actionPerformed(new ActionEvent(GlyphGutter.this.editorUI.getComponent(), 0, ""));
                    }
                }
            }
            if ((mouseEvent.getModifiers() & 4) == 4) {
                n2 = (int)((float)mouseEvent.getY() / (float)GlyphGutter.this.lineHeight);
                n = GlyphGutter.this.annos.getActiveAnnotation(n2) != null ? GlyphGutter.this.annos.getActiveAnnotation(n2).getOffset() : Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, n2);
                if (GlyphGutter.this.editorUI.getComponent().getCaret().getDot() != n) {
                    JumpList.checkAddEntry();
                }
                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(n);
                JPopupMenu jPopupMenu = GlyphGutter.this.annos.createPopupMenu(Utilities.getKit(GlyphGutter.this.editorUI.getComponent()), n2);
                if (jPopupMenu != null) {
                    jPopupMenu.show(GlyphGutter.this, mouseEvent.getX(), mouseEvent.getY());
                }
                jPopupMenu.addPopupMenuListener(new PopupMenuListener(this){
                    private final /* synthetic */ GutterMouseListener this$1;
                    {
                        this.this$1 = gutterMouseListener;
                    }

                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        GlyphGutter.access$400(GutterMouseListener.access$500(this.this$1)).getComponent().requestFocus();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        GlyphGutter.access$400(GutterMouseListener.access$500(this.this$1)).getComponent().requestFocus();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void updateSelection(boolean bl) {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            try {
                if (bl) {
                    this.selectForward = true;
                    int n = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine);
                    if (n < 0) {
                        n = Utilities.getRowStart(GlyphGutter.this.doc, GlyphGutter.this.doc.getLength());
                        this.dragStartLine = Utilities.getLineOffset(GlyphGutter.this.doc, n);
                    }
                    jTextComponent.setCaretPosition(n);
                    int n2 = Utilities.getRowEnd(GlyphGutter.this.doc, n);
                    if (n2 < GlyphGutter.this.doc.getLength()) {
                        ++n2;
                    }
                    jTextComponent.moveCaretPosition(n2);
                    this.currentEndLine = this.dragEndLine = this.dragStartLine;
                } else {
                    if (this.currentEndLine == this.dragEndLine) {
                        return;
                    }
                    if (this.dragEndLine < this.dragStartLine) {
                        int n;
                        if (this.selectForward) {
                            n = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine + 1);
                            if (n < 0) {
                                n = Utilities.getRowEnd(GlyphGutter.this.doc, Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine));
                            }
                            jTextComponent.setCaretPosition(n);
                            this.selectForward = false;
                        }
                        if ((n = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragEndLine)) < 0) {
                            n = 0;
                        }
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        int n;
                        if (!this.selectForward) {
                            jTextComponent.setCaretPosition(Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine));
                            this.selectForward = true;
                        }
                        if ((n = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragEndLine + 1)) < 0) {
                            n = GlyphGutter.this.doc.getLength();
                        }
                        jTextComponent.moveCaretPosition(n);
                    }
                }
                this.currentEndLine = this.dragEndLine;
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
        }

        static /* synthetic */ GlyphGutter access$500(GutterMouseListener gutterMouseListener) {
            return gutterMouseListener.GlyphGutter.this;
        }
    }
}

