/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroSavePanel;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;

public class MacroDialogSupport
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    MacroSavePanel panel;
    Dialog macroDialog;
    Class kitClass;

    public MacroDialogSupport(Class clazz) {
        this.kitClass = clazz;
        this.panel = new MacroSavePanel(clazz);
        this.okButton = new JButton(LocaleSupport.getString("MDS_ok"));
        this.cancelButton = new JButton(LocaleSupport.getString("MDS_cancel"));
        this.okButton.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MDS_ok"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MDS_cancel"));
    }

    public void setBody(String string) {
        this.panel.setBody(string);
    }

    public void showMacroDialog() {
        this.macroDialog = DialogSupport.createDialog(LocaleSupport.getString("MDS_title"), this.panel, true, new JButton[]{this.okButton, this.cancelButton}, false, 0, 1, this);
        this.macroDialog.pack();
        this.panel.popupNotify();
        this.macroDialog.requestFocus();
        this.macroDialog.show();
    }

    private List getKBList() {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.kitClass, "key-bindings");
        List<MultiKeyBinding> list = null;
        int n = 0;
        while (n < kitAndValueArray.length) {
            if (kitAndValueArray[n].kitClass == this.kitClass) {
                list = (List)kitAndValueArray[n].value;
            }
            ++n;
        }
        if (list == null) {
            list = new ArrayList();
        }
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = list.get(n3);
            if (!(e instanceof MultiKeyBinding) && e != null) {
                JTextComponent.KeyBinding keyBinding = (JTextComponent.KeyBinding)e;
                list.set(n3, new MultiKeyBinding(keyBinding.key, keyBinding.actionName));
            }
            ++n3;
        }
        return new ArrayList(list);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            Map map = (Map)Settings.getValue(this.kitClass, "macro-map");
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            hashMap.put(this.panel.getName(), this.panel.getBody());
            Settings.setValue(this.kitClass, "macro-map", hashMap);
            List list = this.panel.getKeySequences();
            if (list.size() > 0) {
                List list2 = this.getKBList();
                String string = new String("macro-" + this.panel.getName());
                int n = 0;
                while (n < list.size()) {
                    KeyStroke[] keyStrokeArray = (KeyStroke[])list.get(n);
                    MultiKeyBinding multiKeyBinding = new MultiKeyBinding(keyStrokeArray, string);
                    list2.add(multiKeyBinding);
                    ++n;
                }
                Settings.setValue(this.kitClass, "key-bindings", list2);
            }
        }
        ((Component)this.macroDialog).setVisible(false);
        this.macroDialog.dispose();
    }
}

