/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;

class SyntaxSeg
extends Segment {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final int MAX_SLOT_COUNT = 100;
    private static final int REALLOC_INCREMENT = 2048;
    private static ArrayList slotList = new ArrayList();

    SyntaxSeg() {
    }

    static synchronized Slot getFreeSlot() {
        int n = slotList.size();
        return n > 0 ? (Slot)slotList.remove(n - 1) : new Slot();
    }

    static synchronized void releaseSlot(Slot slot) {
        slotList.add(slot);
    }

    static synchronized void invalidate(BaseDocument baseDocument, int n) {
        int n2 = slotList.size();
        int n3 = 0;
        while (n3 < n2) {
            ((Slot)slotList.get(n3)).invalidate(baseDocument, n);
            ++n3;
        }
    }

    static class Slot
    extends Segment {
        WeakReference segDocRef = new WeakReference<Object>(null);
        int segPos;
        int segLen;

        Slot() {
            this.array = EMPTY_CHAR_ARRAY;
        }

        int load(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
            boolean bl;
            if (n2 <= 0) {
                if (n2 == 0) {
                    this.count = 0;
                    return 0;
                }
                throw new RuntimeException("len=" + n2);
            }
            BaseDocument baseDocument2 = (BaseDocument)this.segDocRef.get();
            boolean bl2 = bl = baseDocument != baseDocument2;
            if (bl) {
                baseDocument2 = baseDocument;
                this.segDocRef = new WeakReference<BaseDocument>(baseDocument2);
            }
            if (bl || n < this.segPos || n > this.segPos + this.segLen || n - this.segPos + n2 > this.array.length) {
                if (n2 > this.array.length) {
                    char[] cArray = new char[n2 + 2048];
                    this.array = cArray;
                }
                this.segPos = n;
                this.segLen = n2;
                baseDocument.getChars(n, this.array, 0, n2);
            } else {
                int n3 = this.segPos + this.segLen;
                int n4 = n + n2 - n3;
                if (n4 > 0) {
                    baseDocument.getChars(n3, this.array, this.segLen, n4);
                    this.segLen += n4;
                }
            }
            this.offset = n - this.segPos;
            this.count = n2;
            if (this.offset < 0 || n2 < 0) {
                throw new BadLocationException("pos=" + n + ", offset=" + this.offset + "len=" + n2, this.offset);
            }
            return n2;
        }

        boolean isAreaInside(BaseDocument baseDocument, int n, int n2) {
            return baseDocument == (BaseDocument)this.segDocRef.get() && n >= this.segPos && n + n2 <= this.segPos + this.segLen;
        }

        void invalidate(BaseDocument baseDocument, int n) {
            if (baseDocument == (BaseDocument)this.segDocRef.get()) {
                if (n < this.segPos) {
                    this.segLen = 0;
                } else if (n < this.segPos + this.segLen) {
                    this.segLen = n - this.segPos;
                }
            }
        }
    }
}

