/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class WeakEventListenerList
extends EventListenerList {
    private int listenerSize;

    public synchronized Object[] getListenerList() {
        Object object;
        int n = 0;
        Object[] objectArray = new Object[this.listenerSize];
        int n2 = 1;
        while (n2 < this.listenerSize) {
            object = ((WeakReference)this.listenerList[n2]).get();
            if (object != null) {
                objectArray[n++] = this.listenerList[n2 - 1];
                objectArray[n++] = object;
            } else {
                System.arraycopy(this.listenerList, n2 + 1, this.listenerList, n2 - 1, this.listenerSize - n2 - 1);
                this.listenerSize -= 2;
                n2 -= 2;
            }
            n2 += 2;
        }
        if (objectArray.length != n) {
            object = new Object[n];
            System.arraycopy(objectArray, 0, object, 0, n);
            objectArray = object;
        }
        return objectArray;
    }

    public synchronized EventListener[] getListeners(Class clazz) {
        Object object;
        int n = 0;
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, this.listenerSize);
        int n2 = 0;
        while (n2 < this.listenerSize) {
            if (this.listenerList[n2++] == clazz) {
                object = (EventListener)((WeakReference)this.listenerList[n2]).get();
                if (object != null) {
                    eventListenerArray[n++] = object;
                } else {
                    System.arraycopy(this.listenerList, n2 + 1, this.listenerList, n2 - 1, this.listenerSize - n2 - 1);
                    this.listenerSize -= 2;
                    n2 -= 2;
                }
            }
            ++n2;
        }
        if (eventListenerArray.length != n) {
            object = (EventListener[])Array.newInstance(clazz, n);
            System.arraycopy(eventListenerArray, 0, object, 0, n);
            eventListenerArray = object;
        }
        return eventListenerArray;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (this.listenerSize == 0) {
            this.listenerList = new Object[]{clazz, new WeakReference<EventListener>(eventListener)};
            this.listenerSize = 2;
        } else {
            if (this.listenerSize == this.listenerList.length) {
                Object[] objectArray = new Object[this.listenerSize * 2];
                System.arraycopy(this.listenerList, 0, objectArray, 0, this.listenerSize);
                this.listenerList = objectArray;
            }
            this.listenerList[this.listenerSize++] = clazz;
            this.listenerList[this.listenerSize++] = new WeakReference<EventListener>(eventListener);
        }
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        int n = -1;
        int n2 = this.listenerSize - 2;
        while (n2 >= 0) {
            if (this.listenerList[n2] == clazz && ((WeakReference)this.listenerList[n2 + 1]).get().equals(eventListener)) {
                n = n2;
                break;
            }
            n2 -= 2;
        }
        if (n >= 0) {
            System.arraycopy(this.listenerList, n + 2, this.listenerList, n, this.listenerSize - n - 2);
            this.listenerSize -= 2;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < this.listenerSize) {
            Class clazz = (Class)this.listenerList[n];
            EventListener eventListener = (EventListener)((WeakReference)this.listenerList[n + 1]).get();
            if (eventListener != null && eventListener instanceof Serializable) {
                objectOutputStream.writeObject(clazz.getName());
                objectOutputStream.writeObject(eventListener);
            }
            n += 2;
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add((Class)Class.forName((String)object), eventListener);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("WeakEventListenerList: ");
        stringBuffer.append(this.listenerSize / 2);
        stringBuffer.append(" listeners:\n");
        int n = 0;
        while (n < this.listenerSize) {
            stringBuffer.append(" type " + ((Class)this.listenerList[n]).getName());
            stringBuffer.append(" listener " + ((WeakReference)this.listenerList[n + 1]).get());
            n += 2;
        }
        return stringBuffer.toString();
    }
}

