/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.CompletionPane;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.ScrollCompletionPane;
import org.netbeans.editor.ext.ScrollJavaDocPane;

public class Completion
implements PropertyChangeListener,
SettingsChangeListener,
ActionListener {
    protected ExtEditorUI extEditorUI;
    private CompletionQuery query;
    private CompletionQuery.Result lastResult;
    private CompletionView view;
    private ExtCompletionPane pane;
    private JavaDocPane javaDocPane;
    private JDCPopupPanel jdcPopupPanel;
    private boolean autoPopup;
    private int autoPopupDelay;
    private int refreshDelay;
    private boolean instantSubstitution;
    Timer timer;
    private DocumentListener docL;
    private CaretListener caretL;
    private PropertyChangeListener docChangeL;
    private int caretPos = -1;
    static /* synthetic */ Class class$org$netbeans$editor$ext$ExtSyntaxSupport;

    public Completion(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.timer = new Timer(0, new WeakTimerListener(this));
        this.timer.setRepeats(false);
        this.docL = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getLength() > 0) {
                    Completion.this.invalidateLastResult();
                    Completion.this.refresh(false);
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getLength() > 0) {
                    Completion.this.invalidateLastResult();
                    Completion.this.refresh(false);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.caretL = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (!Completion.this.isPaneVisible()) {
                    Completion.this.cancelRequest();
                } else {
                    Completion.this.refresh(true);
                }
            }
        };
        Settings.addSettingsChangeListener(this);
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            this.autoPopup = SettingsUtil.getBoolean(clazz, "completion-auto-popup", ExtSettingsDefaults.defaultCompletionAutoPopup);
            this.autoPopupDelay = SettingsUtil.getInteger(clazz, "completion-auto-popup-delay", ExtSettingsDefaults.defaultCompletionAutoPopupDelay);
            this.refreshDelay = SettingsUtil.getInteger(clazz, "completion-refresh-delay", ExtSettingsDefaults.defaultCompletionRefreshDelay);
            this.instantSubstitution = SettingsUtil.getBoolean(clazz, "completion-instant-substitution", ExtSettingsDefaults.defaultCompletionInstantSubstitution);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jTextComponent != null) {
                this.settingsChange(null);
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument != null) {
                    baseDocument.addDocumentListener(this.docL);
                }
                jTextComponent.addCaretListener(this.caretL);
            } else {
                jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument != null) {
                    baseDocument.removeDocumentListener(this.docL);
                }
                if (jTextComponent != null) {
                    jTextComponent.removeCaretListener(this.caretL);
                }
            }
        } else if ("document".equals(string)) {
            if (propertyChangeEvent.getOldValue() instanceof BaseDocument) {
                ((BaseDocument)propertyChangeEvent.getOldValue()).removeDocumentListener(this.docL);
            }
            if (propertyChangeEvent.getNewValue() instanceof BaseDocument) {
                ((BaseDocument)propertyChangeEvent.getNewValue()).addDocumentListener(this.docL);
            }
        }
    }

    public CompletionPane getPane() {
        return this.getExtPane();
    }

    public ExtCompletionPane getExtPane() {
        if (this.pane == null) {
            this.pane = new ScrollCompletionPane(this.extEditorUI);
        }
        return this.pane;
    }

    protected CompletionView createView() {
        return new ListCompletionView();
    }

    public final CompletionView getView() {
        if (this.view == null) {
            this.view = this.createView();
        }
        return this.view;
    }

    protected CompletionQuery createQuery() {
        return null;
    }

    public final CompletionQuery getQuery() {
        if (this.query == null) {
            this.query = this.createQuery();
        }
        return this.query;
    }

    public JavaDocPane getJavaDocPane() {
        if (this.javaDocPane == null) {
            this.javaDocPane = new ScrollJavaDocPane(this.extEditorUI);
        }
        return this.javaDocPane;
    }

    public JDCPopupPanel getJDCPopupPanel() {
        if (this.jdcPopupPanel == null) {
            this.jdcPopupPanel = new JDCPopupPanel(this.extEditorUI, this.getExtPane(), this.getJavaDocPane());
        }
        return this.jdcPopupPanel;
    }

    public final synchronized CompletionQuery.Result getLastResult() {
        return this.lastResult;
    }

    public final synchronized void invalidateLastResult() {
        this.lastResult = null;
    }

    public synchronized Object getSelectedValue() {
        int n;
        if (this.lastResult != null && (n = this.getView().getSelectedIndex()) >= 0) {
            return this.lastResult.getData().get(n);
        }
        return null;
    }

    public boolean isAutoPopupEnabled() {
        return this.autoPopup;
    }

    public boolean isPaneVisible() {
        return this.pane != null && this.pane.isVisible();
    }

    public void setPaneVisible(boolean bl) {
        if (bl) {
            if (this.extEditorUI.getComponent() != null) {
                this.popup(false);
            }
        } else if (this.pane != null) {
            this.cancelRequest();
            this.invalidateLastResult();
            this.getJDCPopupPanel().setCompletionVisible(false);
            this.caretPos = -1;
        }
    }

    public void completionCancel() {
        if (this.pane != null) {
            this.cancelRequest();
            this.invalidateLastResult();
            this.caretPos = -1;
        }
    }

    public synchronized void refresh(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Completion.this.isPaneVisible()) {
                    Completion.this.timer.stop();
                    if (bl2) {
                        Completion.this.timer.setInitialDelay(Completion.this.refreshDelay);
                        Completion.this.timer.setDelay(Completion.this.refreshDelay);
                        Completion.this.timer.start();
                    } else {
                        Completion.this.actionPerformed(null);
                    }
                }
            }
        });
    }

    public synchronized void popup(boolean bl) {
        if (this.isPaneVisible()) {
            this.refresh(bl);
        } else {
            this.timer.stop();
            if (bl) {
                this.timer.setInitialDelay(this.autoPopupDelay);
                this.timer.setDelay(this.autoPopupDelay);
                this.timer.start();
            } else {
                this.actionPerformed(null);
            }
        }
    }

    public synchronized void cancelRequest() {
        this.timer.stop();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.jdcPopupPanel == null) {
            this.extEditorUI.getCompletionJavaDoc();
        }
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        if (jTextComponent != null && baseDocument != null) {
            ExtSyntaxSupport extSyntaxSupport;
            if (actionEvent != null && (extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport().get(class$org$netbeans$editor$ext$ExtSyntaxSupport == null ? (class$org$netbeans$editor$ext$ExtSyntaxSupport = Completion.class$("org.netbeans.editor.ext.ExtSyntaxSupport")) : class$org$netbeans$editor$ext$ExtSyntaxSupport)) != null && !extSyntaxSupport.isPrepared()) {
                return;
            }
            try {
                if (this.caretPos != -1 && Utilities.getRowStart(jTextComponent, jTextComponent.getCaret().getDot()) != Utilities.getRowStart(jTextComponent, this.caretPos) && this.caretPos != jTextComponent.getCaret().getDot() + 1) {
                    this.getJDCPopupPanel().setCompletionVisible(false);
                    this.caretPos = -1;
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.caretPos = jTextComponent.getCaret().getDot();
            this.lastResult = this.getQuery().query(jTextComponent, this.caretPos, baseDocument.getSyntaxSupport());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CompletionQuery.Result result = Completion.this.lastResult;
                    if (result != null) {
                        if (Completion.this.instantSubstitution && result.getData().size() == 1 && !Completion.this.isPaneVisible() && Completion.this.instantSubstitution(Completion.this.caretPos)) {
                            return;
                        }
                        Completion.this.getPane().setTitle(result.getTitle());
                        Completion.this.getView().setResult(result);
                        if (Completion.this.isPaneVisible()) {
                            Completion.this.getJDCPopupPanel().refresh();
                        } else {
                            Completion.this.getJDCPopupPanel().setCompletionVisible(true);
                        }
                    } else {
                        Completion.this.getJDCPopupPanel().setCompletionVisible(false);
                        Completion.this.caretPos = -1;
                    }
                }
            });
        }
    }

    public synchronized boolean instantSubstitution(int n) {
        if (this.getLastResult() == null) {
            return false;
        }
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        try {
            if (jTextComponent == null || Utilities.getWordEnd(jTextComponent, n) > n) {
                return false;
            }
            return this.getLastResult().substituteText(0, true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public synchronized boolean substituteText(boolean bl) {
        if (this.lastResult != null) {
            int n = this.getView().getSelectedIndex();
            if (n >= 0) {
                this.lastResult.substituteText(n, bl);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean substituteCommonText() {
        if (this.lastResult != null) {
            int n = this.getView().getSelectedIndex();
            if (n >= 0) {
                this.lastResult.substituteCommonText(n);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

