/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;

public class JDCPopupPanel
extends JPanel
implements PropertyChangeListener,
SettingsChangeListener {
    private ExtCompletionPane completion;
    private JavaDocPane javadoc;
    private ExtEditorUI extEditorUI;
    private FocusListener focusL;
    private List keyActionPairsList;
    private static final int WINDOW_GAP = 1;
    private static final String POPUP_HIDE = "jdc-popup-hide";
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final String JAVADOC_UP = "javadoc-up";
    private static final String JAVADOC_DOWN = "javadoc-down";
    private static final String JAVADOC_PGUP = "javadoc-pgup";
    private static final String JAVADOC_PGDN = "javadoc-pgdn";
    private static final String JAVADOC_BEGIN = "javadoc-begin";
    private static final String JAVADOC_END = "javadoc-end";
    private static final String JAVADOC_LEFT = "javadoc-left";
    private static final String JAVADOC_RIGHT = "javadoc-right";
    private static final String JAVADOC_BACK = "javadoc-back";
    private static final String JAVADOC_FORWARD = "javadoc-forward";
    private static final String JAVADOC_OPEN_IN_BROWSER = "javadoc-open-in-browser";
    private static final String JAVADOC_OPEN_SOURCE = "javadoc-open-source";
    static /* synthetic */ Class class$org$netbeans$editor$PopupManager$Placement;

    public JDCPopupPanel(ExtEditorUI extEditorUI, ExtCompletionPane extCompletionPane, JavaDocPane javaDocPane) {
        this.completion = extCompletionPane;
        this.javadoc = javaDocPane;
        this.extEditorUI = extEditorUI;
        this.keyActionPairsList = new ArrayList();
        this.setLayout(null);
        this.setOpaque(false);
        this.focusL = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        JTextComponent jTextComponent;
                        if (1.access$000(this.this$1).isVisible() && (jTextComponent = JDCPopupPanel.access$100(1.access$000(this.this$1)).getComponent()) != null) {
                            Component component;
                            Window window = SwingUtilities.windowForComponent(jTextComponent);
                            Component component2 = component = window == null ? null : window.getFocusOwner();
                            if (component == null) {
                                1.access$000(this.this$1).setVisible(false);
                            }
                            if (component == JDCPopupPanel.access$200(1.access$000(this.this$1)) || component == JDCPopupPanel.access$300(1.access$000(this.this$1)) || 1.access$000(this.this$1).getJavaDocPane().getComponent().isAncestorOf(component)) {
                                jTextComponent.requestFocus();
                            } else if (component != jTextComponent) {
                                1.access$000(this.this$1).setVisible(false);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ JDCPopupPanel access$000(1 var0) {
                return var0.JDCPopupPanel.this;
            }
        };
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
        super.setVisible(false);
        Settings.addSettingsChangeListener(this);
    }

    public ExtCompletionPane getCompletionPane() {
        return this.completion;
    }

    private void cancelJavaDocTask() {
        CompletionJavaDoc completionJavaDoc = this.extEditorUI.getCompletionJavaDoc();
        if (completionJavaDoc != null) {
            completionJavaDoc.cancelPerformingThread();
        }
    }

    private JavaDocView getJavaDocView() {
        CompletionJavaDoc completionJavaDoc = this.extEditorUI.getCompletionJavaDoc();
        if (completionJavaDoc != null) {
            return completionJavaDoc.getJavaDocView();
        }
        return null;
    }

    private CompletionView getCompletionView() {
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null) {
            return completion.getView();
        }
        return null;
    }

    public JavaDocPane getJavaDocPane() {
        return this.javadoc;
    }

    public Dimension getMinimumSize() {
        return this.completion.getComponent().getMinimumSize();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.completion.getComponent().getMaximumSize();
        Dimension dimension2 = this.javadoc.getComponent().getMaximumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Dimension dimension2 = this.completion.getComponent().getPreferredSize();
        Dimension dimension3 = this.javadoc.getComponent().getPreferredSize();
        Dimension dimension4 = this.completion.getComponent().getMaximumSize();
        Dimension dimension5 = this.javadoc.getComponent().getMaximumSize();
        dimension.width = Math.min(dimension2.width, dimension4.width) + Math.min(dimension3.width, dimension5.width);
        dimension.height = Math.min(dimension2.height, dimension4.height) + Math.min(dimension3.height, dimension5.height);
        return dimension;
    }

    public void setCompletionVisible(boolean bl) {
        this.completion.getComponent().setVisible(bl);
        this.setVisible(bl);
    }

    public void setJavaDocVisible(boolean bl) {
        this.javadoc.getComponent().setVisible(bl);
        if (bl) {
            this.extEditorUI.getPopupManager().install(this);
            this.setVisible(bl);
        }
        if (!this.getCompletionPane().isVisible()) {
            this.setVisible(bl);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.extEditorUI.getPopupManager().install(this);
        }
        if (bl && (this.javadoc.getComponent().isVisible() || this.completion.isVisible())) {
            super.setVisible(bl);
        }
        if (!bl) {
            this.cancelJavaDocTask();
            Completion completion = this.extEditorUI.getCompletion();
            if (completion != null) {
                completion.completionCancel();
            }
            this.javadoc.getComponent().setVisible(bl);
            this.completion.getComponent().setVisible(bl);
            super.setVisible(bl);
        }
    }

    public void setSize(int n, int n2) {
        boolean bl;
        CompletionJavaDoc completionJavaDoc;
        PopupManager.Placement placement = (PopupManager.Placement)this.getClientProperty(class$org$netbeans$editor$PopupManager$Placement == null ? (class$org$netbeans$editor$PopupManager$Placement = JDCPopupPanel.class$("org.netbeans.editor.PopupManager$Placement")) : class$org$netbeans$editor$PopupManager$Placement);
        Dimension dimension = this.completion.getComponent().getMinimumSize();
        if (dimension.height > n2) {
            this.putClientProperty(class$org$netbeans$editor$PopupManager$Placement == null ? (class$org$netbeans$editor$PopupManager$Placement = JDCPopupPanel.class$("org.netbeans.editor.PopupManager$Placement")) : class$org$netbeans$editor$PopupManager$Placement, null);
        }
        this.completion.getComponent().setSize(n, n2);
        Dimension dimension2 = this.javadoc.getComponent().getMinimumSize();
        Dimension dimension3 = this.completion.getComponent().getMaximumSize();
        Rectangle rectangle = new Rectangle(this.completion.getComponent().getSize());
        Rectangle rectangle2 = new Rectangle(this.javadoc.getComponent().getMaximumSize());
        boolean bl2 = true;
        if (!this.javadoc.getComponent().isVisible()) {
            bl2 = false;
        }
        if ((completionJavaDoc = this.extEditorUI.getCompletionJavaDoc()) != null && completionJavaDoc.autoPopup()) {
            bl2 = true;
        }
        if (!(bl = this.getCompletionPane().isVisible())) {
            dimension.height = 0;
            dimension.width = 0;
            rectangle = new Rectangle();
        } else {
            rectangle.width = Math.min(dimension3.width, rectangle.width);
            rectangle.height = Math.min(dimension3.height, rectangle.height);
        }
        if (dimension2.height + dimension.height > n2) {
            bl2 = false;
        }
        if (bl2) {
            if (rectangle.height + rectangle2.height > n2) {
                rectangle.height = Math.max(Math.min(n2 / 2, rectangle.height), dimension.height);
                rectangle.height = Math.min(130, rectangle.height);
                rectangle2.height = Math.min(n2 - rectangle.height - 1, rectangle2.height);
            }
            if (placement == PopupManager.Below) {
                rectangle.y = 0;
                rectangle2.y = rectangle.height + 1;
            } else {
                rectangle.y = rectangle2.height + 1;
                rectangle2.y = 0;
            }
        }
        if (n < dimension2.width) {
            bl2 = false;
        } else {
            rectangle2.width = Math.min(n, rectangle2.width);
            JTextComponent jTextComponent = this.extEditorUI.getComponent();
            Rectangle rectangle3 = this.extEditorUI.getExtentBounds();
            Rectangle rectangle4 = (Rectangle)((Object)jTextComponent.getCaret());
            rectangle.x = n - rectangle2.width + rectangle.width < rectangle4.x - rectangle3.x ? rectangle2.width - rectangle.width : 0;
        }
        this.completion.setVisible(false);
        this.remove(this.completion.getComponent());
        this.remove(this.javadoc.getComponent());
        if (bl2) {
            if (bl) {
                this.completion.getComponent().setBounds(rectangle);
                this.javadoc.getComponent().setBounds(rectangle2);
                super.setBounds(0, 0, Math.max(rectangle.width, rectangle2.width), rectangle.height + rectangle2.height + 1);
                this.add(this.completion.getComponent());
                this.add(this.javadoc.getComponent());
                this.completion.setVisible(true);
            } else {
                rectangle2.x = 0;
                rectangle2.y = 0;
                this.javadoc.getComponent().setBounds(rectangle2);
                super.setBounds(0, 0, rectangle2.width, rectangle2.height);
                this.add(this.javadoc.getComponent());
            }
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
            this.completion.getComponent().setBounds(rectangle);
            super.setBounds(0, 0, rectangle.width, rectangle.height + 1);
            this.add(this.completion.getComponent());
            this.completion.setVisible(true);
        }
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void refresh() {
        this.setVisible(true);
    }

    private void performJavaDocAction(KeyStroke keyStroke) {
        ActionListener actionListener = this.getJavaDocPane().getJavadocDisplayComponent().getActionForKeyStroke(keyStroke);
        if (actionListener != null) {
            actionListener.actionPerformed(new ActionEvent(this.getJavaDocPane().getJavadocDisplayComponent(), 1001, ""));
            this.getJavaDocPane().getJavadocDisplayComponent().repaint();
        }
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        JTextComponent jTextComponent;
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (string != null && this.extEditorUI != null && (jTextComponent = this.extEditorUI.getComponent()) != null) {
            KeyStroke[] keyStrokeArray2;
            Action action;
            EditorKit editorKit;
            TextUI textUI = jTextComponent.getUI();
            Keymap keymap = jTextComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(jTextComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null && (keyStrokeArray2 = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray2.length > 0) {
                keyStrokeArray = keyStrokeArray2;
            }
        }
        return keyStrokeArray;
    }

    private void registerKeybinding(String string, KeyStroke keyStroke, String string2, Action action) {
        KeyStroke[] keyStrokeArray = this.findEditorKeys(string2, keyStroke);
        int n = 0;
        while (n < keyStrokeArray.length) {
            this.getInputMap().put(keyStrokeArray[n], string);
            this.keyActionPairsList.add(string);
            this.keyActionPairsList.add(keyStrokeArray[n]);
            ++n;
        }
        this.getActionMap().put(string, action);
    }

    private void unregisterKeybinding(String string, KeyStroke keyStroke) {
        this.getInputMap().remove(keyStroke);
        this.getActionMap().remove(string);
    }

    private void installKeybindings() {
        this.registerKeybinding(POPUP_HIDE, KeyStroke.getKeyStroke(27, 0), "escape", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.setVisible(false);
            }
        });
        this.registerKeybinding(COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JDCPopupPanel.this.completion.isVisible()) {
                    JDCPopupPanel.this.getCompletionView().up();
                } else {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(38, 0));
                }
            }
        });
        this.registerKeybinding(COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JDCPopupPanel.this.completion.isVisible()) {
                    JDCPopupPanel.this.getCompletionView().down();
                } else {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(40, 0));
                }
            }
        });
        this.registerKeybinding(COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JDCPopupPanel.this.completion.isVisible()) {
                    JDCPopupPanel.this.getCompletionView().pageDown();
                } else {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(34, 0));
                }
            }
        });
        this.registerKeybinding(COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JDCPopupPanel.this.completion.isVisible()) {
                    JDCPopupPanel.this.getCompletionView().pageUp();
                } else {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(33, 0));
                }
            }
        });
        this.registerKeybinding(COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JDCPopupPanel.this.completion.isVisible()) {
                    JDCPopupPanel.this.getCompletionView().begin();
                } else {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(36, 0));
                }
            }
        });
        this.registerKeybinding(COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JDCPopupPanel.this.completion.isVisible()) {
                    JDCPopupPanel.this.getCompletionView().end();
                } else {
                    JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(35, 0));
                }
            }
        });
        this.registerKeybinding(JAVADOC_UP, KeyStroke.getKeyStroke(38, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(38, 0));
            }
        });
        this.registerKeybinding(JAVADOC_DOWN, KeyStroke.getKeyStroke(40, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(40, 0));
            }
        });
        this.registerKeybinding(JAVADOC_PGDN, KeyStroke.getKeyStroke(34, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(34, 0));
            }
        });
        this.registerKeybinding(JAVADOC_PGUP, KeyStroke.getKeyStroke(33, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(33, 0));
            }
        });
        this.registerKeybinding(JAVADOC_BEGIN, KeyStroke.getKeyStroke(36, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(36, 0));
            }
        });
        this.registerKeybinding(JAVADOC_END, KeyStroke.getKeyStroke(35, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(35, 0));
            }
        });
        this.registerKeybinding(JAVADOC_LEFT, KeyStroke.getKeyStroke(37, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(37, 0));
            }
        });
        this.registerKeybinding(JAVADOC_RIGHT, KeyStroke.getKeyStroke(39, 1), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDCPopupPanel.this.performJavaDocAction(KeyStroke.getKeyStroke(39, 0));
            }
        });
        this.registerKeybinding(JAVADOC_BACK, KeyStroke.getKeyStroke(37, 8), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                if (completionJavaDoc != null) {
                    completionJavaDoc.backHistory();
                }
            }
        });
        this.registerKeybinding(JAVADOC_FORWARD, KeyStroke.getKeyStroke(39, 8), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                if (completionJavaDoc != null) {
                    completionJavaDoc.forwardHistory();
                }
            }
        });
        this.registerKeybinding(JAVADOC_OPEN_IN_BROWSER, KeyStroke.getKeyStroke(112, 9), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                if (completionJavaDoc != null && completionJavaDoc.isExternalJavaDocMounted()) {
                    completionJavaDoc.openInExternalBrowser();
                }
            }
        });
        this.registerKeybinding(JAVADOC_OPEN_SOURCE, KeyStroke.getKeyStroke(79, 10), null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompletionJavaDoc completionJavaDoc = JDCPopupPanel.this.extEditorUI.getCompletionJavaDoc();
                if (completionJavaDoc != null) {
                    completionJavaDoc.goToSource();
                }
            }
        });
    }

    private void uninstallKeybindings() {
        Iterator iterator = this.keyActionPairsList.iterator();
        while (iterator.hasNext()) {
            this.unregisterKeybinding((String)iterator.next(), (KeyStroke)iterator.next());
        }
        this.keyActionPairsList.clear();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                JTextComponent jTextComponent = this.extEditorUI.getComponent();
                this.installKeybindings();
                jTextComponent.addFocusListener(this.focusL);
            } else {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                this.uninstallKeybindings();
                jTextComponent.removeFocusListener(this.focusL);
            }
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        this.uninstallKeybindings();
        this.installKeybindings();
    }

    static /* synthetic */ JavaDocView access$200(JDCPopupPanel jDCPopupPanel) {
        return jDCPopupPanel.getJavaDocView();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

