/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;

public class ListCompletionView
extends JList
implements CompletionView {
    public ListCompletionView() {
        this((ListCellRenderer)null);
    }

    public ListCompletionView(ListCellRenderer listCellRenderer) {
        this.setSelectionMode(0);
        if (listCellRenderer != null) {
            this.setCellRenderer(listCellRenderer);
        }
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_CompletionView"));
    }

    public void setResult(CompletionQuery.Result result) {
        if (result != null) {
            this.setResult(result.getData());
        }
    }

    public void setResult(List list) {
        if (list != null) {
            this.setModel(new Model(list));
            if (list.size() > 0) {
                this.setSelectedIndex(0);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(this.getSelectedIndex() - 1);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void down() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, n));
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int n = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n2 = Math.max(this.getFirstVisibleIndex() - n, 0);
            int n3 = Math.max(this.getSelectedIndex() - n, n2);
            this.ensureIndexIsVisible(n2);
            this.setSelectedIndex(n3);
            this.ensureIndexIsVisible(n3);
        }
    }

    public void pageDown() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            int n2 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            n = Math.max(Math.min(this.getLastVisibleIndex() + n2, n), 0);
            int n3 = Math.max(Math.min(this.getSelectedIndex() + n2, n), 0);
            this.ensureIndexIsVisible(n);
            this.setSelectedIndex(n3);
            this.ensureIndexIsVisible(n3);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List list) {
            this.data = list;
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int n) {
            return n >= 0 && n < this.data.size() ? this.data.get(n) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

