/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.JavaDocView;

public class ScrollJavaDocPane
extends JPanel
implements JavaDocPane,
SettingsChangeListener {
    protected ExtEditorUI extEditorUI;
    private JComponent view;
    private CompletionJavaDoc cjd;
    protected JScrollPane scrollPane = new JScrollPane();
    Border lineBorder;

    public ScrollJavaDocPane(ExtEditorUI extEditorUI) {
        this.setLayout(null);
        this.extEditorUI = extEditorUI;
        this.cjd = extEditorUI.getCompletionJavaDoc();
        if (this.cjd != null) {
            JavaDocView javaDocView = this.cjd.getJavaDocView();
            if (javaDocView instanceof JComponent) {
                if (javaDocView instanceof JEditorPane) {
                    ((JEditorPane)((Object)javaDocView)).addHyperlinkListener(new HyperlinkAction());
                }
                this.view = (JComponent)((Object)javaDocView);
                this.scrollPane.setViewportView(this.view);
            }
            Settings.addSettingsChangeListener(this);
            this.setMinimumSize(new Dimension(100, 100));
            this.setMaximumSize(this.getMaxPopupSize());
        } else {
            this.setMinimumSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        super.setVisible(false);
        this.add(this.scrollPane);
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JAVADOC_javaDocPane"));
        this.installTitleComponent();
        this.setBorder(new LineBorder(UIManager.getColor("controlDkShadow")));
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.scrollPane.setBounds(rectangle.x, 0, rectangle.width + 1, rectangle.height);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.cjd != null && !bl) {
            this.cjd.clearHistory();
        }
    }

    protected ImageIcon resolveIcon(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(string);
        }
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    protected void installTitleComponent() {
    }

    private Dimension getMaxPopupSize() {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            return (Dimension)SettingsUtil.getValue(clazz, "javadoc-preferred-size", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
        }
        return ExtSettingsDefaults.defaultJavaDocPreferredSize;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if ("javadoc-preferred-size".equals(settingsChangeEvent.getSettingName())) {
            this.setMaximumSize(this.getMaxPopupSize());
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void setForwardEnabled(boolean bl) {
    }

    public void setBackEnabled(boolean bl) {
    }

    public void setShowWebEnabled(boolean bl) {
    }

    public JComponent getJavadocDisplayComponent() {
        return this.scrollPane;
    }

    protected class HyperlinkAction
    implements HyperlinkListener {
        protected HyperlinkAction() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            Object object;
            if (hyperlinkEvent != null && HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType()) && hyperlinkEvent.getDescription() != null && (object = ScrollJavaDocPane.this.cjd.parseLink(hyperlinkEvent.getDescription(), null)) != null) {
                ScrollJavaDocPane.this.cjd.setContent(object);
                ScrollJavaDocPane.this.cjd.addToHistory(object);
            }
        }
    }

    public class BrowserButton
    extends JButton {
        public BrowserButton() {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(String string) {
            super(string);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }

        public BrowserButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
        }
    }
}

