/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.ExtEditorUI;

public class ToolTipSupport
extends MouseAdapter
implements MouseMotionListener,
ActionListener,
PropertyChangeListener,
SettingsChangeListener,
FocusListener {
    public static final String PROP_TOOL_TIP = "toolTip";
    public static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROP_STATUS = "status";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_INITIAL_DELAY = "initialDelay";
    public static final String PROP_DISMISS_DELAY = "dismissDelay";
    private static final String UI_PREFIX = "ToolTip";
    public static final int INITIAL_DELAY = 1000;
    public static final int DISMISS_DELAY = 60000;
    public static final int STATUS_HIDDEN = 0;
    public static final int STATUS_VISIBILITY_ENABLED = 1;
    public static final int STATUS_TEXT_VISIBLE = 2;
    public static final int STATUS_COMPONENT_VISIBLE = 3;
    private static final int MOUSE_EXTRA_HEIGHT = 5;
    private ExtEditorUI extEditorUI;
    private JComponent toolTip;
    private String toolTipText;
    private Timer enterTimer;
    private Timer exitTimer;
    private boolean enabled;
    private int status;
    private MouseEvent lastMouseEvent;
    private PropertyChangeSupport pcs;
    static /* synthetic */ Class class$java$lang$String;

    public ToolTipSupport(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.enterTimer = new Timer(1000, new WeakTimerListener(this));
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(60000, new WeakTimerListener(this));
        this.exitTimer.setRepeats(false);
        Settings.addSettingsChangeListener(this);
        extEditorUI.addPropertyChangeListener(this);
        this.setEnabled(true);
    }

    public final JComponent getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(this.createDefaultToolTip());
        }
        return this.toolTip;
    }

    public void setToolTip(JComponent jComponent) {
        JComponent jComponent2 = this.toolTip;
        this.toolTip = jComponent;
        if (this.status >= 1) {
            this.ensureVisibility();
        }
        this.firePropertyChange(PROP_TOOL_TIP, jComponent2, this.toolTip);
    }

    protected JComponent createDefaultToolTip() {
        return this.createTextToolTip();
    }

    private JTextArea createTextToolTip() {
        JTextArea jTextArea = new JTextArea(){
            static /* synthetic */ Class class$org$netbeans$editor$PopupManager$Placement;

            public void setSize(int n, int n2) {
                int n3 = this.getDocument().getLength();
                if (n3 > 0) {
                    this.setLineWrap(false);
                    Dimension dimension = this.getPreferredSize();
                    if (n > dimension.width) {
                        n = dimension.width;
                        n2 = n2 >= dimension.height ? dimension.height : -1;
                    } else {
                        this.setLineWrap(true);
                        super.setSize(n, 100000);
                        try {
                            Rectangle rectangle = this.modelToView(n3 - 1);
                            int n4 = rectangle.y + rectangle.height;
                            n2 = n4 < n2 ? n4 : -1;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                if (n2 >= 0) {
                    super.setSize(n, n2);
                } else {
                    this.putClientProperty(class$org$netbeans$editor$PopupManager$Placement == null ? (class$org$netbeans$editor$PopupManager$Placement = 1.class$("org.netbeans.editor.PopupManager$Placement")) : class$org$netbeans$editor$PopupManager$Placement, null);
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        Font font = UIManager.getFont("ToolTip.font");
        Color color = UIManager.getColor("ToolTip.background");
        Color color2 = UIManager.getColor("ToolTip.foreground");
        if (font != null) {
            jTextArea.setFont(font);
        }
        if (color2 != null) {
            jTextArea.setForeground(color2);
        }
        if (color != null) {
            jTextArea.setBackground(color);
        }
        jTextArea.setOpaque(true);
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(jTextArea.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        return jTextArea;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            jComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jComponent != null) {
                jComponent.addPropertyChangeListener(this);
                this.disableSwingToolTip(jComponent);
                jComponent.addFocusListener(this);
                if (jComponent.hasFocus()) {
                    this.focusGained(new FocusEvent(jComponent, 1004));
                }
            } else {
                jComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                jComponent.removeFocusListener(this);
                jComponent.removePropertyChangeListener(this);
            }
        }
        if ("ToolTipText".equals(string)) {
            jComponent = (JComponent)propertyChangeEvent.getSource();
            this.disableSwingToolTip(jComponent);
            this.componentToolTipTextChanged(propertyChangeEvent);
        }
    }

    private void disableSwingToolTip(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolTipManager.sharedInstance().unregisterComponent(jComponent);
                GlyphGutter glyphGutter = ToolTipSupport.this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null) {
                    ToolTipManager.sharedInstance().unregisterComponent(glyphGutter);
                }
            }
        });
    }

    protected void updateToolTip() {
        ExtEditorUI extEditorUI = this.extEditorUI;
        if (extEditorUI == null) {
            return;
        }
        JTextComponent jTextComponent = extEditorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            this.setToolTipText(this.extEditorUI.getGlyphGutter().getToolTipText(this.lastMouseEvent));
        } else {
            Action action;
            BaseKit baseKit = Utilities.getKit(jTextComponent);
            if (baseKit != null && (action = baseKit.getActionByName("build-tool-tip")) != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
        }
    }

    protected void setToolTipVisible(boolean bl) {
        if (!bl) {
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
        if (bl && this.status < 1 || !bl && this.status >= 1) {
            if (bl) {
                if (this.enabled) {
                    this.setStatus(1);
                    this.updateToolTip();
                }
            } else {
                if (this.toolTip != null) {
                    this.toolTip.setVisible(false);
                }
                this.setStatus(0);
            }
        }
    }

    public boolean isToolTipVisible() {
        return this.status > 1;
    }

    public final int getStatus() {
        return this.status;
    }

    private void setStatus(int n) {
        if (this.status != n) {
            int n2 = this.status;
            this.status = n;
            this.firePropertyChange(PROP_STATUS, new Integer(n2), new Integer(this.status));
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        String string2 = this.toolTipText;
        this.toolTipText = string;
        this.firePropertyChange(PROP_TOOL_TIP_TEXT, string2, this.toolTipText);
        if (this.toolTipText != null) {
            JTextArea jTextArea = this.createTextToolTip();
            jTextArea.setText(this.toolTipText);
            this.setToolTip(jTextArea);
        } else if (this.status == 2) {
            this.setToolTipVisible(false);
        }
    }

    private void applyToolTipText() {
        JComponent jComponent = this.getToolTip();
        if (jComponent != null) {
            if (jComponent instanceof JLabel) {
                ((JLabel)jComponent).setText(this.toolTipText);
            } else if (jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).setText(this.toolTipText);
            } else if (jComponent instanceof JToolTip) {
                ((JToolTip)jComponent).setTipText(this.toolTipText);
            } else {
                try {
                    Method method = jComponent.getClass().getMethod("setText", class$java$lang$String == null ? (class$java$lang$String = ToolTipSupport.class$("java.lang.String")) : class$java$lang$String);
                    if (method != null) {
                        method.invoke((Object)this.toolTip, this.toolTipText);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isGlyphGutterMouseEvent(MouseEvent mouseEvent) {
        return mouseEvent != null && mouseEvent.getSource() == this.extEditorUI.getGlyphGutter();
    }

    private void ensureVisibility() {
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        if (jTextComponent != null) {
            int n = jTextComponent.viewToModel(this.getLastMouseEventPoint());
            Rectangle rectangle = null;
            if (n >= 0) {
                try {
                    rectangle = jTextComponent.modelToView(n);
                    rectangle.y -= 5;
                    rectangle.height += 10;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (rectangle == null) {
                rectangle = new Rectangle(this.getLastMouseEventPoint(), new Dimension(1, 1));
            }
            PopupManager popupManager = this.extEditorUI.getPopupManager();
            popupManager.install(this.toolTip, rectangle, PopupManager.AbovePreferred);
        }
        this.exitTimer.restart();
    }

    public String getIdentifierUnderCursor() {
        String string = null;
        if (!this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            try {
                JTextComponent jTextComponent = this.extEditorUI.getComponent();
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                Point point = this.getLastMouseEventPoint();
                int n = baseTextUI.viewToModel(jTextComponent, point);
                if (n >= 0) {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = Utilities.getRowEnd(baseDocument, n);
                    Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n2);
                    int n3 = this.extEditorUI.getLineHeight();
                    if (point.x <= rectangle.x && point.y <= rectangle.y + n3) {
                        string = Utilities.getIdentifier(baseDocument, n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.firePropertyChange(PROP_ENABLED, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
            if (!bl) {
                this.setToolTipVisible(false);
            }
        }
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        if (this.enterTimer.getDelay() != n) {
            int n2 = this.enterTimer.getDelay();
            this.enterTimer.setDelay(n);
            this.firePropertyChange(PROP_INITIAL_DELAY, new Integer(n2), new Integer(this.enterTimer.getDelay()));
        }
    }

    public int getDismissDelay() {
        return this.exitTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        if (this.exitTimer.getDelay() != n) {
            int n2 = this.exitTimer.getDelay();
            this.exitTimer.setDelay(n);
            this.firePropertyChange(PROP_DISMISS_DELAY, new Integer(n2), new Integer(this.exitTimer.getDelay()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.enterTimer) {
            this.setToolTipVisible(true);
        } else if (actionEvent.getSource() == this.exitTimer) {
            this.setToolTipVisible(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setToolTipVisible(false);
        if (this.enabled) {
            this.enterTimer.restart();
        }
        this.lastMouseEvent = mouseEvent;
    }

    public final MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    private Point getLastMouseEventPoint() {
        Point point = null;
        MouseEvent mouseEvent = this.lastMouseEvent;
        if (mouseEvent != null) {
            JTextComponent jTextComponent;
            point = mouseEvent.getPoint();
            if (mouseEvent.getSource() == this.extEditorUI.getGlyphGutter() && (jTextComponent = this.extEditorUI.getComponent()) != null && jTextComponent.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)jTextComponent.getParent();
                point = new Point(jViewport.getViewPosition().x, point.y);
            }
        }
        return point;
    }

    protected void componentToolTipTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        this.setToolTipText(jComponent.getToolTipText());
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPCS().firePropertyChange(string, object, object2);
    }

    public void focusGained(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
        if (glyphGutter != null) {
            glyphGutter.addMouseListener(this);
            glyphGutter.addMouseMotionListener(this);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this);
        GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
        if (glyphGutter != null) {
            glyphGutter.removeMouseListener(this);
            glyphGutter.removeMouseMotionListener(this);
        }
        this.setToolTipVisible(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

