/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaSyntax;

public class JavaImport
implements TokenProcessor {
    private static final int INIT_SCAN_LEN = 4096;
    private static final int INIT = 0;
    private static final int AFTER_IMPORT = 1;
    private static final int INSIDE_EXP = 2;
    private static final int INSIDE_MIXED_EXP = 3;
    private HashMap name2Class = new HashMap(501);
    private char[] buffer;
    private ArrayList infoList = new ArrayList();
    private int state;
    private boolean parsingPackage;
    private int startPos;
    private int expPos;
    private boolean eotReached;
    private StringBuffer exp = new StringBuffer();
    private boolean star;
    private int posEndOfImportSection = -1;
    private boolean disableReparsing = false;
    JavaSyntax debugSyntax = new JavaSyntax();

    public synchronized void update(BaseDocument baseDocument) {
        if (this.disableReparsing) {
            return;
        }
        baseDocument.readLock();
        try {
            int n = 4096;
            int n2 = baseDocument.getLength();
            boolean bl = false;
            do {
                block7: {
                    if (n >= n2) {
                        n = n2;
                        bl = true;
                    }
                    this.eotReached = false;
                    this.init();
                    try {
                        baseDocument.getSyntaxSupport().tokenizeText(this, 0, n, false);
                    }
                    catch (BadLocationException badLocationException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block7;
                        badLocationException.printStackTrace();
                    }
                }
                n *= 4;
                if (bl) break;
            } while (this.eotReached);
            Object var7_6 = null;
            baseDocument.readUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            baseDocument.readUnlock();
            throw throwable;
        }
        this.buffer = null;
    }

    protected void init() {
        this.exp.setLength(0);
        this.star = false;
        this.parsingPackage = false;
        this.infoList.clear();
        this.name2Class.clear();
        JCPackage jCPackage = JavaCompletion.getFinder().getExactPackage("java.lang");
        if (jCPackage != null) {
            JCClass[] jCClassArray = jCPackage.getClasses();
            int n = 0;
            while (n < jCClassArray.length) {
                this.name2Class.put(jCClassArray[n].getName(), jCClassArray[n]);
                ++n;
            }
        }
    }

    public JCClass getClazz(String string) {
        JCFinder jCFinder = JavaCompletion.getFinder();
        JCClass jCClass = (JCClass)this.name2Class.get(string);
        if (jCClass == null) {
            jCClass = jCFinder.getExactClass(string);
        } else if (jCFinder.getExactClass(jCClass.getFullName()) != null) {
            jCClass = jCFinder.getExactClass(jCClass.getFullName());
        }
        return jCClass;
    }

    protected void packageStatementFound(int n, int n2, String string) {
        JCPackage jCPackage = JavaCompletion.getFinder().getExactPackage(string);
        if (jCPackage != null) {
            JCClass[] jCClassArray = jCPackage.getClasses();
            int n3 = 0;
            while (n3 < jCClassArray.length) {
                this.name2Class.put(jCClassArray[n3].getName(), jCClassArray[n3]);
                ++n3;
            }
        }
    }

    protected void importStatementFound(int n, int n2, String string, boolean bl) {
        JCFinder jCFinder = JavaCompletion.getFinder();
        Info info = new Info(n, n2, bl);
        JCClass jCClass = jCFinder.getExactClass(string);
        if (jCClass != null) {
            info.cls = jCClass;
            if (!this.star) {
                this.name2Class.put(jCClass.getName(), jCClass);
            }
        } else {
            JCPackage jCPackage = jCFinder.getExactPackage(string);
            if (jCPackage != null) {
                info.pkg = jCPackage;
                if (bl) {
                    JCClass[] jCClassArray = jCPackage.getClasses();
                    int n3 = 0;
                    while (n3 < jCClassArray.length) {
                        this.name2Class.put(jCClassArray[n3].getName(), jCClassArray[n3]);
                        ++n3;
                    }
                }
            } else {
                int n4;
                String string2 = string;
                String string3 = null;
                while ((n4 = string2.lastIndexOf(46)) >= 0) {
                    string2 = string2.substring(0, n4);
                    if (string3 == null) {
                        string3 = string2;
                    }
                    if ((jCPackage = jCFinder.getExactPackage(string2)) == null) continue;
                    info.cls = jCClass = JavaCompletion.getSimpleClass(string, string2.length());
                    info.unknownImport = string;
                    if (this.star) break;
                    this.name2Class.put(jCClass.getName(), jCClass);
                    break;
                }
                if (jCClass == null && string3 != null) {
                    jCClass = JavaCompletion.getSimpleClass(string, string3.length());
                    if (!this.star) {
                        this.name2Class.put(jCClass.getName(), jCClass);
                    }
                }
            }
        }
        if (info.cls == null && info.pkg == null) {
            info.unknownImport = string;
        }
        this.infoList.add(info);
    }

    public boolean isUnknownImport(String string) {
        int n = 0;
        while (n < this.infoList.size()) {
            String string2 = ((Info)this.infoList.get((int)n)).unknownImport;
            if (string2 != null && string2.indexOf(string) > -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected List getUnknownImports() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.infoList.size()) {
            String string = ((Info)this.infoList.get((int)n)).unknownImport;
            if (string != null) {
                if (((Info)this.infoList.get((int)n)).star) {
                    string = string + ".*";
                }
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean isImported(JCClass jCClass) {
        if (jCClass == null) {
            return false;
        }
        String string = jCClass.getFullName();
        String string2 = jCClass.getPackageName();
        if (this.name2Class.containsValue(jCClass)) {
            return true;
        }
        int n = 0;
        while (n < this.infoList.size()) {
            JCClass jCClass2 = ((Info)this.infoList.get((int)n)).cls;
            JCPackage jCPackage = ((Info)this.infoList.get((int)n)).pkg;
            if (string != null && jCClass2 != null && string.equals(jCClass2.getFullName())) {
                return true;
            }
            if (string2 != null && jCPackage != null && string2.equals(jCPackage.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
        boolean bl = true;
        block0 : switch (tokenID.getNumericID()) {
            case 6: {
                switch (this.state) {
                    case 1: {
                        this.expPos = n;
                        this.state = 2;
                        break;
                    }
                    case 3: {
                        this.exp.append(this.buffer, n, n2);
                    }
                    case 2: {
                        if (!this.star) break;
                        bl = false;
                    }
                }
                break;
            }
            case 48: {
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 3: {
                        this.exp.append('.');
                    }
                    case 2: {
                        if (!this.star) break;
                        bl = false;
                    }
                }
                break;
            }
            case 51: {
                String string = null;
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        string = new String(this.buffer, this.expPos, (this.star ? n - 2 : n) - this.expPos);
                        break;
                    }
                    case 3: {
                        string = this.exp.toString();
                        this.exp.setLength(0);
                    }
                }
                if (string == null) break;
                if (this.parsingPackage) {
                    this.packageStatementFound(this.startPos, n + 1, string);
                } else {
                    this.importStatementFound(this.startPos, n + 1, string, this.star);
                }
                this.star = false;
                this.parsingPackage = false;
                this.state = 0;
                break;
            }
            case 25: {
                if (this.star || this.parsingPackage) {
                    bl = false;
                    break;
                }
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        this.star = true;
                        if (n != 0 && this.buffer[n - 1] == '.') break;
                        bl = false;
                        break;
                    }
                    case 3: {
                        int n3 = this.exp.length();
                        if (n3 > 0 && this.exp.charAt(n3 - 1) == '.') {
                            this.exp.setLength(n3 - 1);
                            this.star = true;
                            break;
                        }
                        bl = false;
                    }
                }
                break;
            }
            case 97: {
                switch (this.state) {
                    case 0: {
                        this.parsingPackage = true;
                        this.state = 1;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 91: {
                switch (this.state) {
                    case 0: {
                        this.parsingPackage = false;
                        this.state = 1;
                        this.startPos = n;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                switch (this.state) {
                    case 2: {
                        if (n - this.expPos < 0) {
                            bl = false;
                            break;
                        }
                        this.exp.append(this.buffer, this.expPos, n - this.expPos);
                        this.state = 3;
                    }
                }
                break;
            }
            default: {
                if (this.posEndOfImportSection == -1 || n + n2 > this.posEndOfImportSection) {
                    this.posEndOfImportSection = n + n2;
                }
                bl = false;
            }
        }
        return bl;
    }

    private String debugState(int n) {
        switch (n) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "AFTER_IMPORT";
            }
            case 2: {
                return "INSIDE_EXP";
            }
            case 3: {
                return "INSIDE_MIXED_EXP";
            }
        }
        return "UNKNOWN STATE";
    }

    public int eot(int n) {
        this.eotReached = true;
        return 0;
    }

    public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        this.buffer = cArray;
    }

    public void documentModifiedAtPosition(int n) {
        if (this.posEndOfImportSection != -1) {
            if (n > this.posEndOfImportSection) {
                this.disableReparsing = true;
            } else {
                this.disableReparsing = false;
                this.posEndOfImportSection = -1;
            }
        }
    }

    class Info {
        int startPos;
        int endPos;
        boolean star;
        JCPackage pkg;
        JCClass cls;
        String unknownImport;

        Info(int n, int n2, boolean bl) {
            this.startPos = n;
            this.endPos = n2;
            this.star = bl;
        }
    }
}

