/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.python.compiler.Attribute;
import org.python.compiler.Code;
import org.python.compiler.ConstantPool;
import org.python.compiler.Method;

public class ClassFile {
    ConstantPool pool;
    int access;
    public String name;
    String superclass;
    int[] interfaces;
    Vector methods;
    Vector fields;
    Vector attributes;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int NATIVE = 256;
    public static final int ABSTRACT = 1024;

    public static String fixName(String string) {
        if (string.indexOf(46) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '.') {
                cArray[n] = 47;
            }
            ++n;
        }
        return new String(cArray);
    }

    public ClassFile(String string) {
        this(string, "java/lang/Object", 33);
    }

    public ClassFile(String string, String string2, int n) {
        this.name = ClassFile.fixName(string);
        this.superclass = ClassFile.fixName(string2);
        this.interfaces = new int[0];
        this.access = n;
        this.pool = new ConstantPool();
        this.methods = new Vector();
        this.fields = new Vector();
        this.attributes = new Vector();
    }

    public void addInterface(String string) throws IOException {
        int[] nArray = new int[this.interfaces.length + 1];
        System.arraycopy(this.interfaces, 0, nArray, 0, this.interfaces.length);
        nArray[this.interfaces.length] = this.pool.Class(string);
        this.interfaces = nArray;
    }

    public Code addMethod(String string, String string2, int n) throws IOException {
        Code code = new Code(string2, this.pool, (n & 8) == 8);
        Method method = new Method(this.pool.UTF8(string), this.pool.UTF8(string2), n, new Attribute[]{code});
        this.methods.addElement(method);
        return code;
    }

    public void addField(String string, String string2, int n) throws IOException {
        Method method = new Method(this.pool.UTF8(string), this.pool.UTF8(string2), n, new Attribute[0]);
        this.fields.addElement(method);
    }

    public static void writeAttributes(DataOutputStream dataOutputStream, Attribute[] attributeArray) throws IOException {
        dataOutputStream.writeShort(attributeArray.length);
        int n = 0;
        while (n < attributeArray.length) {
            attributeArray[n].write(dataOutputStream);
            ++n;
        }
    }

    public void writeMethods(DataOutputStream dataOutputStream, Vector vector) throws IOException {
        dataOutputStream.writeShort(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Method method = (Method)vector.elementAt(n);
            method.write(dataOutputStream);
            ++n;
        }
    }

    public void addAttribute(Attribute attribute) throws IOException {
        this.attributes.addElement(attribute);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.pool.Class(this.name);
        int n2 = this.pool.Class(this.superclass);
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        this.pool.write(dataOutputStream);
        dataOutputStream.writeShort(this.access);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(this.interfaces.length);
        int n3 = 0;
        while (n3 < this.interfaces.length) {
            dataOutputStream.writeShort(this.interfaces[n3]);
            ++n3;
        }
        this.writeMethods(dataOutputStream, this.fields);
        this.writeMethods(dataOutputStream, this.methods);
        int n4 = this.attributes.size();
        dataOutputStream.writeShort(n4);
        int n5 = 0;
        while (n5 < n4) {
            ((Attribute)this.attributes.elementAt(n5)).write(dataOutputStream);
            ++n5;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new DataOutputStream(outputStream));
    }
}

