/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Vector;
import org.python.core.ClassDictInit;
import org.python.core.ListFunctions;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class PyList
extends PySequence
implements ClassDictInit {
    protected PyObject[] list;
    protected int length;
    protected static PyObject __methods__;
    private static final int MINSIZE = 10;
    private static final int STACKSIZE = 64;
    public static PyClass __class__;

    public static void classDictInit(PyObject pyObject) {
        PySequence.classDictInit(pyObject);
        pyObject.__setitem__("reverse", (PyObject)new ListFunctions("reverse", 1, 0));
        pyObject.__setitem__("sort", (PyObject)new ListFunctions("sort", 2, 0, 1));
        pyObject.__setitem__("__len__", (PyObject)new ListFunctions("__len__", 3, 0));
        pyObject.__setitem__("append", (PyObject)new ListFunctions("append", 10, 1));
        pyObject.__setitem__("count", (PyObject)new ListFunctions("count", 11, 1));
        pyObject.__setitem__("index", (PyObject)new ListFunctions("index", 12, 1));
        pyObject.__setitem__("remove", (PyObject)new ListFunctions("remove", 13, 1));
        pyObject.__setitem__("extend", (PyObject)new ListFunctions("extend", 14, 1));
        pyObject.__setitem__("__add__", (PyObject)new ListFunctions("__add__", 15, 1));
        pyObject.__setitem__("insert", (PyObject)new ListFunctions("insert", 20, 2));
        pyObject.__setitem__("initModule", null);
        pyObject.__setitem__("toString", null);
        pyObject.__setitem__("hashCode", null);
    }

    public PyList() {
        this(Py.EmptyObjects);
    }

    public PyList(Vector vector) {
        this(new PyObject[vector.size()]);
        int n = 0;
        while (n < vector.size()) {
            this.list[n] = (PyObject)vector.elementAt(n);
            ++n;
        }
    }

    public PyList(PyObject[] pyObjectArray) {
        this.list = pyObjectArray;
        this.length = pyObjectArray.length;
    }

    protected String safeRepr() {
        return "'list' object";
    }

    public int __len__() {
        return this.length;
    }

    public PyObject __findattr__(String string) {
        if (string.equals("__methods__")) {
            PyList pyList = (PyList)__methods__;
            PyObject[] pyObjectArray = new PyString[pyList.length];
            int n = 0;
            while (n < pyList.length) {
                pyObjectArray[n] = (PyString)pyList.list[n];
                ++n;
            }
            return new PyList(pyObjectArray);
        }
        return super.__findattr__(string);
    }

    protected PyObject get(int n) {
        return this.list[n];
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        int n4 = PySequence.sliceLength(n, n2, n3);
        PyObject[] pyObjectArray = new PyObject[n4];
        if (n3 == 1) {
            System.arraycopy(this.list, n, pyObjectArray, 0, n2 - n);
            return new PyList(pyObjectArray);
        }
        int n5 = 0;
        int n6 = n;
        while (n5 < n4) {
            pyObjectArray[n5] = this.list[n6];
            ++n5;
            n6 += n3;
        }
        return new PyList(pyObjectArray);
    }

    protected void del(int n) {
        --this.length;
        System.arraycopy(this.list, n + 1, this.list, n, this.length - n);
        this.list[this.length] = null;
    }

    protected void delRange(int n, int n2, int n3) {
        if (n3 != 1) {
            throw Py.ValueError("step size must be 1 for deleting list slice");
        }
        System.arraycopy(this.list, n2, this.list, n, this.length - n2);
        int n4 = this.length - (n2 - n);
        int n5 = this.length;
        int n6 = n4;
        while (n6 < n5) {
            this.list[n6] = null;
            ++n6;
        }
        this.length = n4;
    }

    protected void set(int n, PyObject pyObject) {
        this.list[n] = pyObject;
    }

    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        int n4;
        PySequence pySequence;
        int n5;
        int n6;
        int n7;
        if (!(pyObject instanceof PySequence)) {
            throw Py.TypeError("rhs of setslice must be a sequence");
        }
        if (n3 != 1) {
            throw Py.ValueError("step size must be 1 for setting list slice");
        }
        if (n2 < n) {
            n2 = n;
        }
        if ((n7 = (n6 = this.length) - (n2 - n) + (n5 = (pySequence = (PySequence)pyObject).__len__())) > n6 || n7 < n6) {
            this.resize(n7);
            System.arraycopy(this.list, n2, this.list, n2 + (n7 - n6), n6 - n2);
            if (n7 < n6) {
                n4 = n7;
                while (n4 < n6) {
                    this.list[n4] = null;
                    ++n4;
                }
            }
        }
        PyObject[] pyObjectArray = null;
        if (pyObject instanceof PyTuple) {
            pyObjectArray = ((PyTuple)pyObject).list;
        }
        if (pyObject instanceof PyList && (pyObjectArray = ((PyList)pyObject).list) == this.list) {
            pyObjectArray = (PyObject[])pyObjectArray.clone();
        }
        if (pyObjectArray != null) {
            System.arraycopy(pyObjectArray, 0, this.list, n, n5);
        } else {
            n4 = 0;
            while (n4 < n5) {
                this.list[n4 + n] = pySequence.get(n4);
                ++n4;
            }
        }
    }

    protected PyObject repeat(int n) {
        int n2 = this.length;
        PyObject[] pyObjectArray = new PyObject[n2 * n];
        int n3 = 0;
        while (n3 < n) {
            System.arraycopy(this.list, 0, pyObjectArray, n3 * n2, n2);
            ++n3;
        }
        return new PyList(pyObjectArray);
    }

    public PyObject __imul__(PyObject pyObject) {
        int n = this.length;
        int n2 = pyObject.__int__().getValue();
        this.resize(n * n2);
        int n3 = 0;
        while (n3 < n2) {
            System.arraycopy(this.list, 0, this.list, n3 * n, n);
            ++n3;
        }
        return this;
    }

    public PyObject __add__(PyObject pyObject) {
        if (pyObject instanceof PyList) {
            PyList pyList = (PyList)pyObject;
            PyObject[] pyObjectArray = new PyObject[this.length + pyList.length];
            System.arraycopy(this.list, 0, pyObjectArray, 0, this.length);
            System.arraycopy(pyList.list, 0, pyObjectArray, this.length, pyList.length);
            return new PyList(pyObjectArray);
        }
        return null;
    }

    public String toString() {
        ThreadState threadState = Py.getThreadState();
        if (!threadState.enterRepr(this)) {
            return "[...]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.length - 1) {
            stringBuffer.append(this.list[n].__repr__().toString());
            stringBuffer.append(", ");
            ++n;
        }
        if (this.length > 0) {
            stringBuffer.append(this.list[this.length - 1].__repr__().toString());
        }
        stringBuffer.append("]");
        threadState.exitRepr(this);
        return stringBuffer.toString();
    }

    protected void resize(int n) {
        if (this.list.length < n) {
            PyObject[] pyObjectArray = new PyObject[(int)((double)n * 1.5)];
            System.arraycopy(this.list, 0, pyObjectArray, 0, this.length);
            this.list = pyObjectArray;
        }
        this.length = n;
    }

    public void append(PyObject pyObject) {
        this.resize(this.length + 1);
        this.list[this.length - 1] = pyObject;
    }

    public int count(PyObject pyObject) {
        int n = 0;
        int n2 = this.length;
        PyObject[] pyObjectArray = this.list;
        int n3 = 0;
        while (n3 < n2) {
            if (pyObjectArray[n3].equals(pyObject)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public int index(PyObject pyObject) {
        int n = this.length;
        PyObject[] pyObjectArray = this.list;
        int n2 = 0;
        while (n2 < n) {
            if (pyObjectArray[n2].equals(pyObject)) break;
            ++n2;
        }
        if (n2 == n) {
            throw Py.ValueError("item not found in list");
        }
        return n2;
    }

    public void insert(int n, PyObject pyObject) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.length) {
            n = this.length;
        }
        this.resize(this.length + 1);
        System.arraycopy(this.list, n, this.list, n + 1, this.length - n - 1);
        this.list[n] = pyObject;
    }

    public void remove(PyObject pyObject) {
        this.del(this.index(pyObject));
    }

    public void reverse() {
        int n = this.length;
        PyObject[] pyObjectArray = this.list;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n / 2) {
            PyObject pyObject = pyObjectArray[n3];
            pyObjectArray[n3] = pyObjectArray[n2];
            pyObjectArray[n2] = pyObject;
            ++n3;
            --n2;
        }
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        if (this.length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += this.length;
        }
        if (n < 0 || n >= this.length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject pyObject = this.list[n];
        this.setslice(n, n + 1, 1, Py.EmptyTuple);
        return pyObject;
    }

    public void extend(PyObject pyObject) {
        this.setslice(this.length, this.length, 1, pyObject);
    }

    public PyObject __iadd__(PyObject pyObject) {
        this.extend(pyObject);
        return this;
    }

    private static int docompare(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (pyObject3 == null) {
            return pyObject._cmp(pyObject2);
        }
        PyObject pyObject4 = pyObject3.__call__(new PyObject[]{pyObject, pyObject2});
        if (pyObject4 instanceof PyInteger) {
            int n = ((PyInteger)pyObject4).getValue();
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }
        throw Py.TypeError("comparision function must return int");
    }

    private static void insertionsort(PyObject[] pyObjectArray, int n, int n2, PyObject pyObject) {
        int n3 = n + n2;
        int n4 = n + 1;
        while (n4 < n3) {
            PyObject pyObject2 = pyObjectArray[n4];
            int n5 = n4;
            while (--n5 >= n) {
                PyObject pyObject3 = pyObjectArray[n5];
                if (PyList.docompare(pyObject3, pyObject2, pyObject) <= 0) break;
                pyObjectArray[n5 + 1] = pyObject3;
                pyObjectArray[n5] = pyObject2;
            }
            ++n4;
        }
    }

    private static void quicksort(PyObject[] pyObjectArray, int n, int n2, PyObject pyObject) {
        int[] nArray = new int[64];
        int[] nArray2 = new int[64];
        nArray[0] = n;
        nArray2[0] = n + n2;
        int n3 = 1;
        while (--n3 >= 0) {
            int n4 = nArray2[n3];
            int n5 = nArray[n3];
            int n6 = n4 - n5;
            if (n6 < 10) continue;
            int n7 = n5 + (n6 >> 1);
            int n8 = n4 - 1;
            PyObject pyObject2 = pyObjectArray[n7];
            PyObject pyObject3 = pyObjectArray[n5];
            if (PyList.docompare(pyObject2, pyObject3, pyObject) < 0) {
                pyObjectArray[n5] = pyObject2;
                pyObjectArray[n7] = pyObject3;
            }
            if (PyList.docompare(pyObject2 = pyObjectArray[n8], pyObject3 = pyObjectArray[n7], pyObject) < 0) {
                pyObjectArray[n8] = pyObject2;
                pyObjectArray[n7] = pyObject3;
            }
            if (PyList.docompare(pyObject2 = pyObjectArray[n7], pyObject3 = pyObjectArray[n5], pyObject) < 0) {
                pyObjectArray[n5] = pyObject2;
                pyObjectArray[n7] = pyObject3;
            }
            PyObject pyObject4 = pyObjectArray[n7];
            n7 = n5 + 1;
            n8 = n4 - 2;
            while (true) {
                if (n7 < n4) {
                    if (PyList.docompare(pyObjectArray[n7], pyObject4, pyObject) < 0) {
                        ++n7;
                        continue;
                    }
                }
                while (n8 >= n5) {
                    if (PyList.docompare(pyObject4, pyObjectArray[n8], pyObject) >= 0) break;
                    --n8;
                }
                if (n7 < n8) {
                    PyObject pyObject5 = pyObjectArray[n7];
                    pyObjectArray[n7] = pyObjectArray[n8];
                    pyObjectArray[n8] = pyObject5;
                    ++n7;
                    --n8;
                } else if (n7 == n8) {
                    ++n7;
                    --n8;
                    break;
                }
                if (n7 > n8) break;
            }
            n6 = n8 - n5;
            int n9 = n4 - n7;
            if (n6 > n9) {
                if (n6 <= 10) continue;
                nArray[n3] = n5;
                nArray2[n3++] = n8;
                if (n9 <= 10) continue;
                nArray[n3] = n7;
                nArray2[n3++] = n4;
                continue;
            }
            if (n9 <= 10) continue;
            nArray[n3] = n7;
            nArray2[n3++] = n4;
            if (n6 <= 10) continue;
            nArray[n3] = n5;
            nArray2[n3++] = n8;
        }
        PyList.insertionsort(pyObjectArray, n, n2, pyObject);
    }

    public synchronized void sort(PyObject pyObject) {
        PyList.quicksort(this.list, 0, this.length, pyObject);
    }

    public void sort() {
        this.sort(null);
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    public int hashCode() {
        throw Py.TypeError("unhashable type");
    }

    static {
        PyList pyList = new PyList();
        String[] stringArray = new String[]{"append", "count", "extend", "index", "insert", "pop", "remove", "reverse", "sort"};
        int n = 0;
        while (n < stringArray.length) {
            pyList.append(new PyString(stringArray[n]));
            ++n;
        }
        __methods__ = pyList;
    }
}

