/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class PyXRange
extends PySequence {
    int start;
    int stop;
    int step;
    int cycleLength;
    int copies;

    public PyXRange(int n, int n2, int n3) {
        if (n3 == 0) {
            throw Py.ValueError("zero step for xrange()");
        }
        this.start = n;
        this.stop = n2;
        this.step = n3;
        int n4 = n3 + (n3 > 0 ? -1 : 1);
        this.cycleLength = (n2 - n + n4) / n3;
        if (this.cycleLength < 0) {
            this.cycleLength = 0;
        }
        this.copies = 1;
    }

    public int __len__() {
        return this.cycleLength * this.copies;
    }

    private int getInt(int n) {
        if (this.cycleLength == 0) {
            return this.start;
        }
        return this.start + n % this.cycleLength * this.step;
    }

    protected PyObject get(int n) {
        return new PyInteger(this.getInt(n));
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (this.copies != 1) {
            throw Py.TypeError("cannot slice a replicated range");
        }
        int n4 = PySequence.sliceLength(n, n2, n3);
        int n5 = this.getInt(n);
        int n6 = this.step * n3;
        int n7 = n5 + n6 * n4;
        return new PyXRange(n5, n7, n6);
    }

    protected PyObject repeat(int n) {
        PyXRange pyXRange = new PyXRange(this.start, this.stop, this.step);
        pyXRange.copies = this.copies * n;
        return pyXRange;
    }

    public PyObject __add__(PyObject pyObject) {
        throw Py.TypeError("cannot concatenate xrange objects");
    }

    public int hashCode() {
        return this.stop ^ this.start ^ this.step;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = this.__len__();
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append(this.get(n2).__repr__().toString());
            stringBuffer.append(", ");
            ++n2;
        }
        if (n > 0) {
            stringBuffer.append(this.get(n - 1).__repr__().toString());
        }
        if (n == 1) {
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public PyList tolist() {
        PyList pyList = new PyList();
        int n = this.__len__();
        int n2 = 0;
        while (n2 < n) {
            pyList.append(this.get(n2));
            ++n2;
        }
        return pyList;
    }
}

