/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.apache.oro.text.regex.MatchResult;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.modules.RegexObject;
import org.python.modules.re;

public class MatchObject
extends PyObject {
    public String string;
    public int pos;
    public int endpos;
    public RegexObject re;
    private MatchResult match;

    public MatchObject(RegexObject regexObject, String string, int n, int n2, MatchResult matchResult) {
        this.string = string;
        this.pos = n;
        this.endpos = n2;
        this.re = regexObject;
        this.match = matchResult;
    }

    public int start(int n) {
        return this.match.beginOffset(n);
    }

    public int start() {
        return this.start(0);
    }

    public int start(PyString pyString) {
        return this.start(this.getindex(pyString));
    }

    public int end(int n) {
        return this.match.endOffset(n);
    }

    public int end() {
        return this.end(0);
    }

    public int end(PyString pyString) {
        return this.end(this.getindex(pyString));
    }

    public PyTuple span(int n) {
        return new PyTuple(new PyObject[]{new PyInteger(this.start(n)), new PyInteger(this.end(n))});
    }

    public PyTuple span() {
        return this.span(0);
    }

    public PyTuple span(PyString pyString) {
        return this.span(this.getindex(pyString));
    }

    public PyTuple groups(PyObject pyObject) {
        int n = this.match.groups() - 1;
        PyObject[] pyObjectArray = new PyObject[n];
        int n2 = 0;
        while (n2 < n) {
            String string = this.match.group(n2 + 1);
            pyObjectArray[n2] = string == null ? pyObject : new PyString(string);
            ++n2;
        }
        return new PyTuple(pyObjectArray);
    }

    public PyTuple groups() {
        return this.groups(Py.None);
    }

    private int getindex(PyString pyString) {
        PyInteger pyInteger = (PyInteger)this.re.groupindex.__finditem__(pyString);
        if (pyInteger == null) {
            throw Py.IndexError("group '" + pyString + "' is undefined");
        }
        return pyInteger.getValue();
    }

    private String group(int n) {
        if (n >= this.match.groups()) {
            throw Py.IndexError("group " + n + " is undefined");
        }
        return this.match.group(n);
    }

    private String group(PyString pyString) {
        return this.group(this.getindex(pyString));
    }

    private PyObject group(PyObject pyObject) {
        String string;
        if (pyObject instanceof PyInteger) {
            string = this.group(((PyInteger)pyObject).getValue());
        } else if (pyObject instanceof PyString) {
            string = this.group((PyString)pyObject);
        } else {
            throw org.python.modules.re.ReError("group index must be a string or integer");
        }
        if (string == null) {
            return Py.None;
        }
        return new PyString(string);
    }

    public PyObject group(PyObject[] pyObjectArray) {
        int n = pyObjectArray.length;
        if (n == 0) {
            return new PyString(this.group(0));
        }
        if (n == 1) {
            return this.group(pyObjectArray[0]);
        }
        PyObject[] pyObjectArray2 = new PyObject[n];
        int n2 = 0;
        while (n2 < n) {
            pyObjectArray2[n2] = this.group(pyObjectArray[n2]);
            ++n2;
        }
        return new PyTuple(pyObjectArray2);
    }

    public PyObject groupdict() {
        return this.groupdict(Py.None);
    }

    public PyObject groupdict(PyObject pyObject) {
        PyDictionary pyDictionary = new PyDictionary();
        PyList pyList = this.re.groupindex.items();
        int n = 0;
        while (n < pyList.__len__()) {
            PyTuple pyTuple = (PyTuple)pyList.__getitem__(n);
            PyString pyString = (PyString)pyTuple.__getitem__(0);
            PyInteger pyInteger = (PyInteger)pyTuple.__getitem__(1);
            String string = this.group(pyInteger.getValue());
            if (string == null) {
                pyDictionary.__setitem__(pyString, pyObject);
            } else {
                pyDictionary.__setitem__(pyString, (PyObject)new PyString(string));
            }
            ++n;
        }
        return pyDictionary;
    }
}

